/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.parser;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.parser.VisitorContext;
import com.intellij.diagnostic.hprof.util.HProfReadBuffer;
import com.intellij.diagnostic.hprof.util.HProfReadBufferSlidingWindow;
import com.intellij.diagnostic.hprof.util.IDMapper;
import com.intellij.openapi.diagnostic.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u0007\u0018\u0000 ?2\u00060\u0001j\u0002`\u0002:\u0001?B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\rH\u0002J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\rJ\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\rH\u0002J\u0010\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u001dH\u0002J\b\u00105\u001a\u00020\u001dH\u0002J\b\u00106\u001a\u00020\bH\u0002J\b\u00107\u001a\u00020\bH\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020\rH\u0002J\b\u0010;\u001a\u00020\rH\u0002J\b\u0010<\u001a\u00020\bH\u0002J\b\u0010=\u001a\u00020\rH\u0002J\b\u0010>\u001a\u00020\rH\u0002R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "fileChannel", "Ljava/nio/channels/FileChannel;", "<init>", "(Ljava/nio/channels/FileChannel;)V", "value", "", "idSize", "getIdSize", "()I", "reparsePosition", "", "idMapper", "Lcom/intellij/diagnostic/hprof/util/IDMapper;", "buffer", "Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "getBuffer", "()Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "heapRecordPosition", "close", "", "setIDMapper", "initialParse", "accept", "visitor", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "description", "", "skip", "count", "acceptHeapDumpSegment", "length", "acceptHeapDumpRecord", "heapDumpRecordType", "Lcom/intellij/diagnostic/hprof/parser/HeapDumpRecordType;", "skipHeapDumpRecord", "saveHeapRecordPosition", "position", "acceptInstanceDump", "acceptObjectArrayDump", "acceptPrimitiveArrayDump", "acceptClassDump", "remap", "id", "readTypeSizeValue", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "getElementTypeSize", "readNonNullTerminatedString", "verifyFormat", "version", "readNullTerminatedString", "readInt", "readUnsignedByte", "readByte", "", "readLong", "readUnsignedInt", "readUnsignedShort", "readRawId", "readId", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHProfEventBasedParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfEventBasedParser.kt\ncom/intellij/diagnostic/hprof/parser/HProfEventBasedParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,410:1\n13#2:411\n*S KotlinDebug\n*F\n+ 1 HProfEventBasedParser.kt\ncom/intellij/diagnostic/hprof/parser/HProfEventBasedParser\n*L\n32#1:411\n*E\n"})
public final class HProfEventBasedParser
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int idSize;
    private long reparsePosition;
    @Nullable
    private IDMapper idMapper;
    @NotNull
    private final HProfReadBuffer buffer;
    private long heapRecordPosition;
    @NotNull
    private static final Logger LOG;

    public HProfEventBasedParser(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
        this.buffer = new HProfReadBufferSlidingWindow(fileChannel, this);
        this.initialParse();
    }

    public final int getIdSize() {
        return this.idSize;
    }

    @NotNull
    public final HProfReadBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public final void setIDMapper(@NotNull IDMapper idMapper) {
        Intrinsics.checkNotNullParameter((Object)idMapper, (String)"idMapper");
        this.idMapper = idMapper;
    }

    private final void initialParse() {
        this.buffer.position(0L);
        this.verifyFormat(this.readNullTerminatedString());
        this.idSize = this.readInt();
        this.buffer.setIdSize(this.idSize);
        this.readLong();
        this.reparsePosition = this.buffer.position();
    }

    public final void accept(@NotNull HProfVisitor visitor, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createStarted(...)");
        Stopwatch stopwatch2 = stopwatch;
        this.buffer.position(this.reparsePosition);
        visitor.setVisitorContext(new VisitorContext(this){
            final /* synthetic */ HProfEventBasedParser this$0;
            {
                this.this$0 = $receiver;
            }

            public long getCurrentHeapRecordOffset() {
                return HProfEventBasedParser.access$getHeapRecordPosition$p(this.this$0);
            }

            public int getIdSize() {
                return this.this$0.getIdSize();
            }
        });
        visitor.preVisit();
        block15: while (!this.buffer.isEof()) {
            int tag = this.readUnsignedByte();
            this.readInt();
            long length = this.readUnsignedInt();
            RecordType recordType = RecordType.Companion.fromInt(tag);
            if (!visitor.isEnabled(recordType)) {
                this.skip(length);
                continue;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[recordType.ordinal()]) {
                case 1: {
                    visitor.visitStringInUTF8(this.readRawId(), this.readNonNullTerminatedString(length - (long)this.idSize));
                    continue block15;
                }
                case 2: {
                    visitor.visitLoadClass(this.readUnsignedInt(), this.readId(), this.readUnsignedInt(), this.readRawId());
                    continue block15;
                }
                case 3: {
                    visitor.visitUnloadClass(this.readUnsignedInt());
                    continue block15;
                }
                case 4: 
                case 5: {
                    this.acceptHeapDumpSegment(visitor, length);
                    continue block15;
                }
                case 6: {
                    visitor.visitHeapDumpEnd();
                    continue block15;
                }
                case 7: {
                    visitor.visitHeapSummary(this.readUnsignedInt(), this.readUnsignedInt(), this.readLong(), this.readLong());
                    continue block15;
                }
                case 8: {
                    visitor.visitAllocSites();
                    this.skip(length);
                    continue block15;
                }
                case 9: {
                    visitor.visitEndThread(this.readUnsignedInt());
                    continue block15;
                }
                case 10: {
                    visitor.visitStackFrame(this.readRawId(), this.readRawId(), this.readRawId(), this.readRawId(), this.readUnsignedInt(), this.readInt());
                    continue block15;
                }
                case 11: {
                    long stackTraceSerialNumber = this.readUnsignedInt();
                    long threadSerialNumber = this.readUnsignedInt();
                    int numberOfFrames = this.readInt();
                    int n = 0;
                    long[] lArray = new long[numberOfFrames];
                    while (n < numberOfFrames) {
                        int n2 = n++;
                        lArray[n2] = this.readRawId();
                    }
                    long[] frameIds = lArray;
                    visitor.visitStackTrace(stackTraceSerialNumber, threadSerialNumber, numberOfFrames, frameIds);
                    continue block15;
                }
                case 12: {
                    visitor.visitCPUSamples();
                    this.skip(length);
                    continue block15;
                }
                case 13: {
                    visitor.visitStartThread();
                    this.skip(length);
                    continue block15;
                }
                case 14: {
                    visitor.visitControlSettings();
                    this.skip(length);
                    continue block15;
                }
            }
            throw new RuntimeException("Invalid format.");
        }
        visitor.postVisit();
        String string = description;
        LOG.info("HProfEventBasedParser" + (String)(string != null ? " - " + string : "") + ": " + stopwatch2);
    }

    private final void skip(long count) {
        this.buffer.position(this.buffer.position() + count);
    }

    private final void acceptHeapDumpSegment(HProfVisitor visitor, long length) {
        visitor.visitHeapDump();
        long segmentEndPosition = this.buffer.position() + length;
        long currentPosition = this.buffer.position();
        while (currentPosition < segmentEndPosition) {
            int type = this.readUnsignedByte();
            HeapDumpRecordType heapDumpRecordType = HeapDumpRecordType.Companion.fromInt(type);
            if (visitor.isEnabled(heapDumpRecordType)) {
                this.saveHeapRecordPosition(currentPosition);
                this.acceptHeapDumpRecord(heapDumpRecordType, visitor);
            } else {
                this.skipHeapDumpRecord(heapDumpRecordType);
            }
            currentPosition = this.buffer.position();
        }
    }

    public final void acceptHeapDumpRecord(@NotNull HeapDumpRecordType heapDumpRecordType, @NotNull HProfVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)((Object)heapDumpRecordType), (String)"heapDumpRecordType");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        switch (WhenMappings.$EnumSwitchMapping$1[heapDumpRecordType.ordinal()]) {
            case 1: {
                visitor.visitRootUnknown(this.readId());
                break;
            }
            case 2: {
                visitor.visitRootGlobalJNI(this.readId(), this.readRawId());
                break;
            }
            case 3: {
                visitor.visitRootLocalJNI(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 4: {
                visitor.visitRootJavaFrame(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 5: {
                visitor.visitRootNativeStack(this.readId(), this.readUnsignedInt());
                break;
            }
            case 6: {
                visitor.visitRootStickyClass(this.readId());
                break;
            }
            case 7: {
                visitor.visitRootThreadBlock(this.readId(), this.readUnsignedInt());
                break;
            }
            case 8: {
                visitor.visitRootMonitorUsed(this.readId());
                break;
            }
            case 9: {
                visitor.visitRootThreadObject(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 10: {
                this.acceptClassDump(visitor);
                break;
            }
            case 11: {
                this.acceptInstanceDump(visitor);
                break;
            }
            case 12: {
                this.acceptObjectArrayDump(visitor);
                break;
            }
            case 13: {
                this.acceptPrimitiveArrayDump(visitor);
                break;
            }
            default: {
                throw new IOException("Unknown heap dump record type: " + heapDumpRecordType);
            }
        }
    }

    private final void skipHeapDumpRecord(HeapDumpRecordType heapDumpRecordType) {
        switch (WhenMappings.$EnumSwitchMapping$1[heapDumpRecordType.ordinal()]) {
            case 1: {
                this.skip(this.idSize);
                break;
            }
            case 2: {
                this.skip(this.idSize * 2);
                break;
            }
            case 3: {
                this.skip(this.idSize + 8);
                break;
            }
            case 4: {
                this.skip(this.idSize + 8);
                break;
            }
            case 5: {
                this.skip(this.idSize + 4);
                break;
            }
            case 6: {
                this.skip(this.idSize);
                break;
            }
            case 7: {
                this.skip(this.idSize + 4);
                break;
            }
            case 8: {
                this.skip(this.idSize);
                break;
            }
            case 9: {
                this.skip(this.idSize + 8);
                break;
            }
            case 10: {
                int i2;
                this.skip(7 * this.idSize + 8);
                int toSkip = this.readUnsignedShort();
                int n = toSkip;
                for (i2 = 0; i2 < n; ++i2) {
                    this.skip(2L);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                }
                toSkip = this.readUnsignedShort();
                n = toSkip;
                for (i2 = 0; i2 < n; ++i2) {
                    this.skip(this.idSize);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                }
                toSkip = this.readUnsignedShort();
                this.skip(toSkip * (this.idSize + 1));
                break;
            }
            case 11: {
                this.skip(this.idSize * 2 + 4);
                long remainingBytes = this.readUnsignedInt();
                this.skip(remainingBytes);
                break;
            }
            case 12: {
                this.skip(this.idSize + 4);
                long objectArraySize = this.readUnsignedInt();
                this.skip((long)this.idSize * (objectArraySize + 1L));
                break;
            }
            case 13: {
                this.skip(this.idSize + 4);
                long primitiveArraySize = this.readUnsignedInt();
                byte elementTypeID = this.readByte();
                this.skip(primitiveArraySize * (long)Type.Companion.getType(elementTypeID).getSize());
                break;
            }
            default: {
                throw new IOException("Unknown heap dump record type: " + heapDumpRecordType);
            }
        }
    }

    private final void saveHeapRecordPosition(long position2) {
        this.heapRecordPosition = position2;
    }

    private final void acceptInstanceDump(HProfVisitor visitor) {
        long objectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long classObjectId = this.readId();
        int remainingBytes = this.readInt();
        ByteBuffer byteBuffer = this.buffer.getByteBuffer(remainingBytes);
        visitor.visitInstanceDump(objectId, stackTraceSerialNumber, classObjectId, byteBuffer);
    }

    private final void acceptObjectArrayDump(HProfVisitor visitor) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        long arrayClassObjectId = this.readId();
        long[] objects = new long[(int)numberOfElements];
        int n = objects.length;
        for (int i2 = 0; i2 < n; ++i2) {
            objects[i2] = this.readId();
        }
        visitor.visitObjectArrayDump(arrayObjectId, stackTraceSerialNumber, arrayClassObjectId, objects);
    }

    private final void acceptPrimitiveArrayDump(HProfVisitor visitor) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        int elementTypeId = this.readUnsignedByte();
        Type elementType = Type.Companion.getType(elementTypeId);
        ByteBuffer primitiveArrayData = this.buffer.getByteBuffer((int)(numberOfElements * (long)elementType.getSize()));
        visitor.visitPrimitiveArrayDump(arrayObjectId, stackTraceSerialNumber, numberOfElements, elementType, primitiveArrayData);
    }

    private final void acceptClassDump(HProfVisitor visitor) {
        int n;
        long classId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long superClassId = this.readId();
        long classloaderClassId = this.readId();
        this.skip(this.idSize * 4);
        long instanceSize = this.readUnsignedInt();
        int countOfConstantPool = this.readUnsignedShort();
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[countOfConstantPool];
        for (int j = 0; j < countOfConstantPool; ++j) {
            n = j;
            int constantPoolIndex = this.readUnsignedShort();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value = this.readTypeSizeValue(elementType);
            constantPoolEntryArray[n] = elementType == Type.OBJECT ? new ConstantPoolEntry(constantPoolIndex, elementType, this.remap(value)) : new ConstantPoolEntry(constantPoolIndex, elementType, value);
        }
        ConstantPoolEntry[] constants = constantPoolEntryArray;
        int countOfStaticFields = this.readUnsignedShort();
        StaticFieldEntry[] constantPoolIndex = new StaticFieldEntry[countOfStaticFields];
        for (n = 0; n < countOfStaticFields; ++n) {
            int n2 = n;
            long staticFieldStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value = this.readTypeSizeValue(elementType);
            constantPoolIndex[n2] = elementType == Type.OBJECT ? new StaticFieldEntry(staticFieldStringId, elementType, this.remap(value)) : new StaticFieldEntry(staticFieldStringId, elementType, value);
        }
        StaticFieldEntry[] staticFields = constantPoolIndex;
        int countOfInstanceFields = this.readUnsignedShort();
        int n3 = 0;
        InstanceFieldEntry[] instanceFieldEntryArray = new InstanceFieldEntry[countOfInstanceFields];
        while (n3 < countOfInstanceFields) {
            int n4 = n3++;
            long fieldNameStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            instanceFieldEntryArray[n4] = new InstanceFieldEntry(fieldNameStringId, elementType);
        }
        InstanceFieldEntry[] instanceFields = instanceFieldEntryArray;
        visitor.visitClassDump(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields);
    }

    public final long remap(long id2) {
        if (id2 == 0L) {
            return 0L;
        }
        IDMapper iDMapper = this.idMapper;
        return iDMapper != null ? iDMapper.getID(id2) : id2;
    }

    private final long readTypeSizeValue(Type elementType) {
        if (elementType == Type.OBJECT) {
            return this.readRawId();
        }
        switch (this.getElementTypeSize(elementType)) {
            case 1: {
                return this.buffer.get();
            }
            case 2: {
                return this.buffer.getShort();
            }
            case 4: {
                return this.buffer.getInt();
            }
            case 8: {
                return this.buffer.getLong();
            }
        }
        throw new IllegalArgumentException("Invalid size of element type.");
    }

    private final int getElementTypeSize(Type elementType) {
        return elementType == Type.OBJECT ? this.idSize : elementType.getSize();
    }

    private final String readNonNullTerminatedString(long length) {
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Strings larger then 2GB not supported.");
        }
        byte[] bytes = new byte[(int)length];
        this.buffer.get(bytes);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    private final void verifyFormat(String version) {
        if (!Intrinsics.areEqual((Object)version, (Object)"JAVA PROFILE 1.0.1") && !Intrinsics.areEqual((Object)version, (Object)"JAVA PROFILE 1.0.2")) {
            throw new RuntimeException("Invalid format. Got: " + version);
        }
    }

    private final String readNullTerminatedString() {
        byte c = 0;
        long initialPosition = this.buffer.position();
        while ((c = this.buffer.get()) > 0) {
        }
        if (c == -1) {
            throw new EOFException();
        }
        byte[] bytes = new byte[(int)(this.buffer.position() - initialPosition - 1L)];
        this.buffer.position(initialPosition);
        this.buffer.get(bytes);
        this.buffer.get();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    private final int readInt() {
        return this.buffer.getInt();
    }

    private final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    private final byte readByte() {
        return this.buffer.get();
    }

    private final long readLong() {
        return this.buffer.getLong();
    }

    private final long readUnsignedInt() {
        return this.buffer.getUnsignedInt();
    }

    private final int readUnsignedShort() {
        return this.buffer.getUnsignedShort();
    }

    private final long readRawId() {
        return this.buffer.getRawId();
    }

    private final long readId() {
        return this.buffer.getId();
    }

    public static final /* synthetic */ long access$getHeapRecordPosition$p(HProfEventBasedParser $this) {
        return $this.heapRecordPosition;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(HProfEventBasedParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RecordType.values().length];
            try {
                nArray[RecordType.StringInUTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.LoadClass.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.UnloadClass.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDumpSegment.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDump.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDumpEnd.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapSummary.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.AllocSites.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.EndThread.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StackFrame.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StackTrace.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.CPUSamples.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StartThread.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.ControlSettings.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HeapDumpRecordType.values().length];
            try {
                nArray[HeapDumpRecordType.RootUnknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootGlobalJNI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootLocalJNI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootJavaFrame.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootNativeStack.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootStickyClass.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootThreadBlock.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootMonitorUsed.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootThreadObject.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.ClassDump.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.InstanceDump.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.ObjectArrayDump.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.PrimitiveArrayDump.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

