/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.opentelemetry;

import com.intellij.diagnostic.opentelemetry.OTelMetricsFreezeProfiler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"MAX_METRICS_LINES_TO_ATTACH", "", "collectOpenTelemetryReports", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "listMetricsFiles", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nOTelMetricsFreezeProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OTelMetricsFreezeProfiler.kt\ncom/intellij/diagnostic/opentelemetry/OTelMetricsFreezeProfilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n1999#2,14:72\n13#3:86\n*S KotlinDebug\n*F\n+ 1 OTelMetricsFreezeProfiler.kt\ncom/intellij/diagnostic/opentelemetry/OTelMetricsFreezeProfilerKt\n*L\n49#1:72,14\n62#1:86\n*E\n"})
public final class OTelMetricsFreezeProfilerKt {
    private static final int MAX_METRICS_LINES_TO_ATTACH;

    private static final List<Attachment> collectOpenTelemetryReports() {
        Path logDir = Path.of(PathManager.getLogPath(), new String[0]);
        if (!Files.isDirectory(logDir, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        try {
            Object v0;
            Iterable $this$maxByOrNull$iv = OTelMetricsFreezeProfilerKt.listMetricsFiles();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Path it = (Path)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = it.getFileName();
                    do {
                        Object e$iv = iterator$iv.next();
                        Path it2 = (Path)e$iv;
                        $i$a$-maxByOrNull-OTelMetricsFreezeProfilerKt$collectOpenTelemetryReports$mostRecentFile$1 = false;
                        Comparable v$iv = it2.getFileName();
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Path path = v0;
            if (path == null) {
                return CollectionsKt.emptyList();
            }
            Path mostRecentFile = path;
            List<String> lines = Files.readAllLines(mostRecentFile);
            Intrinsics.checkNotNull(lines);
            String tailLines = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast(lines, (int)MAX_METRICS_LINES_TO_ATTACH), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            return CollectionsKt.listOf((Object)new Attachment(((Object)mostRecentFile.getFileName()).toString(), tailLines));
        }
        catch (IOException ex) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(OTelMetricsFreezeProfiler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("Error reading most recent open-telemetry-metrics.csv file", (Throwable)ex);
            return CollectionsKt.emptyList();
        }
    }

    private static final List<Path> listMetricsFiles() {
        Path path = OpenTelemetryUtils.INSTANCE.metricsCsvReportingPath();
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path metricsReportingPath = path;
        List list2 = OpenTelemetryUtils.INSTANCE.setupFileLimiterForMetrics(metricsReportingPath).listExistentFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"listExistentFiles(...)");
        return list2;
    }

    public static final /* synthetic */ List access$collectOpenTelemetryReports() {
        return OTelMetricsFreezeProfilerKt.collectOpenTelemetryReports();
    }

    static {
        String string = System.getProperty("idea.freeze.otel.max-metrics-lines-to-attach", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        MAX_METRICS_LINES_TO_ATTACH = n != null ? n : 5000;
    }
}

