/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystem;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemKt;
import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapterKt;
import com.intellij.platform.core.nio.fs.BasicFileAttributesHolder2;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010#\u001a\u00020\u0001H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0001H\u0016J!\u0010)\u001a\u00020\u00012\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,H\u0016\u00a2\u0006\u0002\u0010-JA\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003030+2\u0016\u00104\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001050+\"\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106J\u0011\u00107\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0001H\u0096\u0002J\b\u00108\u001a\u000209H\u0016J\u0013\u0010:\u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\u001aH\u0016J\b\u0010=\u001a\u00020>H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006?"}, d2={"Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwarePath;", "Ljava/nio/file/Path;", "Lcom/intellij/platform/core/nio/fs/BasicFileAttributesHolder2$Impl;", "fileSystem", "Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem;", "rootPath", "originalPath", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "<init>", "(Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem;Ljava/nio/file/Path;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;)V", "getRootPath", "()Ljava/nio/file/Path;", "getOriginalPath", "()Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "getFileSystem", "Ljava/nio/file/FileSystem;", "actualPath", "getActualPath", "invalidate", "", "isAbsolute", "", "getRoot", "getFileName", "getParent", "getNameCount", "", "getName", "index", "subpath", "beginIndex", "endIndex", "startsWith", "other", "endsWith", "normalize", "resolve", "relativize", "toUri", "Ljava/net/URI;", "toAbsolutePath", "toRealPath", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "register", "Ljava/nio/file/WatchKey;", "watcher", "Ljava/nio/file/WatchService;", "events", "Ljava/nio/file/WatchEvent$Kind;", "modifiers", "Ljava/nio/file/WatchEvent$Modifier;", "(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;", "compareTo", "toFile", "Ljava/io/File;", "equals", "", "hashCode", "toString", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjentEphemeralRootAwareFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentEphemeralRootAwareFileSystem.kt\ncom/intellij/execution/ijent/nio/IjentEphemeralRootAwarePath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class IjentEphemeralRootAwarePath
extends BasicFileAttributesHolder2.Impl
implements Path {
    @NotNull
    private final IjentEphemeralRootAwareFileSystem fileSystem;
    @NotNull
    private final Path rootPath;
    @NotNull
    private final IjentNioPath originalPath;
    @NotNull
    private final Path actualPath;

    public IjentEphemeralRootAwarePath(@NotNull IjentEphemeralRootAwareFileSystem fileSystem, @NotNull Path rootPath, @NotNull IjentNioPath originalPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystem), (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        super(IjentNioPosixFileAttributesWithDosAdapterKt.getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded(originalPath));
        this.fileSystem = fileSystem;
        this.rootPath = rootPath;
        this.originalPath = originalPath;
        this.actualPath = EelPathUtils.getActualPath((Path)this.originalPath);
    }

    @NotNull
    public final Path getRootPath() {
        return this.rootPath;
    }

    @NotNull
    public final IjentNioPath getOriginalPath() {
        return this.originalPath;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return (FileSystem)((Object)this.fileSystem);
    }

    @NotNull
    public final Path getActualPath() {
        return this.actualPath;
    }

    public void invalidate() {
        this.originalPath.invalidate();
        super.invalidate();
    }

    @Override
    public boolean isAbsolute() {
        return this.originalPath.isAbsolute();
    }

    @Override
    @Nullable
    public Path getRoot() {
        IjentEphemeralRootAwarePath ijentEphemeralRootAwarePath;
        IjentNioPath ijentNioPath = this.originalPath.getRoot();
        if (ijentNioPath != null) {
            IjentNioPath it = ijentNioPath;
            boolean bl = false;
            ijentEphemeralRootAwarePath = new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, it);
        } else {
            ijentEphemeralRootAwarePath = null;
        }
        return ijentEphemeralRootAwarePath;
    }

    @Override
    @Nullable
    public Path getFileName() {
        return this.originalPath.getFileName();
    }

    @Override
    @Nullable
    public Path getParent() {
        IjentNioPath ijentNioPath = this.originalPath.getParent();
        if (ijentNioPath == null) {
            return null;
        }
        IjentNioPath parent = ijentNioPath;
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, parent);
    }

    @Override
    public int getNameCount() {
        return this.originalPath.getNameCount();
    }

    @Override
    @NotNull
    public Path getName(int index) {
        Path path = this.originalPath.getName(index);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getName(...)");
        return path;
    }

    @Override
    @NotNull
    public Path subpath(int beginIndex, int endIndex) {
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, this.originalPath.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap(other);
        return this.originalPath.startsWith(other2 instanceof IjentEphemeralRootAwarePath ? (Path)((IjentEphemeralRootAwarePath)other2).originalPath : other2);
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap(other);
        return this.originalPath.endsWith(other2 instanceof IjentEphemeralRootAwarePath ? (Path)((IjentEphemeralRootAwarePath)other2).originalPath : other2);
    }

    @Override
    @NotNull
    public Path normalize() {
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, this.originalPath.normalize());
    }

    @Override
    @NotNull
    public Path resolve(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap(other);
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, this.originalPath.resolve(other2 instanceof IjentEphemeralRootAwarePath ? (Path)((IjentEphemeralRootAwarePath)other2).originalPath : other2));
    }

    @Override
    @NotNull
    public Path relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap(other);
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, this.originalPath.relativize(other2 instanceof IjentEphemeralRootAwarePath ? (Path)((IjentEphemeralRootAwarePath)other2).originalPath : other2));
    }

    @Override
    @NotNull
    public URI toUri() {
        URI uRI = this.rootPath.resolve(StringsKt.removePrefix((String)((Object)this.originalPath).toString(), (CharSequence)"/")).toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    @Override
    @NotNull
    public Path toAbsolutePath() {
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, this.originalPath.toAbsolutePath());
    }

    @Override
    @NotNull
    public Path toRealPath(LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (!this.isAbsolute()) {
            Path path = this.toAbsolutePath().toRealPath(Arrays.copyOf(options2, options2.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toRealPath(...)");
            return path;
        }
        if (Intrinsics.areEqual((Object)((Object)this.normalize()).toString(), (Object)((Object)this.rootPath).toString())) {
            return this;
        }
        IjentNioPath ijentNioRealPath = !Intrinsics.areEqual((Object)this.originalPath, (Object)this.actualPath) ? this.originalPath.normalize() : this.originalPath.toRealPath(Arrays.copyOf(options2, options2.length));
        return new IjentEphemeralRootAwarePath(this.fileSystem, this.rootPath, ijentNioRealPath);
    }

    @Override
    @NotNull
    public WatchKey register(@NotNull WatchService watcher, @NotNull WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        WatchKey watchKey = this.actualPath.register(watcher, events, Arrays.copyOf(modifiers, modifiers.length));
        Intrinsics.checkNotNullExpressionValue((Object)watchKey, (String)"register(...)");
        return watchKey;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap(other);
        return this.originalPath.compareTo(other2 instanceof IjentEphemeralRootAwarePath ? (Path)((IjentEphemeralRootAwarePath)other2).originalPath : other2);
    }

    @Override
    @NotNull
    public File toFile() {
        File file2 = this.originalPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Path)) {
            return false;
        }
        Path other2 = IjentEphemeralRootAwareFileSystemKt.access$unwrap((Path)other);
        if (!(other2 instanceof IjentEphemeralRootAwarePath)) {
            return false;
        }
        return IjentEphemeralRootAwareFileSystemKt.access$pathEqual(this, (IjentEphemeralRootAwarePath)other2);
    }

    @Override
    public int hashCode() {
        int result2 = ((Object)this.rootPath).hashCode();
        result2 = 31 * result2 + this.originalPath.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.isAbsolute() ? ((Object)this.rootPath.resolve(StringsKt.removePrefix((String)((Object)this.originalPath).toString(), (CharSequence)"/"))).toString() : this.originalPath.toString();
    }
}

