/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.diagnostic.PluginException;
import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageEvent;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.Function;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance(ProductivityFeaturesRegistryImpl.class);
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final List<FeatureUsageEvent.Action> myActionEvents = new ArrayList<FeatureUsageEvent.Action>();
    private final List<FeatureUsageEvent.Intention> myIntentionEvents = new ArrayList<FeatureUsageEvent.Intention>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<ApplicabilityFiltersData> myApplicabilityFilters = new ArrayList<ApplicabilityFiltersData>();
    private final List<ConfigurationSource> myFeatureConfigurationSources = List.of(new ConfigurationSource("PlatformProductivityFeatures.xml", true), new ConfigurationSource("ProductivityFeaturesRegistry.xml", true), new ConfigurationSource("IdeSpecificFeatures.xml", false));
    private boolean myAdditionalFeaturesLoaded;
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
        ProductivityFeaturesProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ProductivityFeaturesProvider>(){

            public void extensionRemoved(@NotNull ProductivityFeaturesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProductivityFeaturesRegistryImpl.this.removeProvidedFeatures(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void reloadFromXml() {
        for (ConfigurationSource source : this.myFeatureConfigurationSources) {
            boolean found;
            try {
                found = this.readFromXml(source.path);
            }
            catch (Throwable e) {
                LOG.error(e);
                found = false;
            }
            if (!source.isRequired || found || ApplicationManager.getApplication().isUnitTestMode()) continue;
            LOG.error(source.path + " not found");
        }
    }

    private boolean readFromXml(@NotNull @NonNls String path) throws JDOMException, IOException {
        if (path == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(0);
        }
        return this.readFromXml(path, ProductivityFeaturesRegistryImpl.class.getClassLoader(), null);
    }

    private boolean readFromXml(@NotNull String path, @NotNull ClassLoader classLoader, @Nullable ProductivityFeaturesProvider provider) throws JDOMException, IOException {
        byte[] data2;
        if (path == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(1);
        }
        if (classLoader == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(2);
        }
        if ((data2 = ResourceUtil.getResourceAsBytes((String)path, (ClassLoader)classLoader, (boolean)true)) == null) {
            return false;
        }
        Element root = JDOMUtil.load((byte[])data2);
        for (Element groupElement : root.getChildren(TAG_GROUP)) {
            this.readGroup(groupElement, provider);
        }
        return true;
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.myAdditionalFeaturesLoaded = true;
        ProductivityFeaturesProvider.EP_NAME.processWithPluginDescriptor((provider, pluginDescriptor) -> {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptors;
            for (GroupDescriptor[] xmlUrl : provider.getXmlFilesUrls()) {
                try {
                    this.readFromXml(Strings.trimStart((String)xmlUrl, (String)"/"), pluginDescriptor.getClassLoader(), (ProductivityFeaturesProvider)provider);
                }
                catch (Exception e) {
                    LOG.error((Throwable)new PluginException("Error while reading " + (String)xmlUrl + " from " + String.valueOf(provider) + ": " + e.getMessage(), pluginDescriptor.getPluginId()));
                }
            }
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.putIfAbsent(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptors = provider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptors) {
                    this.addFeature(featureDescriptor);
                }
            }
            if ((applicabilityFilters = provider.getApplicabilityFilters()) != null) {
                this.myApplicabilityFilters.add(new ApplicabilityFiltersData((ProductivityFeaturesProvider)provider, applicabilityFilters));
            }
            return Unit.INSTANCE;
        });
    }

    private void addUsageEvents(FeatureDescriptor featureDescriptor) {
        this.myActionEvents.addAll(featureDescriptor.getActionEvents());
        this.myIntentionEvents.addAll(featureDescriptor.getIntentionEvents());
    }

    private void readGroup(Element groupElement, ProductivityFeaturesProvider provider) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId = groupDescriptor.getId();
        this.myGroups.putIfAbsent(groupId, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor, provider);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor, ProductivityFeaturesProvider provider) {
        for (Element featureElement : groupElement.getChildren(TAG_FEATURE)) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor, provider, featureElement);
            this.addFeature(featureDescriptor);
        }
    }

    private void addFeature(@NotNull FeatureDescriptor descriptor2) {
        FeatureDescriptor existingDescriptor;
        if (descriptor2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(3);
        }
        if ((existingDescriptor = this.myFeatures.get(descriptor2.getId())) != null) {
            LOG.info("Feature with id '" + descriptor2.getId() + "' is overridden by: " + String.valueOf(descriptor2));
            descriptor2.copyStatistics(existingDescriptor);
        }
        this.myFeatures.put(descriptor2.getId(), descriptor2);
        this.addUsageEvents(descriptor2);
    }

    private void removeProvidedFeatures(@NotNull ProductivityFeaturesProvider provider) {
        if (provider == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(4);
        }
        Class<?> providerClass = provider.getClass();
        Set<String> featureIdsToRemove = this.myFeatures.entrySet().stream().filter(entry -> ((FeatureDescriptor)entry.getValue()).getProvider() == providerClass).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        featureIdsToRemove.forEach(id2 -> this.myFeatures.remove(id2));
        this.myActionEvents.removeIf(event -> featureIdsToRemove.contains(event.featureId()));
        this.myIntentionEvents.removeIf(event -> featureIdsToRemove.contains(event.featureId()));
        this.myApplicabilityFilters.removeIf(data2 -> data2.provider == provider);
        LOG.info("Removed features provided by " + providerClass.getName() + ": " + String.valueOf(featureIdsToRemove));
    }

    @Nullable
    private <T extends FeatureUsageEvent> FeatureDescriptor findFeatureByEvent(List<? extends T> events, Function<? super T, Boolean> eventChecker) {
        this.lazyLoadFromPluginsFeaturesProviders();
        return events.stream().filter(e -> (Boolean)eventChecker.fun(e)).findFirst().map(e -> this.getFeatureDescriptor(e.featureId())).orElse(null);
    }

    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        Set<String> set = this.myFeatures.keySet();
        if (set == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    public FeatureDescriptor getFeatureDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(6);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myFeatures.get(id2);
    }

    public GroupDescriptor getGroupDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(7);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id2);
    }

    public ApplicabilityFilter @NotNull [] getMatchingFilters(@NotNull String featureId) {
        if (featureId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(8);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        FeatureDescriptor descriptor2 = this.myFeatures.get(featureId);
        if (descriptor2 != null) {
            Class providerClass = descriptor2.getProvider();
            ApplicabilityFilter[] applicabilityFilterArray = this.myApplicabilityFilters.stream().filter(it -> it.provider.getClass() == providerClass).findFirst().map(it -> it.filters).orElse(new ApplicabilityFilter[0]);
            if (applicabilityFilterArray == null) {
                ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(9);
            }
            return applicabilityFilterArray;
        }
        return new ApplicabilityFilter[0];
    }

    @Nullable
    public FeatureDescriptor findFeatureByAction(@NotNull String actionId) {
        if (actionId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(10);
        }
        return this.findFeatureByEvent(this.myActionEvents, action2 -> actionId.equals(action2.getActionId()));
    }

    @Nullable
    public FeatureDescriptor findFeatureByIntention(@NotNull Class<?> intentionClass) {
        if (intentionClass == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(11);
        }
        return this.findFeatureByEvent(this.myIntentionEvents, intention -> intentionClass.getName().equals(intention.getIntentionClassName()));
    }

    @NonNls
    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    @TestOnly
    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureIds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFeature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProvidedFeatures";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingFilters";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9 -> new IllegalStateException(string);
        };
    }

    private record ConfigurationSource(@NotNull String path, boolean isRequired) {
        @NotNull
        private final String path;

        private ConfigurationSource(@NotNull String path, boolean isRequired) {
            if (path == null) {
                ConfigurationSource.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String path() {
            String string = this.path;
            if (string == null) {
                ConfigurationSource.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$ConfigurationSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$ConfigurationSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record ApplicabilityFiltersData(@NotNull ProductivityFeaturesProvider provider, ApplicabilityFilter @NotNull [] filters) {
        @NotNull
        private final ProductivityFeaturesProvider provider;
        private final ApplicabilityFilter @NotNull [] filters;

        private ApplicabilityFiltersData(@NotNull ProductivityFeaturesProvider provider, ApplicabilityFilter @NotNull [] filters) {
            if (provider == null) {
                ApplicabilityFiltersData.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                ApplicabilityFiltersData.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public ProductivityFeaturesProvider provider() {
            ProductivityFeaturesProvider productivityFeaturesProvider = this.provider;
            if (productivityFeaturesProvider == null) {
                ApplicabilityFiltersData.$$$reportNull$$$0(2);
            }
            return productivityFeaturesProvider;
        }

        public ApplicabilityFilter @NotNull [] filters() {
            if (this.filters == null) {
                ApplicabilityFiltersData.$$$reportNull$$$0(3);
            }
            return this.filters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$ApplicabilityFiltersData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$ApplicabilityFiltersData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

