/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CaretPositionKeeper;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiEditorUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EditorFormatterListener
implements CodeStyleManager.Listener {
    static final Key<EditorStateKeeper> EDITOR_STATE_KEY = Key.create((String)"formatter.caret.position.keeper");

    public void beforeReformatText(@NotNull PsiFile file2) {
        Editor editor2;
        if (file2 == null) {
            EditorFormatterListener.$$$reportNull$$$0(0);
        }
        if ((editor2 = PsiEditorUtil.findEditor((PsiElement)file2)) != null) {
            EditorStateKeeper editorStateKeeper = new EditorStateKeeper(editor2, CodeStyle.getSettings((PsiFile)file2), file2.getLanguage());
            file2.putUserData(EDITOR_STATE_KEY, (Object)editorStateKeeper);
        }
    }

    public void afterReformatText(@NotNull PsiFile file2) {
        EditorStateKeeper editorStateKeeper;
        if (file2 == null) {
            EditorFormatterListener.$$$reportNull$$$0(1);
        }
        if ((editorStateKeeper = (EditorStateKeeper)file2.getUserData(EDITOR_STATE_KEY)) != null) {
            file2.putUserData(EDITOR_STATE_KEY, null);
            editorStateKeeper.restoreState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/formatting/EditorFormatterListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeReformatText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "afterReformatText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class EditorStateKeeper {
        CaretPositionKeeper myCaretPositionKeeper;
        EditorScrollingPositionKeeper.ForDocument myScrollingPositionKeeper;

        private EditorStateKeeper(@NotNull Editor editor2, @NotNull CodeStyleSettings settings, @NotNull Language language) {
            if (editor2 == null) {
                EditorStateKeeper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                EditorStateKeeper.$$$reportNull$$$0(1);
            }
            if (language == null) {
                EditorStateKeeper.$$$reportNull$$$0(2);
            }
            this.myCaretPositionKeeper = new CaretPositionKeeper(editor2, settings, language);
            this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper.ForDocument(editor2.getDocument());
            this.myScrollingPositionKeeper.savePosition();
        }

        void restoreState() {
            try {
                this.myCaretPositionKeeper.restoreCaretPosition();
                this.myScrollingPositionKeeper.restorePosition(true);
            }
            finally {
                Disposer.dispose((Disposable)this.myScrollingPositionKeeper);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "language";
                    break;
                }
            }
            objectArray[1] = "com/intellij/formatting/EditorFormatterListener$EditorStateKeeper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

