/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.util.TextRange;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BlockRangesMap {
    private final LeafBlockWrapper myLastBlock;
    private final Int2ObjectMap<LeafBlockWrapper> myTextRangeToWrapper;

    public BlockRangesMap(LeafBlockWrapper first, LeafBlockWrapper last) {
        this.myLastBlock = last;
        this.myTextRangeToWrapper = BlockRangesMap.buildTextRangeToInfoMap(first);
    }

    private static Int2ObjectMap<LeafBlockWrapper> buildTextRangeToInfoMap(LeafBlockWrapper first) {
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        for (LeafBlockWrapper current = first; current != null; current = current.getNextBlock()) {
            result2.put(current.getStartOffset(), (Object)current);
        }
        return result2;
    }

    public boolean containsLineFeedsOrTooLong(TextRange dependency) {
        LeafBlockWrapper child = (LeafBlockWrapper)this.myTextRangeToWrapper.get(dependency.getStartOffset());
        if (child == null) {
            return false;
        }
        int endOffset = dependency.getEndOffset();
        int startOffset = child.getStartOffset();
        while (child != null && child.getEndOffset() < endOffset) {
            if (child.containsLineFeeds() || child.getStartOffset() - startOffset > 1000) {
                return true;
            }
            if ((child = child.getNextBlock()) == null || child.getWhiteSpace().getEndOffset() > endOffset || !child.getWhiteSpace().containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LeafBlockWrapper getBlockAtOrAfter(int startOffset) {
        LeafBlockWrapper prevBlock;
        LeafBlockWrapper result2 = null;
        for (int current = startOffset; current < this.myLastBlock.getEndOffset(); ++current) {
            LeafBlockWrapper currentValue = (LeafBlockWrapper)this.myTextRangeToWrapper.get(current);
            if (currentValue == null) continue;
            result2 = currentValue;
            break;
        }
        if ((prevBlock = this.getPrevBlock(result2)) != null && prevBlock.contains(startOffset)) {
            return prevBlock;
        }
        return result2;
    }

    @Nullable
    private LeafBlockWrapper getPrevBlock(@Nullable LeafBlockWrapper result2) {
        if (result2 != null) {
            return result2.getPreviousBlock();
        }
        return this.myLastBlock;
    }
}

