/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ActionMacro {
    private String myName;
    private final ArrayList<ActionDescriptor> myActions = new ArrayList();
    @NonNls
    public static final String MACRO_ACTION_PREFIX = "Macro.";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ELEMENT_TYPING = "typing";
    @NonNls
    private static final String ELEMENT_SHORTCUT = "shortuct";
    @NonNls
    private static final String ATTRIBUTE_TEXT = "text";
    @NonNls
    private static final String ATTRIBUTE_KEY_CODES = "text-keycode";
    @NonNls
    private static final String ELEMENT_ACTION = "action";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";

    public ActionMacro() {
    }

    public ActionMacro(String name2) {
        this.myName = name2;
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    public ActionDescriptor[] getActions() {
        return this.myActions.toArray(new ActionDescriptor[0]);
    }

    public void readExternal(Element macro) {
        this.setName(macro.getAttributeValue(ATTRIBUTE_NAME));
        for (Element action2 : macro.getChildren()) {
            if (ELEMENT_TYPING.equals(action2.getName())) {
                Couple<List<Integer>> codes = ActionMacro.parseKeyCodes(action2.getAttributeValue(ATTRIBUTE_KEY_CODES));
                String text2 = action2.getText();
                if (text2 == null || text2.isEmpty()) {
                    text2 = action2.getAttributeValue(ATTRIBUTE_TEXT);
                }
                if (StringUtil.isEmpty((String)(text2 = text2.replaceAll("&#x20;", " ")))) continue;
                this.myActions.add(new TypedDescriptor(text2, (List)codes.getFirst(), (List)codes.getSecond()));
                continue;
            }
            if (ELEMENT_ACTION.equals(action2.getName())) {
                this.myActions.add(new IdActionDescriptor(action2.getAttributeValue(ATTRIBUTE_ID)));
                continue;
            }
            if (!ELEMENT_SHORTCUT.equals(action2.getName())) continue;
            this.myActions.add(new ShortcutActionDescription(action2.getAttributeValue(ATTRIBUTE_TEXT)));
        }
    }

    private static Couple<List<Integer>> parseKeyCodes(String keyCodesText) {
        return KeyCodeTypeCommand.parseKeyCodes(keyCodesText);
    }

    public static String unparseKeyCodes(Couple<List<Integer>> keyCodes) {
        return KeyCodeTypeCommand.unparseKeyCodes(keyCodes);
    }

    public void writeExternal(Element macro) {
        ActionDescriptor[] actions;
        macro.setAttribute(ATTRIBUTE_NAME, this.myName);
        for (ActionDescriptor action2 : actions = this.getActions()) {
            Element actionNode = null;
            if (action2 instanceof TypedDescriptor) {
                TypedDescriptor typedDescriptor = (TypedDescriptor)action2;
                actionNode = new Element(ELEMENT_TYPING);
                actionNode.setText(typedDescriptor.getText().replaceAll(" ", "&#x20;"));
                actionNode.setAttribute(ATTRIBUTE_KEY_CODES, ActionMacro.unparseKeyCodes((Couple<List<Integer>>)Couple.of(typedDescriptor.getKeyCodes(), typedDescriptor.getKeyModifiers())));
            } else if (action2 instanceof IdActionDescriptor) {
                actionNode = new Element(ELEMENT_ACTION);
                actionNode.setAttribute(ATTRIBUTE_ID, ((IdActionDescriptor)action2).getActionId());
            } else if (action2 instanceof ShortcutActionDescription) {
                actionNode = new Element(ELEMENT_SHORTCUT);
                actionNode.setAttribute(ATTRIBUTE_TEXT, ((ShortcutActionDescription)action2).getText());
            }
            assert (actionNode != null) : action2;
            macro.addContent(actionNode);
        }
    }

    public String toString() {
        return this.myName;
    }

    protected ActionMacro clone() {
        ActionMacro copy2 = new ActionMacro(this.myName);
        for (int i2 = 0; i2 < this.myActions.size(); ++i2) {
            ActionDescriptor action2 = this.myActions.get(i2);
            copy2.myActions.add(action2.clone());
        }
        return copy2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionMacro)) {
            return false;
        }
        ActionMacro actionMacro = (ActionMacro)o;
        if (!this.myActions.equals(actionMacro.myActions)) {
            return false;
        }
        return this.myName.equals(actionMacro.myName);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 29 * result2 + this.myActions.hashCode();
        return result2;
    }

    public void deleteAction(int idx) {
        this.myActions.remove(idx);
    }

    public void appendAction(String actionId) {
        this.myActions.add(new IdActionDescriptor(actionId));
    }

    public void appendShortcut(String text2) {
        this.myActions.add(new ShortcutActionDescription(text2));
    }

    public void appendKeyPressed(char c, int keyCode, @JdkConstants.InputEventMask int modifiers) {
        ActionDescriptor lastAction;
        ActionDescriptor actionDescriptor = lastAction = !this.myActions.isEmpty() ? this.myActions.get(this.myActions.size() - 1) : null;
        if (lastAction instanceof TypedDescriptor) {
            ((TypedDescriptor)lastAction).addChar(c, keyCode, modifiers);
        } else {
            this.myActions.add(new TypedDescriptor(c, keyCode, modifiers));
        }
    }

    public String getActionId() {
        return MACRO_ACTION_PREFIX + this.myName;
    }

    public static interface ActionDescriptor {
        public ActionDescriptor clone();

        public void playBack(DataContext var1);

        public void generateTo(StringBuffer var1);
    }

    public static final class TypedDescriptor
    implements ActionDescriptor {
        private String myText;
        private final List<Integer> myKeyCodes;
        private final List<Integer> myModifiers;

        public TypedDescriptor(@NotNull String text2, List<Integer> keyCodes, List<Integer> modifiers) {
            if (text2 == null) {
                TypedDescriptor.$$$reportNull$$$0(0);
            }
            this.myKeyCodes = new ArrayList<Integer>();
            this.myModifiers = new ArrayList<Integer>();
            this.myText = text2;
            this.myKeyCodes.addAll(keyCodes);
            this.myModifiers.addAll(modifiers);
            assert (this.myKeyCodes.size() == this.myModifiers.size()) : "codes=" + String.valueOf(this.myKeyCodes) + " modifiers=" + String.valueOf(this.myModifiers);
        }

        public TypedDescriptor(char c, int keyCode, @JdkConstants.InputEventMask int modifiers) {
            this.myKeyCodes = new ArrayList<Integer>();
            this.myModifiers = new ArrayList<Integer>();
            this.myText = String.valueOf(c);
            this.myKeyCodes.add(keyCode);
            this.myModifiers.add(modifiers);
        }

        public void addChar(char c, int keyCode, @JdkConstants.InputEventMask int modifier) {
            this.myText = this.myText + c;
            this.myKeyCodes.add(keyCode);
            this.myModifiers.add(modifier);
        }

        public String getText() {
            return this.myText;
        }

        @Override
        public TypedDescriptor clone() {
            return new TypedDescriptor(this.myText, this.myKeyCodes, this.myModifiers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypedDescriptor)) {
                return false;
            }
            return this.myText.equals(((TypedDescriptor)o).myText);
        }

        public int hashCode() {
            return this.myText.hashCode();
        }

        @Override
        public void generateTo(StringBuffer script) {
            if (TypeCommand.containsUnicode(this.myText)) {
                script.append("%type").append(" ");
                for (int i2 = 0; i2 < this.myKeyCodes.size(); ++i2) {
                    Integer each = this.myKeyCodes.get(i2);
                    script.append(each.toString());
                    script.append(":");
                    script.append(this.myModifiers.get(i2));
                    if (i2 >= this.myKeyCodes.size() - 1) continue;
                    script.append(";");
                }
                script.append(" ").append(this.myText).append("\n");
            } else {
                script.append(this.myText);
                script.append("\n");
            }
        }

        public String toString() {
            return IdeBundle.message((String)"action.descriptor.typing", (Object[])new Object[]{this.myText});
        }

        @Override
        public void playBack(DataContext context2) {
            Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2);
            if (editor2 != null) {
                EditorActionManager.getInstance();
                TypedAction typedAction = TypedAction.getInstance();
                for (char aChar : this.myText.toCharArray()) {
                    typedAction.actionPerformed(editor2, aChar, context2);
                }
            }
        }

        public List<Integer> getKeyCodes() {
            return this.myKeyCodes;
        }

        public List<Integer> getKeyModifiers() {
            return this.myModifiers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ActionMacro.ATTRIBUTE_TEXT, "com/intellij/ide/actionMacro/ActionMacro$TypedDescriptor", "<init>"));
        }
    }

    public static final class IdActionDescriptor
    implements ActionDescriptor {
        private final String actionId;

        public IdActionDescriptor(String id2) {
            this.actionId = id2;
        }

        public String getActionId() {
            return this.actionId;
        }

        public String toString() {
            return IdeBundle.message((String)"action.descriptor.action", (Object[])new Object[]{this.actionId});
        }

        @Override
        public IdActionDescriptor clone() {
            return new IdActionDescriptor(this.actionId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdActionDescriptor)) {
                return false;
            }
            return this.actionId.equals(((IdActionDescriptor)o).actionId);
        }

        public int hashCode() {
            return this.actionId.hashCode();
        }

        @Override
        public void playBack(DataContext context2) {
            AnAction action2 = ActionManager.getInstance().getAction(this.getActionId());
            if (action2 == null) {
                return;
            }
            Presentation presentation2 = action2.getTemplatePresentation().clone();
            AnActionEvent event = new AnActionEvent(null, context2, "MACRO_PLAYBACK", presentation2, ActionManager.getInstance(), 0);
            ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
        }

        @Override
        public void generateTo(StringBuffer script) {
            script.append("%action ").append(this.getActionId()).append("\n");
        }
    }

    public static final class ShortcutActionDescription
    implements ActionDescriptor {
        private final String myKeyStroke;

        public ShortcutActionDescription(String stroke) {
            this.myKeyStroke = stroke;
        }

        @Override
        public ShortcutActionDescription clone() {
            return new ShortcutActionDescription(this.myKeyStroke);
        }

        @Override
        public void playBack(DataContext context2) {
        }

        @Override
        public void generateTo(StringBuffer script) {
            script.append("%[").append(this.myKeyStroke).append("]\n");
        }

        public String toString() {
            return IdeBundle.message((String)"action.descriptor.keystroke", (Object[])new Object[]{this.myKeyStroke});
        }

        public String getText() {
            return this.myKeyStroke;
        }
    }
}

