/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CloseEditorsActionBase
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    protected List<Pair<EditorComposite, EditorWindow>> getFilesToClose(@NotNull AnActionEvent event) {
        EditorWindow[] editorWindowArray;
        if (event == null) {
            CloseEditorsActionBase.$$$reportNull$$$0(0);
        }
        ArrayList<Pair<EditorComposite, EditorWindow>> result2 = new ArrayList<Pair<EditorComposite, EditorWindow>>();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext2);
        if (editorWindow == null) {
            editorWindowArray = fileEditorManager.getWindows();
        } else {
            EditorWindow[] editorWindowArray2 = new EditorWindow[1];
            editorWindowArray = editorWindowArray2;
            editorWindowArray2[0] = editorWindow;
        }
        EditorWindow[] windows = editorWindowArray;
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        if (fileStatusManager != null) {
            for (int i2 = 0; i2 != windows.length; ++i2) {
                EditorWindow window = windows[i2];
                for (EditorComposite composite2 : window.getAllComposites()) {
                    if (!this.isFileToClose(composite2, window, fileEditorManager) && !this.isFileToCloseInContext(event.getDataContext(), composite2, window)) continue;
                    result2.add((Pair<EditorComposite, EditorWindow>)new Pair((Object)composite2, (Object)window));
                }
            }
        }
        return result2;
    }

    protected abstract boolean isFileToClose(@NotNull EditorComposite var1, @NotNull EditorWindow var2, @NotNull FileEditorManagerEx var3);

    protected boolean isFileToCloseInContext(DataContext dataContext2, EditorComposite editor2, EditorWindow window) {
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseEditorsActionBase.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            List<Pair<EditorComposite, EditorWindow>> filesToClose = this.getFilesToClose(e);
            for (int i2 = 0; i2 != filesToClose.size(); ++i2) {
                Pair<EditorComposite, EditorWindow> we = filesToClose.get(i2);
                ((EditorWindow)we.getSecond()).closeFile(((EditorComposite)we.getFirst()).getFile());
            }
        }, IdeBundle.message((String)"command.close.all.unmodified.editors", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseEditorsActionBase.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext2);
        boolean inSplitter = editorWindow != null && editorWindow.inSplitter();
        presentation2.setText(this.getPresentationText(inSplitter));
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        boolean enabled2 = project2 != null && this.isActionEnabled(project2, event);
        presentation2.setEnabled(enabled2);
        if (event.isFromContextMenu()) {
            presentation2.setVisible(enabled2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CloseEditorsActionBase.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    protected boolean isActionEnabled(Project project2, AnActionEvent event) {
        return !this.getFilesToClose(event).isEmpty();
    }

    @NlsContexts.Command
    protected abstract String getPresentationText(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CloseEditorsActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CloseEditorsActionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToClose";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

