/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.actions.EditCustomSettingsAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/EditCustomVmOptionsAction;", "Lcom/intellij/ide/actions/EditCustomSettingsAction;", "<init>", "()V", "file", "Ljava/nio/file/Path;", "template", "", "charset", "Ljava/nio/charset/Charset;", "isEnabled", "", "prepareDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "Companion", "AccessExtension", "intellij.platform.ide.impl"})
public class EditCustomVmOptionsAction
extends EditCustomSettingsAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<String> JRE_PATH_KEY;
    @NotNull
    private static final Lazy<Path> file;

    @Override
    @Nullable
    protected Path file() {
        return (Path)file.getValue();
    }

    @Override
    @NotNull
    protected String template() {
        return "# custom " + ApplicationNamesInfo.getInstance().getFullProductName() + " VM options (expand/override 'bin" + File.separator + VMOptions.getFileName() + "')\n\n";
    }

    @Override
    @NotNull
    protected Charset charset() {
        Charset charset = VMOptions.getFileCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getFileCharset(...)");
        return charset;
    }

    public final boolean isEnabled() {
        return this.file() != null;
    }

    @Override
    protected void prepareDocument(@Nullable Document document2) {
        String jrePath = System.getProperty("java.home");
        if (jrePath != null && document2 != null) {
            document2.putUserData(JRE_PATH_KEY, (Object)jrePath);
        }
    }

    private static final Path file$lambda$0() {
        return VMOptions.getUserOptionsFile();
    }

    static {
        Key key = Key.create((String)"JRE_PATH_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JRE_PATH_KEY = key;
        file = LazyKt.lazy(EditCustomVmOptionsAction::file$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/EditCustomVmOptionsAction$AccessExtension;", "Lcom/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessExtension;", "<init>", "()V", "isWritable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nEditCustomSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCustomSettingsAction.kt\ncom/intellij/ide/actions/EditCustomVmOptionsAction$AccessExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
    public static final class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        public boolean isWritable(@NotNull VirtualFile file2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Path path = (Path)file.getValue();
            if (path != null) {
                Path it = path;
                boolean bl2 = false;
                bl = VfsUtilCore.pathEqualsTo((VirtualFile)file2, (String)((Object)it).toString());
            } else {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/actions/EditCustomVmOptionsAction$Companion;", "", "<init>", "()V", "JRE_PATH_KEY", "Lcom/intellij/openapi/util/Key;", "", "file", "Lkotlin/Lazy;", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

