/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.OpenInRightSplitActionProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/actions/OpenInRightSplitAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class OpenInRightSplitAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        OpenInRightSplitActionProvider openInRightSplitActionProvider = (OpenInRightSplitActionProvider)e.getData(OpenInRightSplitActionProvider.Companion.getDATA_KEY());
        boolean bl = openInRightSplitActionProvider != null ? openInRightSplitActionProvider.openInRightSplit(e) : false;
        if (bl) {
            return;
        }
        Project project2 = AnAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = OpenInRightSplitAction.Companion.getVirtualFile(e);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        Object object = e.getData(CommonDataKeys.PSI_ELEMENT);
        Navigatable element = object instanceof Navigatable ? (Navigatable)object : null;
        EditorWindow editorWindow = com.intellij.ide.actions.OpenInRightSplitAction$Companion.openInRightSplit$default(Companion, project3, file2, element, false, 8, null);
        if (editorWindow == null) {
            return;
        }
        EditorWindow editorWindow2 = editorWindow;
        if (element != null) {
            return;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return;
        }
        VirtualFile[] files2 = virtualFileArray;
        if (files2.length > 1) {
            for (VirtualFile it : files2) {
                if (Intrinsics.areEqual((Object)file2, (Object)it)) continue;
                FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.Companion.getInstanceEx(project3);
                Intrinsics.checkNotNull((Object)it);
                fileEditorManagerEx.openFile(it, editorWindow2, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, false, false, null, 4087, null));
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        OpenInRightSplitActionProvider openInRightSplitActionProvider = (OpenInRightSplitActionProvider)e.getData(OpenInRightSplitActionProvider.Companion.getDATA_KEY());
        boolean bl = openInRightSplitActionProvider != null ? openInRightSplitActionProvider.canOpenInRightSplit(e) : false;
        if (bl) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        String place = string;
        if (project2 == null || fileEditor != null || editor2 != null || Intrinsics.areEqual((Object)place, (Object)"EditorTabPopup") || Intrinsics.areEqual((Object)place, (Object)"EditorPopup")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile contextFile = OpenInRightSplitAction.Companion.getVirtualFile(e);
        e.getPresentation().setEnabledAndVisible(contextFile != null && !contextFile.isDirectory() && !FileEditorManagerImpl.Companion.forbidSplitFor(contextFile));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J0\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/actions/OpenInRightSplitAction$Companion;", "", "<init>", "()V", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "openInRightSplit", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "project", "Lcom/intellij/openapi/project/Project;", "file", "element", "Lcom/intellij/pom/Navigatable;", "requestFocus", "", "overrideDoubleClickWithOneClick", "", "component", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile getVirtualFile(AnActionEvent e) {
            return (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }

        @JvmOverloads
        @Nullable
        public final EditorWindow openInRightSplit(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable Navigatable element, boolean requestFocus) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project2);
            if (!fileEditorManager.canOpenFile(file2)) {
                Navigatable navigatable = element;
                if (navigatable != null) {
                    navigatable.navigate(requestFocus);
                }
                return null;
            }
            EditorWindow editorWindow = EditorsSplitters.openInRightSplit$default(fileEditorManager.getSplitters(), file2, requestFocus, false, 4, null);
            if (editorWindow == null) {
                Navigatable navigatable = element;
                if (navigatable != null) {
                    navigatable.navigate(requestFocus);
                } else {
                    fileEditorManager.openFile(file2, null, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, null, false, false, false, null, 3831, null));
                }
                return null;
            }
            if (element != null && !(element instanceof PsiFile)) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.openInRightSplit$lambda$0(element, requestFocus), project2.getDisposed());
            }
            return editorWindow;
        }

        public static /* synthetic */ EditorWindow openInRightSplit$default(Companion companion, Project project2, VirtualFile virtualFile2, Navigatable navigatable, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                navigatable = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.openInRightSplit(project2, virtualFile2, navigatable, bl);
        }

        public final void overrideDoubleClickWithOneClick(@NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            AnAction anAction = ActionManager.getInstance().getAction("OpenInRightSplit");
            if (anAction == null) {
                return;
            }
            AnAction action2 = anAction;
            ShortcutSet shortcutSet = action2.getShortcutSet();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
            ShortcutSet set = shortcutSet;
            Shortcut[] shortcutArray = set.getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            for (Shortcut shortcut : shortcutArray) {
                if (!(shortcut instanceof MouseShortcut) || ((MouseShortcut)shortcut).getClickCount() != 2) continue;
                Shortcut[] shortcutArray2 = new Shortcut[]{new MouseShortcut(((MouseShortcut)shortcut).getButton(), ((MouseShortcut)shortcut).getModifiers(), 1)};
                CustomShortcutSet customSet = new CustomShortcutSet(shortcutArray2);
                new AnActionWrapper(action2).registerCustomShortcutSet((ShortcutSet)customSet, component2);
            }
        }

        @JvmOverloads
        @Nullable
        public final EditorWindow openInRightSplit(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable Navigatable element) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return com.intellij.ide.actions.OpenInRightSplitAction$Companion.openInRightSplit$default(this, project2, file2, element, false, 8, null);
        }

        @JvmOverloads
        @Nullable
        public final EditorWindow openInRightSplit(@NotNull Project project2, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return com.intellij.ide.actions.OpenInRightSplitAction$Companion.openInRightSplit$default(this, project2, file2, null, false, 12, null);
        }

        private static final void openInRightSplit$lambda$0(Navigatable $element, boolean $requestFocus) {
            $element.navigate($requestFocus);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

