/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(0);
        }
        if ((handler2 = this.getHandler(e)) == null) {
            return;
        }
        boolean selected = !handler2.isPinned;
        handler2.setPinned(selected);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected);
    }

    public void update(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(1);
        }
        boolean enabled2 = (handler2 = this.getHandler(e)) != null;
        boolean selected = enabled2 && handler2.isPinned;
        e.getPresentation().setIcon(e.isFromActionToolbar() ? AllIcons.General.Pin_tab : null);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected);
        e.getPresentation().setText(selected ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
        e.getPresentation().setEnabledAndVisible(enabled2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            PinActiveTabAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    protected Handler getHandler(@NotNull AnActionEvent e) {
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(3);
        }
        Project project2 = e.getProject();
        EditorWindow currentWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        Content content3 = content2 = currentWindow == null ? this.getContentFromEvent(e) : null;
        if (content2 != null && content2.isPinnable()) {
            return PinActiveTabAction.createHandler(content2);
        }
        EditorWindow window = currentWindow == null ? (project2 == null ? null : FileEditorManagerEx.getInstanceEx(project2).getCurrentWindow()) : currentWindow;
        VirtualFile selectedFile = window == null ? null : this.getFileFromEvent(e, window);
        return selectedFile == null ? null : PinActiveTabAction.createHandler(window, selectedFile);
    }

    @Nullable
    protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(4);
        }
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(5);
        }
        return PinActiveTabAction.getFileInWindow(window);
    }

    @Nullable
    protected Content getContentFromEvent(@NotNull AnActionEvent e) {
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(6);
        }
        if ((content2 = PinActiveTabAction.getNonToolWindowContent(e)) == null) {
            content2 = PinActiveTabAction.getToolWindowContent(e);
        }
        return content2 != null && content2.isValid() ? content2 : null;
    }

    @NotNull
    private static Handler createHandler(final Content content2) {
        return new Handler(content2.isPinned(), Objects.requireNonNull(content2.getManager()).getSelectedContent() == content2){

            @Override
            void setPinned(boolean value) {
                content2.setPinned(value);
            }
        };
    }

    @NotNull
    private static Handler createHandler(final EditorWindow window, final VirtualFile selectedFile) {
        return new Handler(window.isFilePinned(selectedFile), selectedFile.equals(window.getContextFile())){

            @Override
            void setPinned(boolean value) {
                window.setFilePinned(selectedFile, value);
            }
        };
    }

    @Nullable
    private static Content getNonToolWindowContent(@NotNull AnActionEvent e) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(7);
        }
        Content result2 = null;
        Content[] contents = (Content[])e.getData(ViewContext.CONTENT_KEY);
        if (contents != null && contents.length == 1) {
            result2 = contents[0];
        }
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(e.getDataContext(), true);
        result2 = contentManager != null ? contentManager.getSelectedContent() : null;
        return result2 != null && result2.isPinnable() ? result2 : null;
    }

    @Nullable
    private static Content getToolWindowContent(@NotNull AnActionEvent e) {
        InternalDecoratorImpl decorator;
        Content result2;
        ToolWindow window;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(8);
        }
        if ((window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW)) == null) {
            return null;
        }
        Component component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        BaseLabel obj2 = (BaseLabel)ComponentUtil.getParentOfType(BaseLabel.class, (Component)component2);
        Content content2 = result2 = obj2 == null ? null : obj2.getContent();
        if (result2 == null && (decorator = InternalDecoratorImpl.findNearestDecorator(component2)) != null) {
            result2 = decorator.getContentManager().getSelectedContent();
        }
        return result2 != null && result2.isPinnable() ? result2 : null;
    }

    @Nullable
    private static VirtualFile getFileInWindow(@NotNull EditorWindow window) {
        VirtualFile file2;
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(9);
        }
        return (file2 = window.getContextFile()) != null && window.isFileOpen(file2) ? file2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/PinActiveTabAction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileFromEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonToolWindowContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileInWindow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static abstract class Handler {
        public final boolean isPinned;
        public final boolean isActiveTab;

        abstract void setPinned(boolean var1);

        public Handler(boolean isPinned, boolean isActiveTab) {
            this.isPinned = isPinned;
            this.isActiveTab = isActiveTab;
        }
    }

    public static final class Toggle
    extends PinActiveTabAction
    implements Toggleable {
    }

    static final class EW
    extends PinActiveTabAction {
        EW() {
        }

        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                EW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                EW.$$$reportNull$$$0(1);
            }
            return window.getContextFile();
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                EW.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$EW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                TW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                TW.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                TW.$$$reportNull$$$0(2);
            }
            return PinActiveTabAction.getToolWindowContent(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$TW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

