/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.LayoutNameInputDialog;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/actions/RenameLayoutAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "manager", "Lcom/intellij/toolWindow/ToolWindowDefaultLayoutManager;", "getManager", "()Lcom/intellij/toolWindow/ToolWindowDefaultLayoutManager;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class RenameLayoutAction
extends DumbAwareAction {
    @NotNull
    private final String layoutName;

    public RenameLayoutAction(@NotNull String layoutName) {
        Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
        this.layoutName = layoutName;
    }

    private final ToolWindowDefaultLayoutManager getManager() {
        return ToolWindowDefaultLayoutManager.Companion.getInstance();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Rename.text", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{this.layoutName};
        e.getPresentation().setDescription(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Rename.description", (Object[])objectArray));
        e.getPresentation().setEnabled(e.getProject() != null && this.getManager().getLayoutNames().contains(this.layoutName));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        String string = IdeBundle.message((String)"dialog.rename.window.layout.prompt", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = IdeBundle.message((String)"dialog.rename.window.layout.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = IdeBundle.message((String)"button.rename", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        LayoutNameInputDialog dialog2 = new LayoutNameInputDialog(project3, string, string2, string3, this.layoutName);
        dialog2.show();
        String newName = dialog2.getInputString();
        CharSequence charSequence = newName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        this.getManager().renameLayout(this.layoutName, newName);
    }
}

