/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowFilePathAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = ShowFilePathAction.getFile(e);
        boolean visible = RevealFileAction.isSupported() && file2 != null && !LightVirtualFile.shouldSkipEventSystem((VirtualFile)file2);
        e.getPresentation().setVisible(visible);
        if (visible) {
            e.getPresentation().setEnabled(true);
            boolean isPopup = List.of("ProjectViewPopup", "EditorTabPopup", "BookmarksPopup").contains(e.getPlace());
            e.getPresentation().setText(ActionsBundle.message((String)(isPopup ? "action.ShowFilePath.popup" : "action.ShowFilePath.text"), (Object[])new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowFilePathAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(2);
        }
        if ((file2 = ShowFilePathAction.getFile(e)) != null) {
            DataContext asyncContext = Utils.createAsyncDataContext(e.getDataContext());
            ShowFilePathAction.show(file2, (ListPopup popup2) -> popup2.showInBestPositionFor(asyncContext));
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files2 == null || files2.length == 1 ? (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE) : null;
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(4);
        }
        ShowFilePathAction.show(file2, (ListPopup popup2) -> {
            if (e.getComponent().isShowing()) {
                popup2.show(new RelativePoint(e));
            }
        });
    }

    private static void show(VirtualFile file2, Consumer<ListPopup> action2) {
        if (!RevealFileAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files2.size();
            files2.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ReadAction.nonBlocking(() -> ContainerUtil.map((Collection)fileUrls, url -> {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByNioFile(Path.of(url, new String[0]));
            if (vFile == null) {
                return EmptyIcon.ICON_16;
            }
            if (vFile.isDirectory()) {
                return AllIcons.Nodes.Folder;
            }
            return FileTypeManager.getInstance().getFileTypeByFile(vFile).getIcon();
        })).finishOnUiThread(ModalityState.nonModal(), icons -> action2.accept(ShowFilePathAction.createPopup(files2, icons))).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static String getPresentableUrl(VirtualFile file2) {
        Object url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = (String)url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<VirtualFile> files2, List<Icon> icons) {
        BaseListPopupStep<VirtualFile> step2 = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files2, icons){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPresentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep<?> onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RevealFileAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$1", "getTextFor"));
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String getFileManagerName() {
        String string = RevealFileAction.getFileManagerName();
        if (string == null) {
            ShowFilePathAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(6);
        }
        RevealFileAction.openFile(file2);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        return RevealFileAction.findLocalFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

