/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001d\u0010\u0019\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/actions/ToolWindowTabRenameActionBase;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "toolWindowId", "", "labelText", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getToolWindowId", "()Ljava/lang/String;", "getLabelText", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "selectedContent", "Lcom/intellij/ui/content/Content;", "actionPerformed", "content", "showContentRenamePopup", "baseLabel", "Lcom/intellij/openapi/wm/impl/content/BaseLabel;", "project", "Lcom/intellij/openapi/project/Project;", "getContentDisplayNameToEdit", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "applyContentDisplayName", "newContentName", "intellij.platform.ide.impl"})
public class ToolWindowTabRenameActionBase
extends ToolWindowContextMenuActionBase {
    @NotNull
    private final String toolWindowId;
    @NotNull
    private final String labelText;

    public ToolWindowTabRenameActionBase(@NotNull String toolWindowId, @NlsContexts.Label @NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        this.toolWindowId = toolWindowId;
        this.labelText = labelText;
    }

    @NotNull
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    @NotNull
    public final String getLabelText() {
        return this.labelText;
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2, @Nullable Content selectedContent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        String string = toolWindow2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String id2 = string;
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && Intrinsics.areEqual((Object)id2, (Object)this.toolWindowId) && selectedContent != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2, @Nullable Content content2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Component contextComponent = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        BaseLabel tabLabel = contextComponent instanceof BaseLabel ? (BaseLabel)contextComponent : (BaseLabel)e.getData(ToolWindowContentUi.SELECTED_CONTENT_TAB_LABEL);
        BaseLabel baseLabel = tabLabel;
        if (baseLabel == null || (baseLabel = baseLabel.getContent()) == null) {
            return;
        }
        BaseLabel tabLabelContent = baseLabel;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        this.showContentRenamePopup(tabLabel, (Content)tabLabelContent, project3);
    }

    private final void showContentRenamePopup(BaseLabel baseLabel, Content content2, Project project2) {
        String defaultPopupValue = this.getContentDisplayNameToEdit(content2, project2);
        JTextField textField2 = new JTextField(defaultPopupValue);
        textField2.selectAll();
        JBLabel label2 = new JBLabel(this.labelText);
        label2.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        Component[] componentArray = new Component[]{label2, Box.createVerticalStrut(JBUI.scale((int)2)), textField2};
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel(componentArray);
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"newLeftAlignedVerticalPanel(...)");
        JPanel panel2 = jPanel;
        panel2.addFocusListener(new FocusAdapter(textField2){
            final /* synthetic */ JTextField $textField;
            {
                this.$textField = $textField;
            }

            public void focusGained(FocusEvent e) {
                IdeFocusManager.findInstance().requestFocus((Component)this.$textField, false);
            }
        });
        Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setShowCallout(true).setCloseButtonEnabled(false).setAnimationCycle(0).setDisposable((Disposable)content2).setHideOnKeyOutside(true).setHideOnClickOutside(true).setRequestFocus(true).setBlockClicksThroughBalloon(true).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        textField2.addKeyListener(new KeyAdapter(textField2, this, content2, project2, balloon2){
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ ToolWindowTabRenameActionBase this$0;
            final /* synthetic */ Content $content;
            final /* synthetic */ Project $project;
            final /* synthetic */ Balloon $balloon;
            {
                this.$textField = $textField;
                this.this$0 = $receiver;
                this.$content = $content;
                this.$project = $project;
                this.$balloon = $balloon;
            }

            public void keyPressed(KeyEvent e) {
                if (e != null && e.getKeyCode() == 10) {
                    String string = this.$textField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (((CharSequence)string).length() == 0) {
                        this.$textField.putClientProperty("JComponent.outline", "error");
                        this.$textField.repaint();
                        return;
                    }
                    String string2 = this.$textField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    this.this$0.applyContentDisplayName(this.$content, this.$project, string2);
                    this.$balloon.hide();
                }
            }
        });
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(textField2){
            final /* synthetic */ JTextField $textField;
            {
                this.$textField = $textField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object outlineValue = this.$textField.getClientProperty("JComponent.outline");
                if (Intrinsics.areEqual((Object)outlineValue, (Object)"error")) {
                    this.$textField.putClientProperty("JComponent.outline", null);
                    this.$textField.repaint();
                }
            }
        });
        balloon2.show(new RelativePoint((Component)baseLabel, new Point(baseLabel.getWidth() / 2, 0)), Balloon.Position.above);
        balloon2.addListener(new JBPopupListener(content2){
            final /* synthetic */ Content $content;
            {
                this.$content = $content;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
                JComponent jComponent = this.$content.getPreferredFocusableComponent();
                if (jComponent == null) {
                    JComponent jComponent2 = this.$content.getComponent();
                    jComponent = jComponent2;
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
                }
                ideFocusManager.requestFocus((Component)jComponent, false);
            }
        });
    }

    @NotNull
    public String getContentDisplayNameToEdit(@NotNull Content content2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = content2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    public void applyContentDisplayName(@NotNull Content content2, @NotNull Project project2, @Nls @NotNull String newContentName) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newContentName, (String)"newContentName");
        content2.setDisplayName(newContentName);
    }
}

