/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.cache;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.cache.CacheRecoveryUsageCollector;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.ide.actions.cache.SaulKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/actions/cache/RecoveryWorker;", "", "actions", "", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "<init>", "(Ljava/util/Collection;)V", "getActions", "()Ljava/util/Collection;", "actionSeq", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "kotlin.jvm.PlatformType", "start", "", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "perform", "recoveryAction", "idx", "", "askUserToContinue", "previousRecoveryAction", "hasNextRecoveryAction", "", "nextRecoveryAction", "reportStoppedToFus", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSaul.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Saul.kt\ncom/intellij/ide/actions/cache/RecoveryWorker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,202:1\n13#2:203\n*S KotlinDebug\n*F\n+ 1 Saul.kt\ncom/intellij/ide/actions/cache/RecoveryWorker\n*L\n58#1:203\n*E\n"})
final class RecoveryWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<RecoveryAction> actions;
    @NotNull
    private final ConcurrentLinkedQueue<RecoveryAction> actionSeq;
    @NotNull
    private static final Logger LOG;

    public RecoveryWorker(@NotNull Collection<? extends RecoveryAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.actions = actions;
        this.actionSeq = new ConcurrentLinkedQueue<RecoveryAction>(this.actions);
    }

    @NotNull
    public final Collection<RecoveryAction> getActions() {
        return this.actions;
    }

    public final void start(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        this.perform(this.nextRecoveryAction(recoveryScope), recoveryScope, 0);
    }

    public final void perform(@NotNull RecoveryAction recoveryAction, @NotNull RecoveryScope recoveryScope, int idx) {
        Intrinsics.checkNotNullParameter((Object)recoveryAction, (String)"recoveryAction");
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        SaulKt.performUnderProgress(recoveryAction, recoveryScope, true, (Function1<? super RecoveryScope, Unit>)((Function1)arg_0 -> RecoveryWorker.perform$lambda$0(this, recoveryAction, idx, arg_0)));
    }

    private final void askUserToContinue(RecoveryScope recoveryScope, RecoveryAction previousRecoveryAction, int idx) {
        if (!this.hasNextRecoveryAction(recoveryScope)) {
            return;
        }
        RecoveryAction recoveryAction = this.nextRecoveryAction(recoveryScope);
        int next = idx + 1;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Cache Recovery");
        String string = IdeBundle.message((String)"notification.cache.diagnostic.helper.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{next, previousRecoveryAction.getPresentableName()};
        String string2 = IdeBundle.message((String)"notification.cache.diagnostic.helper.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification2 = notificationGroup.createNotification(string, string2, NotificationType.WARNING);
        notification2.addAction((AnAction)DumbAwareAction.create((String)IdeBundle.message((String)"notification.cache.diagnostic.stop.text", (Object[])new Object[0]), arg_0 -> RecoveryWorker.askUserToContinue$lambda$1(arg_0 -> RecoveryWorker.askUserToContinue$lambda$0(notification2, this, recoveryScope, arg_0), arg_0))).addAction((AnAction)DumbAwareAction.create((String)recoveryAction.getPresentableName(), arg_0 -> RecoveryWorker.askUserToContinue$lambda$3(arg_0 -> RecoveryWorker.askUserToContinue$lambda$2(notification2, this, recoveryAction, recoveryScope, next, arg_0), arg_0))).setImportant(true).notify(recoveryScope.getProject());
    }

    private final boolean hasNextRecoveryAction(RecoveryScope recoveryScope) {
        while (!((Collection)this.actionSeq).isEmpty()) {
            if (this.actionSeq.peek().canBeApplied(recoveryScope)) {
                return true;
            }
            this.actionSeq.poll();
        }
        return false;
    }

    private final RecoveryAction nextRecoveryAction(RecoveryScope recoveryScope) {
        boolean bl = this.hasNextRecoveryAction(recoveryScope);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        RecoveryAction recoveryAction = this.actionSeq.poll();
        Intrinsics.checkNotNullExpressionValue((Object)recoveryAction, (String)"poll(...)");
        return recoveryAction;
    }

    private final void reportStoppedToFus(Project project2) {
        CacheRecoveryUsageCollector.INSTANCE.recordGuideStoppedEvent(project2);
    }

    private static final Unit perform$lambda$0(RecoveryWorker this$0, RecoveryAction $recoveryAction, int $idx, RecoveryScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (this$0.hasNextRecoveryAction(scope)) {
            this$0.askUserToContinue(scope, $recoveryAction, $idx);
        }
        return Unit.INSTANCE;
    }

    private static final Unit askUserToContinue$lambda$0(Notification $notification, RecoveryWorker this$0, RecoveryScope $recoveryScope, AnActionEvent it) {
        $notification.expire();
        this$0.reportStoppedToFus($recoveryScope.getProject());
        return Unit.INSTANCE;
    }

    private static final void askUserToContinue$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit askUserToContinue$lambda$2(Notification $notification, RecoveryWorker this$0, RecoveryAction $recoveryAction, RecoveryScope $recoveryScope, int $next, AnActionEvent it) {
        $notification.expire();
        this$0.perform($recoveryAction, $recoveryScope, $next);
        return Unit.INSTANCE;
    }

    private static final void askUserToContinue$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(RecoveryWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/cache/RecoveryWorker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

