/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.project;

import com.intellij.ide.actions.project.ConvertModuleGroupsToQualifiedNamesDialog;
import com.intellij.ide.actions.project.LoadSaveModuleRenameMappingKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/actions/project/LoadModuleRenamingSchemeAction;", "Ljavax/swing/AbstractAction;", "dialog", "Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;", "<init>", "(Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nloadSaveModuleRenameMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loadSaveModuleRenameMapping.kt\ncom/intellij/ide/actions/project/LoadModuleRenamingSchemeAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1869#2,2:113\n*S KotlinDebug\n*F\n+ 1 loadSaveModuleRenameMapping.kt\ncom/intellij/ide/actions/project/LoadModuleRenamingSchemeAction\n*L\n50#1:113,2\n*E\n"})
public final class LoadModuleRenamingSchemeAction
extends AbstractAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConvertModuleGroupsToQualifiedNamesDialog dialog;
    @NotNull
    private static final Logger LOG;

    public LoadModuleRenamingSchemeAction(@NotNull ConvertModuleGroupsToQualifiedNamesDialog dialog2) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        this.dialog = dialog2;
        UIUtil.setActionNameAndMnemonic((String)ProjectBundle.message((String)"module.renaming.scheme.load.button.text", (Object[])new Object[0]), (Action)this);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        ModuleRenamingHistoryState moduleRenamingHistoryState;
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)StdFileTypes.XML));
        VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.dialog.getProject(), (VirtualFile)LoadSaveModuleRenameMappingKt.access$getDefaultRenamingSchemeFile(this.dialog.getProject()));
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        try {
            moduleRenamingHistoryState = (ModuleRenamingHistoryState)XmlSerializer.deserialize((Element)JDOMUtil.load((InputStream)file2.getInputStream()), ModuleRenamingHistoryState.class);
        }
        catch (SerializationException e2) {
            LOG.info((Throwable)e2);
            String string = e2.getMessage();
            if (string == null) {
                string = "unknown error";
            }
            LoadModuleRenamingSchemeAction.actionPerformed$showError(this, file2, string);
            return;
        }
        ModuleRenamingHistoryState moduleRenamingHistoryState2 = moduleRenamingHistoryState;
        Intrinsics.checkNotNull((Object)moduleRenamingHistoryState2);
        ModuleRenamingHistoryState renamingState = moduleRenamingHistoryState2;
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.dialog.getProject());
        Set set = renamingState.oldToNewName.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (moduleManager.findModuleByName(it) != null) continue;
            Object[] objectArray = new Object[]{it};
            String string = ProjectBundle.message((String)"module.renaming.scheme.unknown.module.error", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            LoadModuleRenamingSchemeAction.actionPerformed$showError(this, file2, string);
            return;
        }
        this.dialog.importRenamingScheme(renamingState.oldToNewName);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> LoadModuleRenamingSchemeAction.actionPerformed$lambda$1(this));
    }

    private static final void actionPerformed$showError(LoadModuleRenamingSchemeAction this$0, VirtualFile file2, String message) {
        Object[] objectArray = new Object[]{file2.getPresentableUrl(), message};
        Messages.showErrorDialog((Project)this$0.dialog.getProject(), (String)ProjectBundle.message((String)"module.renaming.scheme.cannot.load.error", (Object[])objectArray), (String)ProjectBundle.message((String)"module.renaming.scheme.cannot.import.error.title", (Object[])new Object[0]));
    }

    private static final void actionPerformed$lambda$1(LoadModuleRenamingSchemeAction this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.dialog.getPreferredFocusedComponent(), true);
    }

    static {
        Logger logger2 = Logger.getInstance(LoadModuleRenamingSchemeAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/project/LoadModuleRenamingSchemeAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

