/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.BuildNumber;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LicenseAiNonCommercialUtil {
    @NotNull
    private static final String AI_TERMS_ACCEPTED_PROPERTY_SUFFIX = "NonCommercialLicense.AiTermsAccepted";

    public static boolean isNonCommercialAiLicenseAvailable() {
        return "true".equals(System.getProperty("enable.non.commercial.ai.license"));
    }

    public static void storeAiNonCommercialTermsAcceptedState(@Nullable Boolean isAccepted) {
        if (isAccepted == null) {
            Prefs.remove((String)LicenseAiNonCommercialUtil.getAiTermsAcceptedKey());
            return;
        }
        Prefs.putBoolean((String)LicenseAiNonCommercialUtil.getAiTermsAcceptedKey(), (boolean)isAccepted);
    }

    @NotNull
    public static String getAiTermsAcceptedKey() {
        return LicenseAiNonCommercialUtil.getPerApplicationKey(AI_TERMS_ACCEPTED_PROPERTY_SUFFIX);
    }

    @NotNull
    private static String getPerApplicationKey(@NotNull String keySuffix) {
        if (keySuffix == null) {
            LicenseAiNonCommercialUtil.$$$reportNull$$$0(0);
        }
        ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
        BuildNumber build2 = info.getBuild();
        String string = String.format("%s.%s.%d.%s", info.getShortCompanyName().replace(" ", ""), build2.getProductCode(), build2.getBaselineVersion(), keySuffix);
        if (string == null) {
            LicenseAiNonCommercialUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keySuffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/LicenseAiNonCommercialUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/LicenseAiNonCommercialUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerApplicationKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPerApplicationKey";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

