/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginLogoIcon;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HiDPIPluginLogoIcon
extends PluginLogoIcon {
    private static Icon cachedErrorLogo2x;

    HiDPIPluginLogoIcon(@NotNull JBImageIcon logo, @NotNull JBImageIcon logoBig) {
        if (logo == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(0);
        }
        if (logoBig == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(1);
        }
        super((Icon)logo, HiDPIPluginLogoIcon.calculateDisabledIcon(logo, true), (Icon)logoBig, HiDPIPluginLogoIcon.calculateDisabledIcon(logoBig, true));
    }

    HiDPIPluginLogoIcon(@NotNull Icon logo, @NotNull Icon logoDisabled, @NotNull Icon logoBig, @NotNull Icon logoDisabledBig) {
        if (logo == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(2);
        }
        if (logoDisabled == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(3);
        }
        if (logoBig == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(4);
        }
        if (logoDisabledBig == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(5);
        }
        super(logo, logoDisabled, logoBig, logoDisabledBig);
    }

    @Override
    @NotNull
    protected Icon getErrorLogo2x() {
        if (cachedErrorLogo2x == null) {
            cachedErrorLogo2x = super.getErrorLogo2x();
        }
        Icon icon2 = cachedErrorLogo2x;
        if (icon2 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(6);
        }
        return icon2;
    }

    static void clearCache() {
        cachedErrorLogo2x = null;
        disabledIcons.invalidateAll();
        baseDisabledIcons.invalidateAll();
    }

    @Override
    @NotNull
    protected Icon getScaled2xIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(7);
        }
        final Computable superCall = () -> super.getScaled2xIcon(icon2);
        return new Icon(){
            final ScaleContext myContext = ScaleContext.create();
            Icon myIcon;

            @NotNull
            Icon getIcon() {
                if (this.myContext.update() || this.myIcon == null) {
                    this.myIcon = (Icon)superCall.compute();
                }
                Icon icon2 = this.myIcon;
                if (icon2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                this.getIcon().paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return this.getIcon().getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.getIcon().getIconHeight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/newui/HiDPIPluginLogoIcon$1", "getIcon"));
            }
        };
    }

    @NotNull
    static Icon loadSVG(@Nullable URL url, @NotNull InputStream stream, int width, int height) throws IOException {
        if (stream == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(8);
        }
        ScaleContext context2 = ScaleContext.create();
        BufferedImage image2 = (BufferedImage)SVGLoader.load((URL)url, (InputStream)stream, (ScaleContext)context2, (double)width, (double)height);
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image2, (ScaleContext)context2);
        return HiDPIPluginLogoIcon.getHiDPI(context2, t);
    }

    @NotNull
    private static Icon getHiDPI(@NotNull ScaleContext context2, @NotNull Object source) {
        if (context2 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(9);
        }
        if (source == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(10);
        }
        if (source instanceof ImageIcon) {
            Image image2 = ((ImageIcon)source).getImage();
            if (image2 instanceof JBHiDPIScaledImage) {
                return HiDPIPluginLogoIcon.wrapHiDPI(context2, (JBHiDPIScaledImage)image2);
            }
            Icon icon2 = (Icon)source;
            if (icon2 == null) {
                HiDPIPluginLogoIcon.$$$reportNull$$$0(11);
            }
            return icon2;
        }
        if (source instanceof JBHiDPIScaledImage) {
            return HiDPIPluginLogoIcon.wrapHiDPI(context2, (JBHiDPIScaledImage)source);
        }
        if (source instanceof Image) {
            return new JBImageIcon((Image)source);
        }
        Icon icon3 = (Icon)source;
        if (icon3 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(12);
        }
        return icon3;
    }

    @NotNull
    private static Icon wrapHiDPI(final @NotNull ScaleContext context2, final @NotNull JBHiDPIScaledImage image2) {
        if (context2 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(13);
        }
        if (image2 == null) {
            HiDPIPluginLogoIcon.$$$reportNull$$$0(14);
        }
        return new JBImageIcon((Image)image2){
            final double myBase;
            {
                super(arg0);
                this.myBase = context2.getScale(ScaleType.USR_SCALE);
            }

            private void update() {
                if (context2.update()) {
                    this.setImage((Image)image2.scale(context2.getScale(ScaleType.USR_SCALE) / this.myBase));
                }
            }

            public synchronized void paintIcon(Component c, @NotNull Graphics g, int x, int y) {
                if (g == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.update();
                super.paintIcon(c, g, x, y);
            }

            public int getIconWidth() {
                this.update();
                return super.getIconWidth();
            }

            public int getIconHeight() {
                this.update();
                return super.getIconHeight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/plugins/newui/HiDPIPluginLogoIcon$2", "paintIcon"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logo";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoBig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabled";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabledBig";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/HiDPIPluginLogoIcon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/HiDPIPluginLogoIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLogo2x";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHiDPI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScaled2xIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadSVG";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHiDPI";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapHiDPI";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12 -> new IllegalStateException(string);
        };
    }
}

