/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0006J\u000e\u00104\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\tR\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u001f\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010#0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\tR)\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020#0&0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\tR\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001b\"\u0004\b1\u0010\u001d\u00a8\u00065"}, d2={"Lcom/intellij/ide/plugins/newui/PluginManagerSession;", "", "<init>", "()V", "dynamicPluginsToInstall", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/PendingDynamicPluginInstall;", "getDynamicPluginsToInstall", "()Ljava/util/Map;", "pluginsToRemoveOnCancel", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginsToRemoveOnCancel", "()Ljava/util/Set;", "dynamicPluginsToUninstall", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getDynamicPluginsToUninstall", "dependentToRequiredListMap", "getDependentToRequiredListMap", "installsInProgress", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "getInstallsInProgress", "updatesInProgress", "getUpdatesInProgress", "isUiDisposedWithApply", "", "()Z", "setUiDisposedWithApply", "(Z)V", "errorPluginsToDisable", "getErrorPluginsToDisable", "uninstalledPlugins", "getUninstalledPlugins", "pluginStates", "Lcom/intellij/ide/plugins/PluginEnabledState;", "getPluginStates", "statesDiff", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/ide/plugins/PluginEnableDisableAction;", "getStatesDiff", "updateService", "Lcom/intellij/ide/plugins/newui/PluginUpdatesService;", "getUpdateService", "()Lcom/intellij/ide/plugins/newui/PluginUpdatesService;", "setUpdateService", "(Lcom/intellij/ide/plugins/newui/PluginUpdatesService;)V", "needRestart", "getNeedRestart", "setNeedRestart", "isPluginDisabled", "pluginId", "isPluginEnabled", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginManagerSession {
    @NotNull
    private final Map<PluginId, PendingDynamicPluginInstall> dynamicPluginsToInstall = new ConcurrentHashMap();
    @NotNull
    private final Set<IdeaPluginDescriptorImpl> pluginsToRemoveOnCancel;
    @NotNull
    private final Set<IdeaPluginDescriptor> dynamicPluginsToUninstall;
    @NotNull
    private final Map<PluginId, Set<PluginId>> dependentToRequiredListMap;
    @NotNull
    private final Map<PluginId, PluginUiModel> installsInProgress;
    @NotNull
    private final Map<PluginId, PluginUiModel> updatesInProgress;
    private boolean isUiDisposedWithApply;
    @NotNull
    private final Set<PluginId> errorPluginsToDisable;
    @NotNull
    private final Set<PluginId> uninstalledPlugins;
    @NotNull
    private final Map<PluginId, PluginEnabledState> pluginStates;
    @NotNull
    private final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> statesDiff;
    @Nullable
    private PluginUpdatesService updateService;
    private boolean needRestart;

    public PluginManagerSession() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.pluginsToRemoveOnCancel = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.dynamicPluginsToUninstall = set2;
        this.dependentToRequiredListMap = new ConcurrentHashMap();
        this.installsInProgress = new ConcurrentHashMap();
        this.updatesInProgress = new ConcurrentHashMap();
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.errorPluginsToDisable = set3;
        Set set4 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"createConcurrentSet(...)");
        this.uninstalledPlugins = set4;
        this.pluginStates = new LinkedHashMap();
        this.statesDiff = new ConcurrentHashMap();
    }

    @NotNull
    public final Map<PluginId, PendingDynamicPluginInstall> getDynamicPluginsToInstall() {
        return this.dynamicPluginsToInstall;
    }

    @NotNull
    public final Set<IdeaPluginDescriptorImpl> getPluginsToRemoveOnCancel() {
        return this.pluginsToRemoveOnCancel;
    }

    @NotNull
    public final Set<IdeaPluginDescriptor> getDynamicPluginsToUninstall() {
        return this.dynamicPluginsToUninstall;
    }

    @NotNull
    public final Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.dependentToRequiredListMap;
    }

    @NotNull
    public final Map<PluginId, PluginUiModel> getInstallsInProgress() {
        return this.installsInProgress;
    }

    @NotNull
    public final Map<PluginId, PluginUiModel> getUpdatesInProgress() {
        return this.updatesInProgress;
    }

    public final boolean isUiDisposedWithApply() {
        return this.isUiDisposedWithApply;
    }

    public final void setUiDisposedWithApply(boolean bl) {
        this.isUiDisposedWithApply = bl;
    }

    @NotNull
    public final Set<PluginId> getErrorPluginsToDisable() {
        return this.errorPluginsToDisable;
    }

    @NotNull
    public final Set<PluginId> getUninstalledPlugins() {
        return this.uninstalledPlugins;
    }

    @NotNull
    public final Map<PluginId, PluginEnabledState> getPluginStates() {
        return this.pluginStates;
    }

    @NotNull
    public final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> getStatesDiff() {
        return this.statesDiff;
    }

    @Nullable
    public final PluginUpdatesService getUpdateService() {
        return this.updateService;
    }

    public final void setUpdateService(@Nullable PluginUpdatesService pluginUpdatesService) {
        this.updateService = pluginUpdatesService;
    }

    public final boolean getNeedRestart() {
        return this.needRestart;
    }

    public final void setNeedRestart(boolean bl) {
        this.needRestart = bl;
    }

    public final boolean isPluginDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        PluginEnabledState pluginEnabledState = this.pluginStates.get(pluginId);
        return pluginEnabledState != null ? pluginEnabledState.isDisabled() : true;
    }

    public final boolean isPluginEnabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        PluginEnabledState pluginEnabledState = this.pluginStates.get(pluginId);
        return pluginEnabledState != null ? pluginEnabledState.isEnabled() : true;
    }
}

