/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.marketplace.utils.MarketplaceUrls;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.EDT;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@ApiStatus.Internal
public final class PluginPriceService {
    private static final Logger LOG = Logger.getInstance(PluginPriceService.class);
    private static final DecimalFormat FORMAT = new DecimalFormat("###.#");
    private static final Map<String, Object> myPriceTable = new HashMap<String, Object>();
    private static boolean myPrepared;
    private static boolean myPreparing;

    public static void getPrice(@Nullable String productCode, @NotNull Consumer<? super String> callback, @NotNull Consumer<? super String> asyncCallback) {
        if (callback == null) {
            PluginPriceService.$$$reportNull$$$0(0);
        }
        if (asyncCallback == null) {
            PluginPriceService.$$$reportNull$$$0(1);
        }
        PluginPriceService.checkAccess();
        if (myPrepared) {
            Object value = myPriceTable.get(productCode);
            if (value instanceof String) {
                callback.consume((Object)((String)value));
            }
        } else {
            myPriceTable.put(productCode, asyncCallback);
            if (!myPreparing) {
                myPreparing = true;
                PluginPriceService.loadPrice();
            }
        }
    }

    public static void cancel() {
        PluginPriceService.checkAccess();
        PluginPriceService.clear();
    }

    private static void clear() {
        Iterator<Map.Entry<String, Object>> I = myPriceTable.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry<String, Object> entry = I.next();
            if (!(entry.getValue() instanceof Consumer)) continue;
            I.remove();
        }
    }

    private static void loadPrice() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Object priceJson = PluginPriceService.getPluginPricesJsonObject();
                if (priceJson instanceof Map) {
                    Map<String, String> result2 = PluginPriceService.parsePrices((Map)priceJson);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginPriceService.checkAccess();
                        for (Map.Entry entry : result2.entrySet()) {
                            Object callback = myPriceTable.put((String)entry.getKey(), entry.getValue());
                            if (!(callback instanceof Consumer)) continue;
                            ((Consumer)callback).consume((Object)((String)entry.getValue()));
                        }
                        PluginPriceService.clear();
                        myPrepared = true;
                        myPreparing = false;
                    }, ModalityState.any());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.debug((Throwable)e);
            }
        });
    }

    @Nullable
    private static Object getPluginPricesJsonObject() throws IOException {
        Url url = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/geo/files/prices"));
        return HttpRequests.request((Url)url).throwStatusCodeException(false).productNameAsUserAgent().connect(request -> {
            URLConnection connection = request.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose((Reader)request.getReader()));){
                Object object = JsonUtil.nextAny(json);
                return object;
            }
        });
    }

    @NotNull
    private static Map<String, String> parsePrices(@NotNull Map<String, Object> jsonObject) {
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(2);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        Object plugins2 = jsonObject.get("plugins");
        if (plugins2 instanceof List) {
            String currency = PluginPriceService.parseCurrency(jsonObject);
            for (Map plugin : (List)plugins2) {
                Double price;
                Object code = plugin.get("code");
                if (!(code instanceof String) || (price = PluginPriceService.parsePrice(plugin)) == null) continue;
                result2.put((String)code, currency + FORMAT.format(price));
            }
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            PluginPriceService.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private static String parseCurrency(@NotNull Map<String, Object> jsonObject) {
        Currency currency;
        Object iso;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(4);
        }
        if ((iso = jsonObject.get("iso")) instanceof String && (currency = Currency.getInstance((String)iso)) != null) {
            String string = currency.getSymbol(Locale.ENGLISH);
            if (string == null) {
                PluginPriceService.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static Double parsePrice(@NotNull Map<String, Object> plugin) {
        if (plugin == null) {
            PluginPriceService.$$$reportNull$$$0(6);
        }
        double[] personal = PluginPriceService.parsePrice(plugin, "personal");
        double[] commercial = PluginPriceService.parsePrice(plugin, "commercial");
        if (personal == null && commercial == null) {
            return null;
        }
        if (personal == null || commercial == null) {
            for (double value : personal == null ? commercial : personal) {
                if (!(value > 0.0)) continue;
                return value;
            }
        } else {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (!(personal[i2] > 0.0) || !(commercial[i2] > 0.0)) continue;
                return Math.min(personal[i2], commercial[i2]);
            }
        }
        return null;
    }

    @Nullable
    private static double[] parsePrice(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object subscription2;
        Object value;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(7);
        }
        if (key == null) {
            PluginPriceService.$$$reportNull$$$0(8);
        }
        if ((value = jsonObject.get(key)) instanceof Map && (subscription2 = ((Map)value).get("subscription")) instanceof Map) {
            return new double[]{PluginPriceService.parsePriceValue((Map)subscription2, "monthly"), PluginPriceService.parsePriceValue((Map)subscription2, "annual")};
        }
        return null;
    }

    private static double parsePriceValue(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object value;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(9);
        }
        if (key == null) {
            PluginPriceService.$$$reportNull$$$0(10);
        }
        if ((value = jsonObject.get(key)) instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static void checkAccess() {
        assert (EDT.isCurrentThreadEdt());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncCallback";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginPriceService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginPriceService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCurrency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrice";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parsePrices";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseCurrency";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePrice";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePriceValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

