/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.marketplace.PluginUpdateActivity;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdates;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final Logger LOG = Logger.getInstance(PluginUpdatesService.class);
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static final Object ourLock = new Object();
    @NotNull
    private static final Condition<IdeaPluginDescriptor> DEFAULT_FILTER = descriptor2 -> !PluginManagerCore.isDisabled((PluginId)descriptor2.getPluginId());
    @Nullable
    private static InternalPluginResults ourAllUpdates;
    @NotNull
    private static Condition<? super IdeaPluginDescriptor> ourFilter;
    private static boolean ourPrepared;
    private static boolean ourPreparing;
    private static boolean ourReset;
    private Consumer<? super Integer> myCountCallback;
    private List<Consumer<InternalPluginResults>> myUpdateCallbacks;
    private boolean mySetFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    @NotNull
    public static PluginUpdatesService connectWithCounter(@NotNull Consumer<? super Integer> callback) {
        if (callback == null) {
            PluginUpdatesService.$$$reportNull$$$0(0);
        }
        PluginUpdatesService service = new PluginUpdatesService();
        service.myCountCallback = callback;
        Object object = ourLock;
        synchronized (object) {
            SERVICES.add(service);
            if (ourPrepared) {
                callback.accept(PluginUpdatesService.getCount(PluginUpdatesService.getFilteredUpdateResult()));
                PluginUpdatesService pluginUpdatesService = service;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (pluginUpdatesService == null) {
                    PluginUpdatesService.$$$reportNull$$$0(1);
                }
                return pluginUpdatesService;
            }
        }
        PluginUpdatesService.calculateUpdates();
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(2);
        }
        return pluginUpdatesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static PluginUpdatesService connectWithUpdates(@NotNull Consumer<@Nullable InternalPluginResults> callback) {
        if (callback == null) {
            PluginUpdatesService.$$$reportNull$$$0(3);
        }
        PluginUpdatesService service = new PluginUpdatesService();
        service.myUpdateCallbacks = Collections.singletonList(callback);
        Object object = ourLock;
        synchronized (object) {
            SERVICES.add(service);
            if (ourPrepared) {
                callback.accept(PluginUpdatesService.getFilteredUpdateResult());
            }
        }
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(4);
        }
        return pluginUpdatesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static InternalPluginResults getFilteredUpdateResult() {
        Object object = ourLock;
        synchronized (object) {
            if (ourAllUpdates == null) {
                return null;
            }
            Condition<? super IdeaPluginDescriptor> filter2 = ourFilter;
            return new InternalPluginResults(new PluginUpdates(ContainerUtil.filter(ourAllUpdates.getPluginUpdates().getAllEnabled(), d -> filter2.test((Object)d.getDescriptor())), ContainerUtil.filter(ourAllUpdates.getPluginUpdates().getAllDisabled(), d -> filter2.test((Object)d.getDescriptor())), ourAllUpdates.getPluginUpdates().getIncompatible()), ourAllUpdates.getPluginNods(), ourAllUpdates.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateUpdates(@NotNull Consumer<? super Collection<PluginUiModel>> callback) {
        if (callback == null) {
            PluginUpdatesService.$$$reportNull$$$0(5);
        }
        Object object = ourLock;
        synchronized (object) {
            if (this.myUpdateCallbacks == null) {
                this.myUpdateCallbacks = new ArrayList<Consumer<InternalPluginResults>>();
            }
            Consumer<InternalPluginResults> adaptedCallback = PluginUpdatesService.adaptDescriptorConsumerToUpdateResultConsumer(callback);
            this.myUpdateCallbacks.add(adaptedCallback);
            if (ourPrepared) {
                adaptedCallback.accept(PluginUpdatesService.getFilteredUpdateResult());
                return;
            }
        }
        PluginUpdatesService.calculateUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(6);
        }
        Object object = ourLock;
        synchronized (object) {
            if (!ourPrepared || ourAllUpdates == null) {
                return;
            }
            boolean removed = PluginUpdatesService.removeUpdate(descriptor2.getPluginId());
            if (removed) {
                Integer countValue = PluginUpdatesService.getCount(PluginUpdatesService.getFilteredUpdateResult());
                for (PluginUpdatesService service : SERVICES) {
                    service.runCountCallbacks(countValue);
                }
            }
        }
    }

    private static boolean removeUpdate(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginUpdatesService.$$$reportNull$$$0(7);
        }
        if (ourAllUpdates == null || !ContainerUtil.exists(ourAllUpdates.getPluginUpdates().getAll(), d -> Objects.equals(d.getDescriptor().getPluginId(), pluginId))) {
            return false;
        }
        ourAllUpdates = new InternalPluginResults(new PluginUpdates(ContainerUtil.filter(ourAllUpdates.getPluginUpdates().getAllEnabled(), d -> !Objects.equals(d.getDescriptor().getPluginId(), pluginId)), ContainerUtil.filter(ourAllUpdates.getPluginUpdates().getAllDisabled(), d -> !Objects.equals(d.getDescriptor().getPluginId(), pluginId)), ourAllUpdates.getPluginUpdates().getIncompatible()), ourAllUpdates.getPluginNods(), ourAllUpdates.getErrors());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUpdate() {
        Object object = ourLock;
        synchronized (object) {
            if (!ourPrepared || ourAllUpdates == null) {
                return;
            }
            Integer countValue = PluginUpdatesService.getCount(PluginUpdatesService.getFilteredUpdateResult());
            for (PluginUpdatesService service : SERVICES) {
                service.runCountCallbacks(countValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateUpdates() {
        Object object = ourLock;
        synchronized (object) {
            for (PluginUpdatesService service : SERVICES) {
                service.runAllCallbacks(null);
            }
            if (ourPreparing) {
                PluginUpdatesService.resetUpdates();
            } else {
                PluginUpdatesService.calculateUpdates();
            }
        }
    }

    private static void resetUpdates() {
        ourReset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void setFilter(@NotNull Condition<? super IdeaPluginDescriptor> filter2) {
        if (filter2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(8);
        }
        Object object = ourLock;
        synchronized (object) {
            if (!this.mySetFilter && ourFilter != DEFAULT_FILTER) {
                LOG.warn("Filter already set to " + String.valueOf(ourFilter) + ", new filter " + String.valueOf(filter2) + " will be ignored", new Throwable());
                return;
            }
            this.mySetFilter = true;
            PluginUpdatesService.setOurFilter(filter2);
        }
    }

    private static void setOurFilter(@NotNull Condition<? super IdeaPluginDescriptor> filter2) {
        if (filter2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(9);
        }
        ourFilter = filter2;
        PluginUpdatesService.reapplyFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reapplyFilter() {
        Object object = ourLock;
        synchronized (object) {
            for (PluginUpdatesService service : SERVICES) {
                service.runAllCallbacks(null);
            }
            InternalPluginResults filteredUpdates = PluginUpdatesService.getFilteredUpdateResult();
            for (PluginUpdatesService service : SERVICES) {
                service.runAllCallbacks(filteredUpdates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ourLock;
        synchronized (object) {
            PluginUpdatesService.dispose(this);
            if (this.mySetFilter) {
                PluginUpdatesService.setOurFilter(DEFAULT_FILTER);
                this.mySetFilter = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose(@NotNull PluginUpdatesService service) {
        if (service == null) {
            PluginUpdatesService.$$$reportNull$$$0(10);
        }
        Object object = ourLock;
        synchronized (object) {
            SERVICES.remove(service);
            if (SERVICES.isEmpty()) {
                ourAllUpdates = null;
                ourPrepared = false;
                ourPreparing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNeedUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(11);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Object object = ourLock;
        synchronized (object) {
            if (ourPrepared && ourAllUpdates != null) {
                InternalPluginResults filteredUpdates = PluginUpdatesService.getFilteredUpdateResult();
                assert (filteredUpdates != null);
                return ContainerUtil.exists(filteredUpdates.getPluginUpdates().getAll(), d -> Objects.equals(d.getDescriptor().getPluginId(), pluginId));
            }
        }
        return InstalledPluginsState.getInstance().hasNewerVersion(pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Collection<IdeaPluginDescriptor> getUpdates() {
        Object object = ourLock;
        synchronized (object) {
            if (!ourPrepared || ourPreparing) {
                return null;
            }
            InternalPluginResults filteredUpdates = PluginUpdatesService.getFilteredUpdateResult();
            List list2 = filteredUpdates == null ? null : ContainerUtil.map(filteredUpdates.getPluginUpdates().getAll(), PluginDownloader::getDescriptor);
            return list2;
        }
    }

    @Nullable
    @Nls
    public static String getUpdatesTooltip() {
        Collection<IdeaPluginDescriptor> updates = PluginUpdatesService.getUpdates();
        if (ContainerUtil.isEmpty(updates)) {
            return null;
        }
        return IdeBundle.message((String)"updates.plugin.ready.tooltip", (Object[])new Object[]{StringUtil.join(updates, plugin -> plugin.getName(), (String)", "), updates.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void calculateUpdates() {
        Object object = ourLock;
        synchronized (object) {
            if (ourPreparing) {
                return;
            }
            ourPreparing = true;
            ourAllUpdates = null;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            UpdateCheckerFacade updateCheckerFacade = (UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class);
            InternalPluginResults updates = updateCheckerFacade.getInternalPluginUpdates(null, null, null, PluginUpdateActivity.INSTALLED_VERSIONS);
            ApplicationManager.getApplication().invokeLater(() -> {
                Object object = ourLock;
                synchronized (object) {
                    ourPreparing = false;
                    if (ourReset) {
                        ourReset = false;
                        PluginUpdatesService.calculateUpdates();
                        return;
                    }
                    ourPrepared = true;
                    ourAllUpdates = updates;
                    InternalPluginResults filteredUpdates = PluginUpdatesService.getFilteredUpdateResult();
                    for (PluginUpdatesService service : SERVICES) {
                        service.runAllCallbacks(filteredUpdates);
                    }
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable InternalPluginResults filteredUpdates) {
        this.runCountCallbacks(PluginUpdatesService.getCount(filteredUpdates));
        if (this.myUpdateCallbacks != null) {
            for (Consumer<InternalPluginResults> callback : this.myUpdateCallbacks) {
                callback.accept(filteredUpdates);
            }
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myCountCallback != null) {
            this.myCountCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount(@Nullable InternalPluginResults filteredUpdates) {
        return filteredUpdates == null ? null : Integer.valueOf(filteredUpdates.getPluginUpdates().getAll().size());
    }

    @NotNull
    private static Consumer<InternalPluginResults> adaptDescriptorConsumerToUpdateResultConsumer(@NotNull Consumer<? super Collection<PluginUiModel>> consumer) {
        if (consumer == null) {
            PluginUpdatesService.$$$reportNull$$$0(12);
        }
        Consumer<InternalPluginResults> consumer2 = updateResult -> {
            if (updateResult == null) {
                consumer.accept(null);
            } else {
                consumer.accept(ContainerUtil.map(updateResult.getPluginUpdates().getAll(), downloader -> downloader.getUiModel()));
            }
        };
        if (consumer2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(13);
        }
        return consumer2;
    }

    static {
        ourFilter = DEFAULT_FILTER;
        PluginStateManager.addStateListener(new PluginStateListener(){

            @Override
            public void install(@NotNull IdeaPluginDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUpdatesService.finishUpdate(descriptor2);
            }

            @Override
            public void uninstall(@NotNull IdeaPluginDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PluginUpdatesService.finishUpdate(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "descriptor";
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginUpdatesService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "install";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "uninstall";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "connectWithCounter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connectWithUpdates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptDescriptorConsumerToUpdateResultConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connectWithCounter";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connectWithUpdates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateUpdates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setOurFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNeedUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adaptDescriptorConsumerToUpdateResultConsumer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 13 -> new IllegalStateException(string);
        };
    }
}

