/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.ide.ui.AwtColorValue;
import com.intellij.ide.ui.ColorMap;
import com.intellij.ide.ui.ColorValue;
import com.intellij.ide.ui.NamedColorValue;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeBean;
import com.intellij.ide.ui.UiThemeParserKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a,\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fH\u0000\u001a$\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "readColorMapFromJson", "", "", "Lcom/intellij/ide/ui/ColorValue;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "result", "warn", "Lkotlin/Function2;", "", "", "logError", "initializeNamedColors", "theme", "Lcom/intellij/ide/ui/UIThemeBean;", "initColorOnSelectionMap", "colorMap", "", "Ljava/awt/Color;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nColorMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorMap.kt\ncom/intellij/ide/ui/ColorMapKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n13#2:148\n13#2:149\n*S KotlinDebug\n*F\n+ 1 ColorMap.kt\ncom/intellij/ide/ui/ColorMapKt\n*L\n15#1:148\n74#1:149\n*E\n"})
public final class ColorMapKt {
    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(UITheme.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    @NotNull
    public static final Map<String, ColorValue> readColorMapFromJson(@NotNull JsonParser parser, @NotNull Map<String, ColorValue> result2, @NotNull Function2<? super String, ? super Throwable, Unit> warn) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter(warn, (String)"warn");
        if (!(parser.currentToken() == JsonToken.START_OBJECT)) {
            throw new IllegalStateException("Check failed.");
        }
        block7: while (true) {
            JsonToken jsonToken = parser.nextToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    return result2;
                }
                case 2: {
                    String text2 = parser.getText();
                    String key = parser.currentName();
                    Intrinsics.checkNotNull((Object)text2);
                    if (UiThemeParserKt.isColorLike(text2)) {
                        Color color = UiThemeParserKt.parseColorOrNull(text2, key);
                        if (color != null) {
                            Intrinsics.checkNotNull((Object)key);
                            result2.put(key, new AwtColorValue(color));
                            continue block7;
                        }
                        warn.invoke((Object)(key + "=" + text2 + " has # prefix but cannot be parsed as color"), null);
                    }
                    Intrinsics.checkNotNull((Object)key);
                    result2.put(key, new NamedColorValue(text2));
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case -1: {
                    break block7;
                }
                case 4: 
                case 5: {
                    ColorMapKt.logError(parser);
                    parser.skipChildren();
                    continue block7;
                }
                default: {
                    ColorMapKt.logError(parser);
                    continue block7;
                }
            }
            break;
        }
        return result2;
    }

    private static final void logError(JsonParser parser) {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ColorMap.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.warn("Not a color (token=" + parser.currentToken() + ", currentName=" + parser.currentName() + ", currentValue=" + parser.currentValue() + ", currentLocation=" + parser.currentLocation() + ")");
    }

    public static final void initializeNamedColors(@NotNull UIThemeBean theme, @NotNull Function2<? super String, ? super Throwable, Unit> warn) {
        Map<String, ? extends ColorValue> rawColorMap;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(warn, (String)"warn");
        Map<String, ? extends ColorValue> map2 = rawColorMap = theme.colorMap.rawMap;
        if (map2 == null || map2.isEmpty()) {
            theme.colorMap.map = MapsKt.emptyMap();
            return;
        }
        HashMap<String, Color> colorMap = new HashMap<String, Color>(rawColorMap.size());
        theme.colorMap.map = colorMap;
        for (Map.Entry<String, ? extends ColorValue> entry : rawColorMap.entrySet()) {
            Color color;
            String key = entry.getKey();
            ColorValue value = entry.getValue();
            if (value instanceof AwtColorValue) {
                colorMap.put(key, ((AwtColorValue)value).color);
                continue;
            }
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.ide.ui.NamedColorValue");
            String colorName = ((NamedColorValue)value).name;
            ColorValue color2 = rawColorMap.get(colorName);
            if (color2 == null) {
                warn.invoke((Object)("Color " + colorName + " is not mapped for key " + key), null);
                color = colorMap.put(key, Gray.TRANSPARENT);
                continue;
            }
            if (color2 instanceof AwtColorValue) {
                color = colorMap.put(key, ((AwtColorValue)color2).color);
                continue;
            }
            warn.invoke((Object)("Can't handle value " + color2 + " for key '" + key + "'"), null);
            color = Unit.INSTANCE;
        }
        ColorMapKt.initColorOnSelectionMap((Map<String, ? extends Color>)colorMap, theme);
    }

    private static final void initColorOnSelectionMap(Map<String, ? extends Color> colorMap, UIThemeBean theme) {
        Map<String, ? extends ColorValue> rawIconColorOnSelectionMap = theme.iconColorOnSelectionMap.rawMap;
        Map<String, ? extends ColorValue> map2 = rawIconColorOnSelectionMap;
        if (map2 == null || map2.isEmpty()) {
            theme.iconColorOnSelectionMap.map = MapsKt.emptyMap();
            return;
        }
        HashMap<String, Color> map3 = new HashMap<String, Color>(rawIconColorOnSelectionMap.size());
        theme.iconColorOnSelectionMap.map = map3;
        for (Map.Entry<String, ? extends ColorValue> entry : rawIconColorOnSelectionMap.entrySet()) {
            Object object;
            String key = entry.getKey();
            ColorValue value = entry.getValue();
            if (value instanceof AwtColorValue) {
                map3.put(key, ((AwtColorValue)value).color);
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)key, (char)'#', (boolean)false, (int)2, null)) {
                object = key;
            } else {
                Color color = colorMap.get(key);
                if (color == null) {
                    ColorMapKt.getLOG().error("Color by key " + key + " is not defined");
                    continue;
                }
                object = "#" + ColorUtil.toHex((Color)color, (boolean)false);
            }
            String resolvedKey = object;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.ide.ui.NamedColorValue");
            Color resolvedValue = colorMap.get(((NamedColorValue)value).name);
            if (resolvedValue == null) {
                ColorMapKt.getLOG().error("Color by key " + ((NamedColorValue)value).name + " is not defined");
                continue;
            }
            map3.put(resolvedKey, resolvedValue);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.FIELD_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_ARRAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

