/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.ide.ui.IconMapLoader;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayDeque;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a0\u0010\u0007\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"readDataFromJson", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "result", "", "", "addWithCheck", "path", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logError", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIconMapLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconMapLoader.kt\ncom/intellij/ide/ui/IconMapLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n13#2:158\n13#2:159\n*S KotlinDebug\n*F\n+ 1 IconMapLoader.kt\ncom/intellij/ide/ui/IconMapLoaderKt\n*L\n150#1:158\n155#1:159\n*E\n"})
public final class IconMapLoaderKt {
    private static final void readDataFromJson(JsonParser parser, Map<String, String> result2) {
        if (!(parser.nextToken() == JsonToken.START_OBJECT)) {
            throw new IllegalStateException("Check failed.");
        }
        ArrayDeque<String> prefix = new ArrayDeque<String>();
        StringBuilder path = new StringBuilder();
        String currentFieldName = null;
        block12: while (true) {
            JsonToken jsonToken = parser.nextToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 3: {
                    String string = currentFieldName;
                    Intrinsics.checkNotNull((Object)string);
                    prefix.addLast(string);
                    currentFieldName = null;
                    continue block12;
                }
                case 4: {
                    prefix.pollLast();
                    currentFieldName = null;
                    continue block12;
                }
                case 5: {
                    String fieldName = parser.currentName();
                    block13: while (true) {
                        JsonToken jsonToken2 = parser.nextToken();
                        switch (jsonToken2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken2.ordinal()]) {
                            case 1: {
                                continue block12;
                            }
                            case 2: {
                                if (!prefix.isEmpty()) {
                                    CollectionsKt.joinTo$default((Iterable)prefix, (Appendable)path, (CharSequence)"/", null, null, (int)0, null, null, (int)124, null);
                                    path.append('/');
                                }
                                path.append(fieldName);
                                IconMapLoaderKt.addWithCheck(result2, parser, path);
                                path.setLength(0);
                                continue block13;
                            }
                        }
                        IconMapLoaderKt.logError(parser);
                    }
                }
                case 2: {
                    if (!prefix.isEmpty()) {
                        CollectionsKt.joinTo$default((Iterable)prefix, (Appendable)path, (CharSequence)"/", null, null, (int)0, null, null, (int)124, null);
                        path.append('/');
                    }
                    path.append(parser.currentName());
                    IconMapLoaderKt.addWithCheck(result2, parser, path);
                    path.setLength(0);
                    continue block12;
                }
                case 6: {
                    currentFieldName = parser.currentName();
                    continue block12;
                }
                case -1: {
                    return;
                }
            }
            IconMapLoaderKt.logError(parser);
        }
    }

    private static final void addWithCheck(Map<String, String> result2, JsonParser parser, StringBuilder path) {
        String key = parser.getText();
        String string = path.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String p = string;
        Intrinsics.checkNotNull((Object)key);
        String oldValue = result2.put(key, p);
        if (oldValue != null && !Intrinsics.areEqual((Object)oldValue, (Object)p)) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(IconMapLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Double icon mapping: " + key + " -> " + oldValue + " or " + path);
        }
    }

    private static final void logError(JsonParser parser) {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(IconMapLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.warn("JSON contains data in unsupported format (token=" + parser.currentToken() + "): " + parser.currentValue());
    }

    public static final /* synthetic */ void access$readDataFromJson(JsonParser parser, Map result2) {
        IconMapLoaderKt.readDataFromJson(parser, result2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_ARRAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.FIELD_NAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

