/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ScreenUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\"!\u0010\r\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"toggleMaximized", "", "Ljavax/swing/JDialog;", "canBeMaximized", "", "maximize", "canBeNormalized", "normalize", "commonResizingConditionsAreMet", "almostEquals", "r1", "Ljava/awt/Rectangle;", "r2", "NORMAL_BOUNDS", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
public final class MaximizeDialogKt {
    @NotNull
    private static final Key<Rectangle> NORMAL_BOUNDS;

    public static final void toggleMaximized(@NotNull JDialog $this$toggleMaximized) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleMaximized, (String)"<this>");
        if (MaximizeDialogKt.canBeMaximized($this$toggleMaximized)) {
            MaximizeDialogKt.maximize($this$toggleMaximized);
        } else if (MaximizeDialogKt.canBeNormalized($this$toggleMaximized)) {
            MaximizeDialogKt.normalize($this$toggleMaximized);
        }
    }

    public static final boolean canBeMaximized(@NotNull JDialog $this$canBeMaximized) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeMaximized, (String)"<this>");
        if (!MaximizeDialogKt.commonResizingConditionsAreMet($this$canBeMaximized)) {
            return false;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)$this$canBeMaximized);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle rectangle2 = $this$canBeMaximized.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
        return !MaximizeDialogKt.almostEquals(rectangle, rectangle2);
    }

    public static final void maximize(@NotNull JDialog $this$maximize) {
        Intrinsics.checkNotNullParameter((Object)$this$maximize, (String)"<this>");
        if (!MaximizeDialogKt.canBeMaximized($this$maximize)) {
            return;
        }
        ClientProperty.put((Window)$this$maximize, NORMAL_BOUNDS, (Object)$this$maximize.getBounds());
        $this$maximize.setBounds(ScreenUtil.getScreenRectangle((Component)$this$maximize));
    }

    public static final boolean canBeNormalized(@NotNull JDialog $this$canBeNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNormalized, (String)"<this>");
        if (!MaximizeDialogKt.commonResizingConditionsAreMet($this$canBeNormalized)) {
            return false;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)$this$canBeNormalized);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle screenRectangle = rectangle;
        Rectangle rectangle2 = $this$canBeNormalized.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
        return MaximizeDialogKt.almostEquals(rectangle2, screenRectangle) && ClientProperty.get((Component)$this$canBeNormalized, NORMAL_BOUNDS) != null;
    }

    public static final void normalize(@NotNull JDialog $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        if (!MaximizeDialogKt.canBeNormalized($this$normalize)) {
            return;
        }
        Rectangle normalBounds = (Rectangle)ClientProperty.get((Component)$this$normalize, NORMAL_BOUNDS);
        if (normalBounds != null) {
            ScreenUtil.fitToScreen((Rectangle)normalBounds);
            $this$normalize.setBounds(normalBounds);
            ClientProperty.remove((Window)$this$normalize, NORMAL_BOUNDS);
        }
    }

    private static final boolean commonResizingConditionsAreMet(JDialog $this$commonResizingConditionsAreMet) {
        return $this$commonResizingConditionsAreMet.isShowing() && $this$commonResizingConditionsAreMet.isResizable() && $this$commonResizingConditionsAreMet.getRootPane() != null;
    }

    private static final boolean almostEquals(Rectangle r1, Rectangle r2) {
        int tolerance = Registry.Companion.intValue("ide.dialog.maximize.tolerance", 10);
        return Math.abs(r1.x - r2.x) <= tolerance && Math.abs(r1.y - r2.y) <= tolerance && Math.abs(r1.width - r2.width) <= tolerance && Math.abs(r1.height - r2.height) <= tolerance;
    }

    static {
        Key key = Key.create((String)"NORMAL_BOUNDS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NORMAL_BOUNDS = key;
    }
}

