/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UIDensity;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.DefaultClassicThemeStrategy;
import com.intellij.ide.ui.laf.DefaultNewUiThemeStrategy;
import com.intellij.ide.ui.laf.DefaultThemeStrategy;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.OurPopupFactory;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.FontUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a \u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0018\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0018H\u0002\u001a\b\u0010*\u001a\u00020\u001fH\u0002\u001a\b\u0010+\u001a\u00020,H\u0002\u001a\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0002\u001a\u0010\u00106\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0002\u001a\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020!H\u0002\u001a\u0010\u00109\u001a\u00020\u001f2\u0006\u00108\u001a\u00020!H\u0002\u001a\u0018\u0010=\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010>\u001a\u00020\u001aH\u0000\u001a\u0010\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010@0.H\u0002\u001a\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020,H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0013\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000b\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\r\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0011\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0012\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010-\u001a\u0010\u0012\f\u0012\n /*\u0004\u0018\u00010\u00010\u00010.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u00100\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\"\u0018\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010;8\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010<\"\u0018\u0010E\u001a\u00020\u0001*\u00020F8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006I"}, d2={"WINDOW_ALPHA", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ELEMENT_LAF", "Lorg/jetbrains/annotations/NonNls;", "ELEMENT_PREFERRED_LIGHT_LAF", "ELEMENT_PREFERRED_DARK_LAF", "ATTRIBUTE_AUTODETECT", "ATTRIBUTE_THEME_NAME", "ELEMENT_PREFERRED_LIGHT_EDITOR_SCHEME", "ELEMENT_PREFERRED_DARK_EDITOR_SCHEME", "ATTRIBUTE_EDITOR_SCHEME_NAME", "ELEMENT_LAFS_TO_PREVIOUS_SCHEMES", "ELEMENT_LAF_TO_SCHEME", "ATTRIBUTE_LAF", "ATTRIBUTE_SCHEME", "HIGH_CONTRAST_THEME_ID", "DARCULA_EDITOR_THEME_KEY", "DEFAULT_EDITOR_THEME_KEY", "INTER_NAME", "INTER_SIZE", "", "getFont", "Ljavax/swing/plaf/FontUIResource;", "yosemite", "size", "style", "installLinuxFonts", "", "defaults", "Ljavax/swing/UIDefaults;", "patchHiDPI", "patchRowHeight", "key", "prevScale", "", "intSystemPropertyValue", "name", "defaultValue", "fixPopupWeight", "useInterFont", "", "LANGUAGE_WITH_PACK_LIST", "", "kotlin.jvm.PlatformType", "shouldFallbackToSystemFont", "getShouldFallbackToSystemFont", "()Z", "updateUI", "window", "Ljava/awt/Window;", "repaintUI", "applyDensityOnUpdateUi", "uiDefaults", "applyAltColors", "patchableFontResources", "", "[Ljava/lang/String;", "initFontDefaults", "uiFont", "computeValuesOfUsedUiOptions", "", "installMacosXFonts", "getDefaultLaf", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfo;", "isDark", "baseName", "Lcom/intellij/openapi/options/Scheme;", "getBaseName", "(Lcom/intellij/openapi/options/Scheme;)Ljava/lang/String;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLafManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LafManagerImpl.kt\ncom/intellij/ide/ui/laf/LafManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1532:1\n13#2:1533\n*S KotlinDebug\n*F\n+ 1 LafManagerImpl.kt\ncom/intellij/ide/ui/laf/LafManagerImplKt\n*L\n91#1:1533\n*E\n"})
public final class LafManagerImplKt {
    @NotNull
    private static final String WINDOW_ALPHA = "Window.alpha";
    @NotNull
    private static final String ELEMENT_LAF = "laf";
    @NotNull
    private static final String ELEMENT_PREFERRED_LIGHT_LAF = "preferred-light-laf";
    @NotNull
    private static final String ELEMENT_PREFERRED_DARK_LAF = "preferred-dark-laf";
    @NotNull
    private static final String ATTRIBUTE_AUTODETECT = "autodetect";
    @NotNull
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    @NotNull
    private static final String ELEMENT_PREFERRED_LIGHT_EDITOR_SCHEME = "preferred-light-editor-scheme";
    @NotNull
    private static final String ELEMENT_PREFERRED_DARK_EDITOR_SCHEME = "preferred-dark-editor-scheme";
    @NotNull
    private static final String ATTRIBUTE_EDITOR_SCHEME_NAME = "editorSchemeId";
    @NotNull
    private static final String ELEMENT_LAFS_TO_PREVIOUS_SCHEMES = "lafs-to-previous-schemes";
    @NotNull
    private static final String ELEMENT_LAF_TO_SCHEME = "laf-to-scheme";
    @NotNull
    private static final String ATTRIBUTE_LAF = "laf";
    @NotNull
    private static final String ATTRIBUTE_SCHEME = "scheme";
    @NotNull
    private static final String HIGH_CONTRAST_THEME_ID = "JetBrainsHighContrastTheme";
    @NotNull
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.SavedEditorTheme";
    @NotNull
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.SavedEditorTheme";
    @NotNull
    private static final String INTER_NAME = "Inter";
    private static final int INTER_SIZE = 13;
    @NotNull
    private static final List<String> LANGUAGE_WITH_PACK_LIST;
    @JvmField
    @NotNull
    public static final String[] patchableFontResources;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(LafManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    private static final FontUIResource getFont(String yosemite, int size2, int style) {
        if (SystemInfoRt.isMac) {
            Font font = FontUtil.enableKerning((Font)new Font(SystemInfo.isMacOSCatalina ? ".AppleSystemUIFont" : ".SF NS Text", style, size2));
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"enableKerning(...)");
            Font font2 = font;
            if (!StartupUiUtil.isDialogFont((Font)font2)) {
                return new FontUIResource(font2);
            }
        }
        return new FontUIResource(yosemite, style, size2);
    }

    private static final void installLinuxFonts(UIDefaults defaults) {
        defaults.put("MenuItem.acceleratorFont", defaults.get("MenuItem.font"));
    }

    private static final void patchHiDPI(UIDefaults defaults) {
        float prevScale;
        Object prevScaleVal;
        Object object = prevScaleVal = defaults.get("hidpi.scaleFactor");
        float prevRowHeightScale = prevScale = object == null ? 1.0f : ((Float)object).floatValue();
        LafManagerImplKt.patchRowHeight(defaults, "List.rowHeight", prevRowHeightScale);
        LafManagerImplKt.patchRowHeight(defaults, "Table.rowHeight", prevRowHeightScale);
        String string = JBUI.CurrentTheme.Tree.rowHeightKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rowHeightKey(...)");
        LafManagerImplKt.patchRowHeight(defaults, string, prevRowHeightScale);
        String string2 = JBUI.CurrentTheme.VersionControl.Log.rowHeightKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rowHeightKey(...)");
        LafManagerImplKt.patchRowHeight(defaults, string2, prevRowHeightScale);
        if (prevScale == JBUIScale.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        Object[] objectArray = new String[]{"Tree.leftChildIndent", "Tree.rightChildIndent", "SettingsTree.rowHeight"};
        HashSet intKeys = SetsKt.hashSetOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize"};
        HashSet dimensionKeys = SetsKt.hashSetOf((Object[])objectArray2);
        Map valuesToScale = new LinkedHashMap();
        defaults.forEach((arg_0, arg_1) -> LafManagerImplKt.patchHiDPI$lambda$0(dimensionKeys, valuesToScale, intKeys, prevScale, arg_0, arg_1));
        for (Map.Entry entry : valuesToScale.entrySet()) {
            Object key = entry.getKey();
            Function0 valueSupplier = (Function0)entry.getValue();
            defaults.put(key, valueSupplier.invoke());
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUIScale.scale((float)1.0f)));
    }

    private static final void patchRowHeight(UIDefaults defaults, String key, float prevScale) {
        int custom;
        int rowHeight;
        Object value = defaults.get(key);
        int n = rowHeight = value instanceof Integer ? ((Number)value).intValue() : 0;
        if (rowHeight <= 0) {
            LafManagerImplKt.getLOG().warn(key + " = " + value + " in " + UIManager.getLookAndFeel().getName() + "; it may lead to performance degradation");
        }
        defaults.put(key, (Object)((custom = LafManagerImplKt.intSystemPropertyValue("ide.override." + key, -1)) >= 0 ? JBUIScale.scale((int)custom) : (rowHeight <= 0 ? 0 : JBUIScale.scale((int)((int)((float)rowHeight / prevScale))))));
    }

    private static final int intSystemPropertyValue(String name2, int defaultValue) {
        Object object;
        try {
            boolean bl = false;
            String string = System.getProperty(name2);
            object = Result.constructor-impl((Object)(string != null ? Integer.parseInt(string) : defaultValue));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Integer n = (Integer)(Result.isFailure-impl((Object)object) ? null : object);
        return n != null ? n : defaultValue;
    }

    /*
     * Unable to fully structure code
     */
    private static final void fixPopupWeight() {
        popupWeight = 1;
        v0 = System.getProperty("idea.popup.weight");
        if (v0 == null) ** GOTO lbl-1000
        v1 = v0.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
        v0 = v1;
        if (v1 != null) {
            v2 = StringsKt.trim((CharSequence)v0).toString();
        } else lbl-1000:
        // 2 sources

        {
            v2 = property = null;
        }
        if (SystemInfoRt.isMac) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfoRt.isWindows) {
                popupWeight = 2;
            }
        } else if (Intrinsics.areEqual((Object)"light", (Object)property)) {
            popupWeight = 0;
        } else if (Intrinsics.areEqual((Object)"heavy", (Object)property)) {
            popupWeight = 2;
        } else if (!Intrinsics.areEqual((Object)"medium", (Object)property)) {
            LafManagerImplKt.getLOG().error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof OurPopupFactory)) {
            var3_3 = factory;
            Intrinsics.checkNotNull((Object)var3_3);
            factory = new OurPopupFactory(var3_3);
            PopupFactory.setSharedInstance(factory);
        }
        PopupUtil.setPopupType((PopupFactory)factory, (int)popupWeight);
    }

    private static final boolean useInterFont() {
        return (ExperimentalUI.Companion.isNewUI() && SystemInfo.isJetBrainsJvm || Registry.Companion.is("ide.ui.font.force.use.inter.font", false)) && !LafManagerImplKt.getShouldFallbackToSystemFont();
    }

    private static final boolean getShouldFallbackToSystemFont() {
        return LANGUAGE_WITH_PACK_LIST.contains(Locale.getDefault().getLanguage());
    }

    private static final void updateUI(Window window) {
        IJSwingUtilities.updateComponentTreeUI(window);
        Window[] windowArray = window.getOwnedWindows();
        Intrinsics.checkNotNullExpressionValue((Object)windowArray, (String)"getOwnedWindows(...)");
        for (Window w : windowArray) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    private static final void repaintUI(Window window) {
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        Window[] windowArray = window.getOwnedWindows();
        Intrinsics.checkNotNullExpressionValue((Object)windowArray, (String)"getOwnedWindows(...)");
        for (Window aChildren : windowArray) {
            Intrinsics.checkNotNull((Object)aChildren);
            LafManagerImplKt.repaintUI(aChildren);
        }
    }

    private static final void applyDensityOnUpdateUi(UIDefaults uiDefaults) {
        Object vcsLogHeight;
        UIDensity newDensity;
        String densityKey = "ui.density";
        Object object = uiDefaults.get(densityKey);
        String oldDensityName = object instanceof String ? (String)object : null;
        if (Intrinsics.areEqual((Object)oldDensityName, (Object)(newDensity = UISettings.Companion.getInstance().getUiDensity()).name())) {
            return;
        }
        uiDefaults.put(densityKey, newDensity.name());
        if (newDensity == UIDensity.DEFAULT && (vcsLogHeight = uiDefaults.get(JBUI.CurrentTheme.VersionControl.Log.rowHeightKey())) == null) {
            uiDefaults.put(JBUI.CurrentTheme.VersionControl.Log.rowHeightKey(), (Object)JBUI.CurrentTheme.VersionControl.Log.defaultRowHeight());
        }
        if (newDensity == UIDensity.COMPACT) {
            Map compactValues = new LinkedHashMap();
            uiDefaults.forEach((arg_0, arg_1) -> LafManagerImplKt.applyDensityOnUpdateUi$lambda$0(compactValues, arg_0, arg_1));
            uiDefaults.putAll(compactValues);
        }
    }

    private static final void applyAltColors(UIDefaults uiDefaults) {
        if (UISettings.Companion.getInstance().getDifferentToolwindowBackground()) {
            Map altValues = new LinkedHashMap();
            uiDefaults.forEach((arg_0, arg_1) -> LafManagerImplKt.applyAltColors$lambda$0(altValues, arg_0, arg_1));
            uiDefaults.putAll(altValues);
        }
    }

    public static final void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        Intrinsics.checkNotNullParameter((Object)uiFont, (String)"uiFont");
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : patchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        defaults.put("PasswordField.font", textFont);
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    private static final List<Object> computeValuesOfUsedUiOptions() {
        UISettings uiSettings = UISettings.Companion.getInstance();
        Object[] objectArray = new Object[]{uiSettings.getOverrideLafFonts(), uiSettings.getFontFace(), Float.valueOf(uiSettings.getFontSize2D()), uiSettings.getIdeAAType(), uiSettings.getEditorAAType(), Float.valueOf(uiSettings.getIdeScale()), Float.valueOf(uiSettings.getPresentationModeIdeScale())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final void installMacosXFonts(UIDefaults defaults) {
        String face = "Helvetica Neue";
        LafManagerImplKt.initFontDefaults(defaults, LafManagerImplKt.getFont(face, 13, 0));
        defaults.replaceAll((arg_0, arg_1) -> LafManagerImplKt.installMacosXFonts$lambda$0(face, arg_0, arg_1));
        defaults.put("TableHeader.font", LafManagerImplKt.getFont(face, 11, 0));
        FontUIResource buttonFont = LafManagerImplKt.getFont("Helvetica Neue", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImplKt.getFont("Lucida Grande", 13, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
    }

    @NotNull
    public static final UIThemeLookAndFeelInfo getDefaultLaf(boolean isDark) {
        UiThemeProviderListManager themeListManager = UiThemeProviderListManager.Companion.getInstance();
        boolean isNewUi = ExperimentalUI.Companion.isNewUI();
        DefaultThemeStrategy strategy = isNewUi ? (DefaultThemeStrategy)DefaultNewUiThemeStrategy.INSTANCE : (DefaultThemeStrategy)DefaultClassicThemeStrategy.INSTANCE;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getInstanceEx(...)");
        String id2 = strategy.getProductDefaultId(isDark, applicationInfoEx);
        if (id2 != null) {
            UIThemeLookAndFeelInfo theme;
            UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = themeListManager.findThemeById(id2);
            if (uIThemeLookAndFeelInfo == null) {
                uIThemeLookAndFeelInfo = themeListManager.findThemeByName(id2);
            }
            if ((theme = uIThemeLookAndFeelInfo) == null) {
                LafManagerImplKt.getLOG().error("Default theme not found(id=" + id2 + ", isDark=" + isDark + ", isNewUI=" + isNewUi + ")");
            } else {
                return theme;
            }
        }
        id2 = strategy.getPlatformDefaultId(isDark);
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = themeListManager.findThemeById(id2);
        if (uIThemeLookAndFeelInfo == null) {
            throw new IllegalStateException(("Default theme not found(id=" + id2 + ", isDark=" + isDark + ", isNewUI=" + isNewUi + ")").toString());
        }
        return uIThemeLookAndFeelInfo;
    }

    private static final String getBaseName(Scheme $this$baseName) {
        String string = Scheme.getBaseName((String)$this$baseName.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        return string;
    }

    private static final void patchHiDPI$lambda$0(HashSet $dimensionKeys, Map $valuesToScale, HashSet $intKeys, float $prevScale, Object key, Object value) {
        String keyAsString = key.toString();
        if (value instanceof Dimension) {
            if (value instanceof UIResource || $dimensionKeys.contains(keyAsString)) {
                $valuesToScale.put(key, () -> LafManagerImplKt.patchHiDPI$lambda$0$0(value));
            }
        } else if (value instanceof Insets) {
            if (value instanceof UIResource) {
                $valuesToScale.put(key, () -> LafManagerImplKt.patchHiDPI$lambda$0$1(value));
            }
        } else if (value instanceof Integer && (StringsKt.endsWith$default((String)keyAsString, (String)".maxGutterIconWidth", (boolean)false, (int)2, null) || $intKeys.contains(keyAsString))) {
            int normValue = (int)(((Number)value).floatValue() / $prevScale);
            $valuesToScale.put(key, () -> LafManagerImplKt.patchHiDPI$lambda$0$2(normValue));
        }
    }

    private static final Object patchHiDPI$lambda$0$0(Object $value) {
        JBDimension.JBDimensionUIResource jBDimensionUIResource = JBDimension.size((Dimension)((Dimension)$value)).asUIResource();
        Intrinsics.checkNotNullExpressionValue((Object)jBDimensionUIResource, (String)"asUIResource(...)");
        return jBDimensionUIResource;
    }

    private static final Object patchHiDPI$lambda$0$1(Object $value) {
        Intrinsics.checkNotNull((Object)$value, (String)"null cannot be cast to non-null type java.awt.Insets");
        JBInsets.JBInsetsUIResource jBInsetsUIResource = JBInsets.create((Insets)((Insets)$value)).asUIResource();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsetsUIResource, (String)"asUIResource(...)");
        return jBInsetsUIResource;
    }

    private static final Object patchHiDPI$lambda$0$2(int $normValue) {
        return JBUIScale.scale((int)$normValue);
    }

    private static final void applyDensityOnUpdateUi$lambda$0(Map $compactValues, Object key, Object value) {
        String string = key instanceof String ? (String)key : null;
        boolean bl = string != null ? StringsKt.endsWith$default((String)string, (String)".compact", (boolean)false, (int)2, null) : false;
        if (bl) {
            $compactValues.put(StringsKt.removeSuffix((String)((String)key), (CharSequence)".compact"), value);
        }
    }

    private static final void applyAltColors$lambda$0(Map $altValues, Object key, Object value) {
        String string = key instanceof String ? (String)key : null;
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"alt.", (boolean)false, (int)2, null) : false;
        if (bl) {
            String string2 = ((String)key).substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            $altValues.put(string2, value);
        }
    }

    private static final Object installMacosXFonts$lambda$0(String $face, Object key, Object value) {
        return key instanceof String && StringsKt.endsWith((String)((String)key), (String)"font", (boolean)true) && !StringsKt.contains$default((CharSequence)((CharSequence)key), (CharSequence)"Menu", (boolean)false, (int)2, null) && value instanceof FontUIResource && (Intrinsics.areEqual((Object)((FontUIResource)value).getFamily(), (Object)"Lucida Grande") || Intrinsics.areEqual((Object)((FontUIResource)value).getFamily(), (Object)"Serif")) ? LafManagerImplKt.getFont($face, ((FontUIResource)value).getSize(), ((FontUIResource)value).getStyle()) : value;
    }

    public static final /* synthetic */ boolean access$useInterFont() {
        return LafManagerImplKt.useInterFont();
    }

    public static final /* synthetic */ List access$computeValuesOfUsedUiOptions() {
        return LafManagerImplKt.computeValuesOfUsedUiOptions();
    }

    public static final /* synthetic */ String access$getBaseName(Scheme $receiver) {
        return LafManagerImplKt.getBaseName($receiver);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return LafManagerImplKt.getLOG();
    }

    public static final /* synthetic */ void access$installMacosXFonts(UIDefaults defaults) {
        LafManagerImplKt.installMacosXFonts(defaults);
    }

    public static final /* synthetic */ void access$installLinuxFonts(UIDefaults defaults) {
        LafManagerImplKt.installLinuxFonts(defaults);
    }

    public static final /* synthetic */ void access$fixPopupWeight() {
        LafManagerImplKt.fixPopupWeight();
    }

    public static final /* synthetic */ void access$applyDensityOnUpdateUi(UIDefaults uiDefaults) {
        LafManagerImplKt.applyDensityOnUpdateUi(uiDefaults);
    }

    public static final /* synthetic */ void access$applyAltColors(UIDefaults uiDefaults) {
        LafManagerImplKt.applyAltColors(uiDefaults);
    }

    public static final /* synthetic */ void access$patchHiDPI(UIDefaults defaults) {
        LafManagerImplKt.patchHiDPI(defaults);
    }

    public static final /* synthetic */ void access$updateUI(Window window) {
        LafManagerImplKt.updateUI(window);
    }

    public static final /* synthetic */ void access$repaintUI(Window window) {
        LafManagerImplKt.repaintUI(window);
    }

    static {
        Object[] objectArray = new String[]{Locale.CHINESE.getLanguage(), Locale.KOREAN.getLanguage(), Locale.JAPANESE.getLanguage()};
        LANGUAGE_WITH_PACK_LIST = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
        patchableFontResources = objectArray;
    }
}

