/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionEntry;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.dsl.listCellRenderer.KotlinUIDslRendererComponent;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u001a\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u001aB\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00052\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\bH\u0007\u001a\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001aB\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00142\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\b2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0007\u001a\u0012\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0014H\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\b\u0010\"\u001a\u0004\u0018\u00010+H\u0002\u001a\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050*2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002\u001a&\u0010/\u001a\u00020\n2\u0006\u0010\u0011\u001a\u0002002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\u0006\u0010\"\u001a\u00020\u0014H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "QUOTED", "Ljava/util/regex/Pattern;", "processFilter", "", "filter", "quoted", "", "processExpandedGroups", "", "group", "Lcom/intellij/openapi/options/ConfigurableGroup;", "result", "", "Lcom/intellij/openapi/options/Configurable;", "addChildren", "configurable", "highlightComponent", "rootComponent", "Ljavax/swing/JComponent;", "searchString", "HTML_PATTERN", "processUiLabel", "title", "configurableOptions", "Lcom/intellij/ide/ui/search/OptionDescription;", "path", "i18n", "", "rawList", "Lcom/intellij/ide/ui/search/SearchableOptionEntry;", "getNonWordPattern", "collectSearchItemsForComponent", "component", "getLabelFromTextView", "getLabelFromComponent", "label", "Ljavax/swing/JLabel;", "button", "Ljavax/swing/AbstractButton;", "getLabelsFromComponent", "", "Ljava/awt/Component;", "getItemsFromComboBox", "comboBox", "Ljavax/swing/JComboBox;", "collectSearchItemsForComponentWithLabel", "Lcom/intellij/openapi/options/SearchableConfigurable;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchUtil.kt\ncom/intellij/ide/ui/search/SearchUtilKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,780:1\n106#2:781\n78#2,22:782\n1#3:804\n13#4:805\n*S KotlinDebug\n*F\n+ 1 SearchUtil.kt\ncom/intellij/ide/ui/search/SearchUtilKt\n*L\n523#1:781\n523#1:782,22\n33#1:805\n*E\n"})
public final class SearchUtilKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pattern QUOTED;
    @NotNull
    private static final Pattern HTML_PATTERN;

    /*
     * WARNING - void declaration
     */
    private static final String processFilter(String filter2, Set<String> quoted) {
        StringBuilder withoutQuoted = new StringBuilder();
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter2);
        while (matcher.find()) {
            String trimmed;
            void $this$trim$iv;
            int start2 = matcher.start(1);
            withoutQuoted.append(" ").append(filter2, beg, start2);
            beg = matcher.end(1);
            Intrinsics.checkNotNullExpressionValue((Object)filter2.substring(start2, beg), (String)"substring(...)");
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) continue;
            quoted.add(trimmed);
        }
        String string = withoutQuoted.toString();
        String string2 = filter2.substring(beg);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string + " " + string2;
    }

    public static final void processExpandedGroups(@NotNull ConfigurableGroup group2, @NotNull Collection<Configurable> result2) {
        Configurable[] configurables2;
        Configurable configurable;
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Configurable[] configurableArray = group2.getConfigurables();
        Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
        for (Configurable configurable2 : configurableArray) {
            Intrinsics.checkNotNull((Object)configurable2);
            configurable = configurable2;
            result2.add(configurable);
        }
        for (Configurable configurable2 : configurables2) {
            Intrinsics.checkNotNull((Object)configurable2);
            configurable = configurable2;
            SearchUtilKt.addChildren(configurable, result2);
        }
    }

    private static final void addChildren(Configurable configurable, Collection<Configurable> result2) {
        if (configurable instanceof Configurable.Composite) {
            Configurable[] configurableArray = ((Configurable.Composite)configurable).getConfigurables();
            Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
            for (Configurable configurable2 : configurableArray) {
                Intrinsics.checkNotNull((Object)configurable2);
                Configurable kid = configurable2;
                result2.add(kid);
                SearchUtilKt.addChildren(kid, result2);
            }
        }
    }

    private static final void highlightComponent(JComponent rootComponent, String searchString) {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<ComponentHighlightingListener> topic = ComponentHighlightingListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ComponentHighlightingListener)messageBus.syncPublisher(topic)).highlight(rootComponent, searchString);
    }

    @ApiStatus.Internal
    public static final void processUiLabel(@NotNull String title2, @Nullable Set<OptionDescription> configurableOptions, @Nullable String path, boolean i18n, @Nullable Set<SearchableOptionEntry> rawList) {
        int headEnd;
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        if (StringsKt.isBlank((CharSequence)title2)) {
            return;
        }
        Object title3 = title2;
        int headStart = StringsKt.indexOf$default((CharSequence)((CharSequence)title3), (String)"<head>", (int)0, (boolean)false, (int)6, null);
        int n = headEnd = headStart >= 0 ? StringsKt.indexOf$default((CharSequence)((CharSequence)title3), (String)"</head>", (int)0, (boolean)false, (int)6, null) : -1;
        if (headEnd > headStart) {
            String string = ((String)title3).substring(0, headStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = ((String)title3).substring(headEnd + 7);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            title3 = string + string2;
        }
        String string = HTML_PATTERN.matcher((CharSequence)title3).replaceAll(" ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
        title3 = string;
        if (StringsKt.isBlank((CharSequence)((CharSequence)title3))) {
            return;
        }
        if (configurableOptions == null) {
            Set<SearchableOptionEntry> set = rawList;
            Intrinsics.checkNotNull(set);
            set.add(new SearchableOptionEntry((String)title3, path));
        } else {
            Pattern pattern = SearchableOptionsRegistrarImplKt.getWORD_SEPARATOR_CHARS();
            String string3 = ((String)title3).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String[] stringArray = pattern.split(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
            Set words = ArraysKt.toSet((Object[])stringArray);
            title3 = StringsKt.replace$default((String)title3, (String)"\u001b", (String)"", (boolean)false, (int)4, null);
            String string4 = SearchUtilKt.getNonWordPattern(i18n).matcher((CharSequence)title3).replaceAll(" ");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"replaceAll(...)");
            title3 = string4;
            for (String word : words) {
                configurableOptions.add(new OptionDescription(word, (String)title3, path));
            }
        }
    }

    private static final Pattern getNonWordPattern(boolean i18n) {
        Pattern pattern = Pattern.compile("[" + (i18n ? "^\\pL" : "\\W") + "&&[^\\p{Punct}\\p{Blank}]]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return pattern;
    }

    @ApiStatus.Internal
    public static final void collectSearchItemsForComponent(@NotNull JComponent component2, @Nullable Set<OptionDescription> configurableOptions, @Nullable Set<SearchableOptionEntry> rawList, @Nullable String path, boolean i18n) {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            List<String> label2;
                            Border border;
                            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                            if (ClientProperty.isTrue((Component)component2, SearchUtil.SEARCH_SKIP_COMPONENT_KEY)) {
                                return;
                            }
                            List list2 = (List)ClientProperty.get((Component)component2, SearchUtil.ADDITIONAL_SEARCH_LABELS_KEY);
                            if (list2 != null) {
                                List additional = list2;
                                boolean bl = false;
                                Iterator iterator2 = additional.iterator();
                                while (iterator2.hasNext()) {
                                    String each = (String)iterator2.next();
                                    SearchUtilKt.processUiLabel(each, configurableOptions, path, i18n, rawList);
                                }
                            }
                            if ((border = component2.getBorder()) instanceof TitledBorder) {
                                String string = ((TitledBorder)border).getTitle();
                                if (string != null) {
                                    String it = string;
                                    boolean bl = false;
                                    SearchUtilKt.processUiLabel(it, configurableOptions, path, i18n, rawList);
                                }
                            }
                            if ((label2 = SearchUtilKt.getLabelsFromComponent(component2)).isEmpty()) break block10;
                            for (String each : label2) {
                                SearchUtilKt.processUiLabel(each, configurableOptions, path, i18n, rawList);
                            }
                            break block11;
                        }
                        if (!(component2 instanceof JComboBox)) break block12;
                        List<String> labels = SearchUtilKt.getItemsFromComboBox((JComboBox)component2);
                        for (String each : labels) {
                            SearchUtilKt.processUiLabel(each, configurableOptions, path, i18n, rawList);
                        }
                        break block11;
                    }
                    if (!(component2 instanceof JTabbedPane)) break block13;
                    int tabCount = ((JTabbedPane)component2).getTabCount();
                    for (int i2 = 0; i2 < tabCount; ++i2) {
                        String string = path;
                        Object title2 = string == null ? ((JTabbedPane)component2).getTitleAt(i2) : string + "." + ((JTabbedPane)component2).getTitleAt(i2);
                        Intrinsics.checkNotNull((Object)title2);
                        SearchUtilKt.processUiLabel((String)title2, configurableOptions, (String)title2, i18n, rawList);
                        Component tabComponent = ((JTabbedPane)component2).getComponentAt(i2);
                        if (!(tabComponent instanceof JComponent)) continue;
                        SearchUtilKt.collectSearchItemsForComponent((JComponent)tabComponent, configurableOptions, rawList, (String)title2, i18n);
                    }
                    break block11;
                }
                if (!(component2 instanceof TabbedPaneWrapper.TabbedPaneHolder)) break block14;
                TabbedPaneWrapper tabbedPane = ((TabbedPaneWrapper.TabbedPaneHolder)component2).getTabbedPaneWrapper();
                int tabCount = tabbedPane.getTabCount();
                for (int i3 = 0; i3 < tabCount; ++i3) {
                    JComponent it;
                    String tabTitle = tabbedPane.getTitleAt(i3);
                    String string = path;
                    Object title3 = string == null ? tabTitle : string + "." + tabTitle;
                    Intrinsics.checkNotNull((Object)title3);
                    SearchUtilKt.processUiLabel((String)title3, configurableOptions, (String)title3, i18n, rawList);
                    if (tabbedPane.getComponentAt(i3) == null) continue;
                    boolean bl = false;
                    SearchUtilKt.collectSearchItemsForComponent(it, configurableOptions, rawList, (String)title3, i18n);
                }
                break block11;
            }
            Component[] componentArray = component2.getComponents();
            if (componentArray == null) break block11;
            Component[] components = componentArray;
            boolean bl = false;
            for (Component child : components) {
                if (!(child instanceof JComponent)) continue;
                SearchUtilKt.collectSearchItemsForComponent((JComponent)child, configurableOptions, rawList, path, i18n);
            }
        }
    }

    private static final String getLabelFromTextView(JComponent component2) {
        Object view2 = component2.getClientProperty("html");
        if (!(view2 instanceof View)) {
            return null;
        }
        Document document2 = ((View)view2).getDocument();
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        int length = document3.getLength();
        try {
            return document3.getText(0, length);
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static final String getLabelFromComponent(JLabel label2) {
        String string = SearchUtilKt.getLabelFromTextView(label2);
        if (string == null) {
            string = label2.getText();
        }
        return string;
    }

    private static final String getLabelFromComponent(AbstractButton button2) {
        String string = SearchUtilKt.getLabelFromTextView(button2);
        if (string == null) {
            string = button2.getText();
        }
        return string;
    }

    private static final List<String> getLabelsFromComponent(Component component2) {
        String string;
        String label2;
        Component component3 = component2;
        String string2 = label2 = component3 instanceof JLabel ? SearchUtilKt.getLabelFromComponent((JLabel)component2) : (component3 instanceof JCheckBox ? SearchUtilKt.getLabelFromComponent((AbstractButton)component2) : (component3 instanceof JRadioButton ? SearchUtilKt.getLabelFromComponent((AbstractButton)component2) : (component3 instanceof JButton ? SearchUtilKt.getLabelFromComponent((AbstractButton)component2) : (component3 instanceof KotlinUIDslRendererComponent ? ((KotlinUIDslRendererComponent)component2).getCopyText() : null))));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            string = null;
        }
        label2 = string;
        List list2 = (List)ClientProperty.get((Component)component2, SearchUtil.ADDITIONAL_SEARCH_LABELS_KEY);
        if (list2 == null) {
            return CollectionsKt.listOfNotNull((Object)label2);
        }
        List labels = list2;
        ArrayList<String> list3 = new ArrayList<String>(labels);
        if (label2 != null) {
            list3.add(label2);
        }
        return list3;
    }

    private static final List<String> getItemsFromComboBox(JComboBox<?> comboBox) {
        ListCellRenderer listCellRenderer = comboBox.getRenderer();
        ListCellRenderer listCellRenderer2 = listCellRenderer instanceof ListCellRenderer ? listCellRenderer : null;
        if (listCellRenderer2 == null) {
            listCellRenderer2 = new DefaultListCellRenderer();
        }
        ListCellRenderer renderer2 = listCellRenderer2;
        Intrinsics.checkNotNull(comboBox, (String)"null cannot be cast to non-null type javax.swing.JComboBox<kotlin.Any?>");
        JList<Object> jList = new BasicComboPopup(comboBox).getList();
        ArrayList result2 = new ArrayList();
        int count = comboBox.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object value = comboBox.getItemAt(i2);
            Component labelComponent = renderer2.getListCellRendererComponent(jList, value, i2, false, false);
            result2.addAll(SearchUtilKt.getLabelsFromComponent(labelComponent));
        }
        return result2;
    }

    @ApiStatus.Internal
    public static final void collectSearchItemsForComponentWithLabel(@NotNull SearchableConfigurable configurable, @NotNull Set<SearchableOptionEntry> configurableOptions, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(configurableOptions, (String)"configurableOptions");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        String string = configurable.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        SearchUtilKt.processUiLabel(string, null, null, false, configurableOptions);
        SearchUtilKt.collectSearchItemsForComponent(component2, null, configurableOptions, null, false);
    }

    public static final /* synthetic */ List access$getLabelsFromComponent(Component component2) {
        return SearchUtilKt.getLabelsFromComponent(component2);
    }

    public static final /* synthetic */ void access$highlightComponent(JComponent rootComponent, String searchString) {
        SearchUtilKt.highlightComponent(rootComponent, searchString);
    }

    public static final /* synthetic */ List access$getItemsFromComboBox(JComboBox comboBox) {
        return SearchUtilKt.getItemsFromComboBox(comboBox);
    }

    public static final /* synthetic */ String access$processFilter(String filter2, Set quoted) {
        return SearchUtilKt.processFilter(filter2, quoted);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SearchUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        Pattern pattern = Pattern.compile("\"([^\"]+)\"");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        QUOTED = pattern;
        Pattern pattern2 = Pattern.compile("<[^<>]*>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        HTML_PATTERN = pattern2;
    }
}

