/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.AbstractBundleKt;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.IntelliJResourceBundle;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.ui.search.ConfigurableEntry;
import com.intellij.ide.ui.search.MySearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionEntry;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImplKt;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001a\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a4\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002\u001a\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0002\u001a$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(H\u0007\u001a\u0018\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INDEX_ENTRY_REGEXP", "Lkotlin/text/Regex;", "getINDEX_ENTRY_REGEXP", "()Lkotlin/text/Regex;", "LOCATION_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/ui/search/SearchableOptionsRegistrar$AdditionalLocationProvider;", "getMessageByCoordinate", "", "s", "classLoader", "Ljava/lang/ClassLoader;", "locale", "Ljava/util/Locale;", "forceLetters", "", "removeSubstringAndExtraSpaces", "substring", "findBundle", "Ljava/util/ResourceBundle;", "bundlePath", "processSearchableOptions", "", "processor", "Lcom/intellij/ide/ui/search/MySearchableOptionProcessor;", "doRegisterIndex", "item", "Lcom/intellij/ide/ui/search/ConfigurableEntry;", "localeSpecificLoader", "json", "Lkotlinx/serialization/json/Json;", "emptyIterator", "", "decodeFromJsonFormat", "Lkotlin/sequences/Sequence;", "data", "", "serializer", "Lkotlinx/serialization/KSerializer;", "readInXml", "root", "Lcom/intellij/util/xml/dom/XmlElement;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSearchableOptionIndexLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchableOptionIndexLoader.kt\ncom/intellij/ide/ui/search/SearchableOptionIndexLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,362:1\n60#2,5:363\n60#2,5:368\n60#2,5:375\n13#2:380\n1855#3,2:373\n*S KotlinDebug\n*F\n+ 1 SearchableOptionIndexLoader.kt\ncom/intellij/ide/ui/search/SearchableOptionIndexLoaderKt\n*L\n144#1:363,5\n180#1:368,5\n184#1:375,5\n38#1:380\n183#1:373,2\n*E\n"})
public final class SearchableOptionIndexLoaderKt {
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @NotNull
    private static final Regex INDEX_ENTRY_REGEXP;
    @NotNull
    private static final ExtensionPointName<SearchableOptionsRegistrar.AdditionalLocationProvider> LOCATION_EP_NAME;
    @NotNull
    private static final Json json;

    @NotNull
    public static final Regex getINDEX_ENTRY_REGEXP() {
        return INDEX_ENTRY_REGEXP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getMessageByCoordinate(String s, ClassLoader classLoader, Locale locale, boolean forceLetters) {
        Logger $this$debug_u24default$iv;
        String message;
        Object object;
        Logger logger2;
        Sequence matches = Regex.findAll$default((Regex)INDEX_ENTRY_REGEXP, (CharSequence)s, (int)0, (int)2, null);
        List result2 = null;
        String first = null;
        for (MatchResult match : matches) {
            String resolvedMessage;
            ResourceBundle bundle2;
            MatchGroupCollection groups = match.getGroups();
            MatchGroup matchGroup = groups.get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            if (SearchableOptionIndexLoaderKt.findBundle(classLoader, locale, matchGroup.getValue()) == null) continue;
            if (!(bundle2 instanceof IntelliJResourceBundle)) {
                Logger $this$debug_u24default$iv2 = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if (!$this$debug_u24default$iv2.isDebugEnabled()) continue;
                logger2 = $this$debug_u24default$iv2;
                boolean bl = false;
                logger2.debug("Unexpected bundle type due to fallback: " + bundle2.getClass().getName(), t$iv);
                continue;
            }
            MatchGroup matchGroup2 = groups.get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            String messageKey = matchGroup2.getValue();
            if (BundleBase.replaceMnemonicAmpersand((String)((IntelliJResourceBundle)bundle2).getMessageOrNull(messageKey)) == null) continue;
            if (first == null) {
                first = resolvedMessage;
                continue;
            }
            if (result2 == null) {
                result2 = new ArrayList();
                result2.add(first);
            }
            result2.add(resolvedMessage);
        }
        String parameterPlaceholder = "{0}";
        if (result2 == null) {
            object = first;
            if (object == null) {
                object = s;
            }
        } else if (result2.size() == 2 && StringsKt.contains$default((CharSequence)((CharSequence)result2.get(0)), (CharSequence)parameterPlaceholder, (boolean)false, (int)2, null)) {
            object = StringsKt.replace$default((String)((String)result2.get(0)), (String)parameterPlaceholder, (String)((String)result2.get(1)), (boolean)false, (int)4, null);
        } else if (!((Collection)result2).isEmpty() && StringsKt.contains$default((CharSequence)((CharSequence)CollectionsKt.last((List)result2)), (CharSequence)parameterPlaceholder, (boolean)false, (int)2, null)) {
            String lastResult = SearchableOptionIndexLoaderKt.removeSubstringAndExtraSpaces((String)CollectionsKt.last((List)result2), parameterPlaceholder);
            object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)result2, (int)1), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + lastResult;
        } else {
            object = CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        if (StringsKt.contains$default((CharSequence)(message = object), (CharSequence)parameterPlaceholder, (boolean)false, (int)2, null)) {
            $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if (!$this$debug_u24default$iv.isDebugEnabled()) return null;
            logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("Resolved message contains a placeholder: key=" + s + ", message=" + message, t$iv);
            return null;
        }
        if (forceLetters) {
            boolean bl;
            int $i$f$debug;
            block15: {
                CharSequence $this$none$iv = message;
                boolean $i$f$none = false;
                for ($i$f$debug = 0; $i$f$debug < $this$none$iv.length(); ++$i$f$debug) {
                    char element$iv;
                    char it = element$iv = $this$none$iv.charAt($i$f$debug);
                    boolean bl2 = false;
                    if (!Character.isLetter(it)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
            if (bl) {
                $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                $i$f$debug = 0;
                if (!$this$debug_u24default$iv.isDebugEnabled()) return null;
                logger2 = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger2.debug("Resolved message doesn't contain any letter: key=" + s + ", message=" + message, t$iv);
                return null;
            }
        }
        String string = message;
        return string;
    }

    static /* synthetic */ String getMessageByCoordinate$default(String string, ClassLoader classLoader, Locale locale, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return SearchableOptionIndexLoaderKt.getMessageByCoordinate(string, classLoader, locale, bl);
    }

    private static final String removeSubstringAndExtraSpaces(String $this$removeSubstringAndExtraSpaces, String substring) {
        String[] stringArray = new String[]{substring};
        return SequencesKt.joinToString$default((Sequence)StringsKt.splitToSequence$default((CharSequence)$this$removeSubstringAndExtraSpaces, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, SearchableOptionIndexLoaderKt::removeSubstringAndExtraSpaces$lambda$0, (int)30, null);
    }

    private static final ResourceBundle findBundle(ClassLoader classLoader, Locale locale, String bundlePath) {
        try {
            return AbstractBundleKt._doResolveBundle((ClassLoader)classLoader, (Locale)locale, (String)bundlePath);
        }
        catch (MissingResourceException missingResourceException) {
            if (classLoader instanceof PluginAwareClassLoader) {
                return null;
            }
            Set<ClassLoader> visited = Collections.newSetFromMap(new IdentityHashMap());
            visited.add(classLoader);
            for (LazyExtension extension : DynamicBundle.LanguageBundleEP.EP_NAME.filterableLazySequence()) {
                visited.add(extension.getPluginDescriptor().getClassLoader());
            }
            for (PluginModuleDescriptor descriptor2 : PluginManagerCore.getPluginSet().getEnabledModules()) {
                if (!visited.add(descriptor2.getClassLoader())) continue;
                try {
                    ClassLoader classLoader2 = descriptor2.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
                    ResourceBundle b = AbstractBundleKt._doResolveBundle((ClassLoader)classLoader2, (Locale)locale, (String)bundlePath);
                    return b;
                }
                catch (MissingResourceException missingResourceException2) {
                }
            }
            return null;
        }
    }

    private static final void processSearchableOptions(MySearchableOptionProcessor processor2) {
        Set<ClassLoader> xmlVisited = Collections.newSetFromMap(new IdentityHashMap());
        KSerializer<ConfigurableEntry> serializer2 = ConfigurableEntry.Companion.serializer();
        for (PluginModuleDescriptor module : PluginManagerCore.getPluginSet().getEnabledModules()) {
            ClassLoader classLoader = module.getPluginClassLoader();
            if (!(classLoader instanceof UrlClassLoader)) continue;
            String classifier = !(module instanceof ContentModuleDescriptor) ? "p-" + module.getPluginId().getIdString() : "m-" + ((ContentModuleDescriptor)module).moduleId.getName();
            String fileName = classifier + "-searchableOptions.json";
            byte[] data2 = ((UrlClassLoader)classLoader).getResourceAsBytes(fileName, false);
            if (data2 != null) {
                Locale locale = LocalizationUtil.INSTANCE.getLocaleOrNullForDefault();
                ClassLoader localeSpecificLoader = LocalizationUtil.getPluginClassLoader$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, null, (int)3, null);
                try {
                    for (ConfigurableEntry item : SearchableOptionIndexLoaderKt.decodeFromJsonFormat(data2, serializer2)) {
                        SearchableOptionIndexLoaderKt.doRegisterIndex(item, classLoader, locale, processor2, localeSpecificLoader);
                    }
                    continue;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Can't parse searchable options " + fileName + " for plugin " + module.getPluginId(), e);
                }
            }
            if (!xmlVisited.add(classLoader)) continue;
            String xmlName = "searchableOptions.xml";
            ((UrlClassLoader)classLoader).processResources("search", arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$0(xmlName, arg_0), (arg_0, arg_1) -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$2((arg_0, arg_1) -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$1(processor2, fileName, module, arg_0, arg_1), arg_0, arg_1));
        }
        String xmlName = "searchableOptions.xml";
        LOCATION_EP_NAME.forEachExtensionSafe(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$4(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3(xmlName, processor2, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void doRegisterIndex(ConfigurableEntry item, ClassLoader classLoader, Locale locale, MySearchableOptionProcessor processor2, ClassLoader localeSpecificLoader) {
        Locale locale2;
        Locale locale3;
        String string = item.name;
        ClassLoader classLoader2 = localeSpecificLoader;
        if (classLoader2 == null) {
            classLoader2 = classLoader;
        }
        if ((locale3 = locale) == null) {
            locale3 = Locale.ROOT;
        }
        Locale locale4 = locale3;
        Intrinsics.checkNotNull((Object)locale4);
        String string2 = SearchableOptionIndexLoaderKt.getMessageByCoordinate$default(string, classLoader2, locale4, false, 8, null);
        if (string2 == null) {
            return;
        }
        String groupName = string2;
        String string3 = item.id;
        ClassLoader classLoader3 = localeSpecificLoader;
        if (classLoader3 == null) {
            classLoader3 = classLoader;
        }
        if ((locale2 = locale) == null) {
            locale2 = Locale.ROOT;
        }
        Locale locale5 = locale2;
        Intrinsics.checkNotNull((Object)locale5);
        String string4 = SearchableOptionIndexLoaderKt.getMessageByCoordinate$default(string3, classLoader3, locale5, false, 8, null);
        if (string4 == null) {
            return;
        }
        String id2 = string4;
        for (SearchableOptionEntry entry : item.entries) {
            String string5;
            String hit;
            Locale locale6;
            String string6 = entry.hit;
            ClassLoader classLoader4 = localeSpecificLoader;
            if (classLoader4 == null) {
                classLoader4 = classLoader;
            }
            if ((locale6 = locale) == null) {
                locale6 = Locale.ROOT;
            }
            Locale locale7 = locale6;
            Intrinsics.checkNotNull((Object)locale7);
            if (SearchableOptionIndexLoaderKt.getMessageByCoordinate$default(string6, classLoader4, locale7, false, 8, null) == null) continue;
            MySearchableOptionProcessor mySearchableOptionProcessor = processor2;
            Iterable iterable = new Iterable<String>(entry, classLoader, locale, localeSpecificLoader){
                final /* synthetic */ SearchableOptionEntry $entry$inlined;
                final /* synthetic */ ClassLoader $classLoader$inlined;
                final /* synthetic */ Locale $locale$inlined;
                final /* synthetic */ ClassLoader $localeSpecificLoader$inlined;
                {
                    this.$entry$inlined = searchableOptionEntry;
                    this.$classLoader$inlined = classLoader;
                    this.$locale$inlined = locale;
                    this.$localeSpecificLoader$inlined = classLoader2;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public Iterator<String> iterator() {
                    Iterator<T> iterator2;
                    Iterator<T> iterator3;
                    block7: {
                        String string;
                        Stream<String> s1;
                        block9: {
                            block8: {
                                block6: {
                                    String string2;
                                    block5: {
                                        block4: {
                                            boolean bl = false;
                                            String string3 = this.$entry$inlined.hit;
                                            Locale locale = Locale.ROOT;
                                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                                            string2 = SearchableOptionIndexLoaderKt.getMessageByCoordinate$default(string3, this.$classLoader$inlined, locale, false, 8, null);
                                            if (string2 == null) break block4;
                                            String string4 = string2;
                                            Locale locale2 = Locale.ROOT;
                                            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                                            String string5 = string4.toLowerCase(locale2);
                                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                                            string2 = string5;
                                            if (string5 != null) break block5;
                                        }
                                        iterator3 = SearchableOptionIndexLoaderKt.access$emptyIterator();
                                        return iterator3;
                                    }
                                    String h1 = string2;
                                    s1 = SearchableOptionsRegistrarImplKt.splitToWordsWithoutStemmingAndStopWords(h1);
                                    if (this.$locale$inlined != null) break block6;
                                    iterator2 = s1.iterator();
                                    break block7;
                                }
                                String string6 = this.$entry$inlined.hit;
                                ClassLoader classLoader = this.$localeSpecificLoader$inlined;
                                Intrinsics.checkNotNull((Object)classLoader);
                                string = SearchableOptionIndexLoaderKt.getMessageByCoordinate$default(string6, classLoader, this.$locale$inlined, false, 8, null);
                                if (string == null) break block8;
                                String string7 = string.toLowerCase(this.$locale$inlined);
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                                string = string7;
                                if (string7 != null) break block9;
                            }
                            iterator3 = SearchableOptionIndexLoaderKt.access$emptyIterator();
                            return iterator3;
                        }
                        String h2 = string;
                        Stream<String> s2 = SearchableOptionsRegistrarImplKt.splitToWordsWithoutStemmingAndStopWords(h2);
                        iterator2 = Stream.concat(s2, s1).iterator();
                    }
                    Iterator<T> iterator4 = iterator2;
                    Intrinsics.checkNotNull(iterator4);
                    iterator3 = iterator4;
                    return iterator3;
                }
            };
            String string7 = id2;
            String string8 = groupName;
            String string9 = hit;
            if (entry.path != null) {
                void it;
                Locale locale8;
                String string10 = string9;
                String string11 = string8;
                String string12 = string7;
                Iterable iterable2 = iterable;
                MySearchableOptionProcessor mySearchableOptionProcessor2 = mySearchableOptionProcessor;
                boolean bl = false;
                ClassLoader classLoader5 = localeSpecificLoader;
                if (classLoader5 == null) {
                    classLoader5 = classLoader;
                }
                if ((locale8 = locale) == null) {
                    locale8 = Locale.ROOT;
                }
                Locale locale9 = locale8;
                Intrinsics.checkNotNull((Object)locale9);
                String string13 = SearchableOptionIndexLoaderKt.getMessageByCoordinate$default((String)it, classLoader5, locale9, false, 8, null);
                mySearchableOptionProcessor = mySearchableOptionProcessor2;
                iterable = iterable2;
                string7 = string12;
                string8 = string11;
                string9 = string10;
                string5 = string13;
            } else {
                string5 = null;
            }
            mySearchableOptionProcessor.putOptionWithHelpId$intellij_platform_ide_impl(iterable, string7, string8, string9, string5);
        }
    }

    private static final Iterator<String> emptyIterator() {
        return SequencesKt.emptySequence().iterator();
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final Sequence<ConfigurableEntry> decodeFromJsonFormat(@NotNull byte[] data2, @NotNull KSerializer<ConfigurableEntry> serializer2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        return JvmStreamsKt.decodeToSequence((Json)json, (InputStream)new ByteArrayInputStream(data2), (DeserializationStrategy)((DeserializationStrategy)serializer2), (DecodeSequenceMode)DecodeSequenceMode.WHITESPACE_SEPARATED);
    }

    private static final void readInXml(XmlElement root, MySearchableOptionProcessor processor2) {
        for (XmlElement configurable : root.children("configurable")) {
            if (configurable.getAttributeValue("id") == null || configurable.getAttributeValue("configurable_name") == null) continue;
            for (XmlElement optionElement : configurable.children("option")) {
                String text2;
                String name2;
                String id2;
                if (optionElement.getAttributeValue("hit") == null) continue;
                processor2.putOptionWithHelpId$intellij_platform_ide_impl(CollectionsKt.listOfNotNull((Object)optionElement.getAttributeValue("name")), id2, name2, text2, optionElement.getAttributeValue("path"));
            }
        }
    }

    private static final CharSequence removeSubstringAndExtraSpaces$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean processSearchableOptions$lambda$0(String $xmlName, String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.endsWith$default((String)it, (String)$xmlName, (boolean)false, (int)2, null);
    }

    private static final Unit processSearchableOptions$lambda$1(MySearchableOptionProcessor $processor, String $fileName, PluginModuleDescriptor $module, String string, InputStream stream) {
        try {
            Intrinsics.checkNotNull((Object)stream);
            SearchableOptionIndexLoaderKt.readInXml(XmlDomReader.readXmlAsModel((InputStream)stream), $processor);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't parse searchable options " + $fileName + " for plugin " + $module.getPluginId(), e);
        }
        return Unit.INSTANCE;
    }

    private static final void processSearchableOptions$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processSearchableOptions$lambda$3(String $xmlName, MySearchableOptionProcessor $processor, SearchableOptionsRegistrar.AdditionalLocationProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Path path = provider.getAdditionalLocation();
        if (path == null) {
            return Unit.INSTANCE;
        }
        Path additionalLocation = path;
        if (Files.isDirectory(additionalLocation, new LinkOption[0])) {
            AutoCloseable autoCloseable = Files.list(additionalLocation);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.forEach(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3$0$1(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3$0$0($xmlName, $processor, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit processSearchableOptions$lambda$3$0$0(String $xmlName, MySearchableOptionProcessor $processor, Path file2) {
        String fileName = ((Object)file2.getFileName()).toString();
        try {
            if (StringsKt.endsWith$default((String)fileName, (String)$xmlName, (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)file2);
                SearchableOptionIndexLoaderKt.readInXml(XmlDomReader.readXmlAsModel((Path)file2), $processor);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't parse searchable options " + $xmlName, e);
        }
        return Unit.INSTANCE;
    }

    private static final void processSearchableOptions$lambda$3$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void processSearchableOptions$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$processSearchableOptions(MySearchableOptionProcessor processor2) {
        SearchableOptionIndexLoaderKt.processSearchableOptions(processor2);
    }

    public static final /* synthetic */ Iterator access$emptyIterator() {
        return SearchableOptionIndexLoaderKt.emptyIterator();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(MySearchableOptionProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        INDEX_ENTRY_REGEXP = new Regex("\\|b\\|([^|]+)\\|k\\|([^|]+)\\|");
        LOCATION_EP_NAME = new ExtensionPointName("com.intellij.search.additionalOptionsLocation");
        json = JsonKt.Json$default(null, SearchableOptionIndexLoaderKt::json$lambda$0, (int)1, null);
    }
}

