/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text.paragraph;

import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.ui.scale.JBUIScale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u0011\u001a\u00020\u00002\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u0015J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0014J\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "", "textParts", "", "Lcom/intellij/ide/ui/text/parts/TextPart;", "<init>", "(Ljava/util/List;)V", "getTextParts", "()Ljava/util/List;", "unscaledAttributes", "Ljavax/swing/text/SimpleAttributeSet;", "attributes", "getAttributes", "()Ljavax/swing/text/SimpleAttributeSet;", "partRanges", "", "Lkotlin/ranges/IntRange;", "editAttributes", "edit", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "insertToDocument", "", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "isLast", "", "insertTextPart", "textPart", "findPartByOffset", "Lkotlin/Pair;", "offset", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTextParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextParagraph.kt\ncom/intellij/ide/ui/text/paragraph/TextParagraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n360#2,7:86\n*S KotlinDebug\n*F\n+ 1 TextParagraph.kt\ncom/intellij/ide/ui/text/paragraph/TextParagraph\n*L\n72#1:86,7\n*E\n"})
public class TextParagraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TextPart> textParts;
    @NotNull
    private final SimpleAttributeSet unscaledAttributes;
    @NotNull
    private final List<IntRange> partRanges;
    public static final float NO_INDENT = 0.0f;
    public static final float SMALL_INDENT = 4.0f;
    public static final float MEDIUM_INDENT = 8.0f;
    public static final float BIG_INDENT = 12.0f;

    /*
     * WARNING - void declaration
     */
    public TextParagraph(@NotNull List<? extends TextPart> textParts) {
        void $this$unscaledAttributes_u24lambda_u240;
        SimpleAttributeSet simpleAttributeSet;
        Intrinsics.checkNotNullParameter(textParts, (String)"textParts");
        this.textParts = textParts;
        SimpleAttributeSet simpleAttributeSet2 = simpleAttributeSet = new SimpleAttributeSet();
        TextParagraph textParagraph = this;
        boolean bl = false;
        StyleConstants.setRightIndent((MutableAttributeSet)$this$unscaledAttributes_u24lambda_u240, 0.0f);
        StyleConstants.setLeftIndent((MutableAttributeSet)$this$unscaledAttributes_u24lambda_u240, 0.0f);
        StyleConstants.setSpaceAbove((MutableAttributeSet)$this$unscaledAttributes_u24lambda_u240, 8.0f);
        StyleConstants.setSpaceBelow((MutableAttributeSet)$this$unscaledAttributes_u24lambda_u240, 0.0f);
        StyleConstants.setLineSpacing((MutableAttributeSet)$this$unscaledAttributes_u24lambda_u240, 0.3f);
        textParagraph.unscaledAttributes = simpleAttributeSet;
        this.partRanges = new ArrayList();
    }

    @NotNull
    public final List<TextPart> getTextParts() {
        return this.textParts;
    }

    @NotNull
    public SimpleAttributeSet getAttributes() {
        SimpleAttributeSet simpleAttributeSet;
        SimpleAttributeSet $this$_get_attributes__u24lambda_u240 = simpleAttributeSet = new SimpleAttributeSet();
        boolean bl = false;
        SimpleAttributeSet unscaled = this.unscaledAttributes;
        StyleConstants.setRightIndent($this$_get_attributes__u24lambda_u240, JBUIScale.scale((float)StyleConstants.getRightIndent(unscaled)));
        StyleConstants.setLeftIndent($this$_get_attributes__u24lambda_u240, JBUIScale.scale((float)StyleConstants.getLeftIndent(unscaled)));
        StyleConstants.setSpaceAbove($this$_get_attributes__u24lambda_u240, JBUIScale.scale((float)StyleConstants.getSpaceAbove(unscaled)));
        StyleConstants.setSpaceBelow($this$_get_attributes__u24lambda_u240, JBUIScale.scale((float)StyleConstants.getSpaceBelow(unscaled)));
        StyleConstants.setLineSpacing($this$_get_attributes__u24lambda_u240, StyleConstants.getLineSpacing(unscaled));
        return simpleAttributeSet;
    }

    @NotNull
    public final TextParagraph editAttributes(@NotNull Function1<? super SimpleAttributeSet, Unit> edit) {
        Intrinsics.checkNotNullParameter(edit, (String)"edit");
        edit.invoke((Object)this.unscaledAttributes);
        return this;
    }

    public int insertToDocument(@NotNull JTextPane textPane, int startOffset, boolean isLast) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        this.partRanges.clear();
        int curOffset = startOffset;
        for (TextPart part : this.textParts) {
            int start2 = curOffset;
            curOffset = this.insertTextPart(part, textPane, curOffset);
            this.partRanges.add(RangesKt.until((int)start2, (int)curOffset));
        }
        SimpleAttributeSet curAttributes = this.getAttributes();
        if (!isLast) {
            textPane.getDocument().insertString(curOffset, "\n", curAttributes);
            ++curOffset;
        }
        textPane.getStyledDocument().setParagraphAttributes(startOffset, curOffset - startOffset, curAttributes, true);
        return curOffset;
    }

    public static /* synthetic */ int insertToDocument$default(TextParagraph textParagraph, JTextPane jTextPane, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: insertToDocument");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return textParagraph.insertToDocument(jTextPane, n, bl);
    }

    protected int insertTextPart(@NotNull TextPart textPart, @NotNull JTextPane textPane, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)textPart, (String)"textPart");
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        return textPart.insertToTextPane(textPane, startOffset);
    }

    @Nullable
    public Pair<TextPart, IntRange> findPartByOffset(int offset) {
        int n;
        block2: {
            List<IntRange> $this$indexOfFirst$iv = this.partRanges;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<IntRange> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                IntRange item$iv;
                IntRange it = item$iv = iterator2.next();
                boolean bl = false;
                int n2 = it.getFirst();
                boolean bl2 = offset <= it.getLast() ? n2 <= offset : false;
                if (bl2) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int partInd = n;
        return partInd != -1 ? TuplesKt.to((Object)this.textParts.get(partInd), (Object)this.partRanges.get(partInd)) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/ui/text/paragraph/TextParagraph$Companion;", "", "<init>", "()V", "NO_INDENT", "", "SMALL_INDENT", "MEDIUM_INDENT", "BIG_INDENT", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

