/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ToolWindowEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAllowlistEP;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ToolWindowCollector {
    private static final ExtensionPointName<ToolWindowAllowlistEP> EP_NAME = new ExtensionPointName("com.intellij.toolWindowAllowlist");
    private static final Map<String, PluginInfo> toolwindowAllowList = new HashMap<String, PluginInfo>();

    public static ToolWindowCollector getInstance() {
        return Holder.INSTANCE;
    }

    private ToolWindowCollector() {
        EP_NAME.processWithPluginDescriptor((extension, pluginDescriptor) -> {
            ToolWindowCollector.addToolwindowToWhitelist(extension, pluginDescriptor);
            return Unit.INSTANCE;
        });
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ToolWindowAllowlistEP>(this){

            public void extensionAdded(@NotNull ToolWindowAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ToolWindowCollector.addToolwindowToWhitelist(extension, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static void addToolwindowToWhitelist(@NotNull ToolWindowAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
        PluginInfo info;
        if (extension == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        if ((info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor)).isDevelopedByJetBrains()) {
            toolwindowAllowList.put(extension.id, info);
        }
    }

    public void recordResized(@NotNull Project project2, @NotNull WindowInfoImpl info, @NotNull Boolean isMaximized) {
        if (project2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(2);
        }
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        if (isMaximized == null) {
            ToolWindowCollector.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)info.getId())) {
            return;
        }
        ToolWindowEventLogGroup.RESIZED.log(project2, data2 -> {
            ToolWindowCollector.addDefaultFields(info.getId(), info, null, data2);
            data2.add(ToolWindowEventLogGroup.WEIGHT.with((Object)Float.valueOf(info.getWeight())));
            data2.add(ToolWindowEventLogGroup.IS_MAXIMIZED.with((Object)isMaximized));
        });
    }

    public void recordActivation(@NotNull Project project2, @Nullable String toolWindowId, @Nullable WindowInfoImpl info, @Nullable ToolWindowEventSource source) {
        if (project2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(5);
        }
        ToolWindowCollector.record(project2, toolWindowId, ToolWindowEventLogGroup.ACTIVATED, info, source);
    }

    public void recordHidden(@NotNull Project project2, @NotNull WindowInfoImpl info, @Nullable ToolWindowEventSource source) {
        if (project2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(6);
        }
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(7);
        }
        ToolWindowCollector.record(project2, info.getId(), ToolWindowEventLogGroup.HIDDEN, info, source);
    }

    public void recordShown(@NotNull Project project2, @Nullable ToolWindowEventSource source, @NotNull WindowInfoImpl info) {
        if (project2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(8);
        }
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(9);
        }
        ToolWindowCollector.record(project2, info.getId(), ToolWindowEventLogGroup.SHOWN, info, source);
    }

    private static void record(@NotNull Project project2, @Nullable String toolWindowId, @NotNull VarargEventId event, @Nullable WindowInfoImpl windowInfo, @Nullable ToolWindowEventSource source) {
        if (project2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(10);
        }
        if (event == null) {
            ToolWindowCollector.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)toolWindowId)) {
            return;
        }
        event.log(project2, data2 -> ToolWindowCollector.addDefaultFields(toolWindowId, windowInfo, source, data2));
    }

    private static void addDefaultFields(@NotNull String toolWindowId, @Nullable WindowInfoImpl windowInfo, @Nullable ToolWindowEventSource source, List<EventPair<?>> data2) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(12);
        }
        PluginInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId);
        data2.add(ToolWindowEventLogGroup.TOOLWINDOW_ID.with((Object)toolWindowId));
        data2.add(EventFields.PluginInfo.with((Object)info));
        if (windowInfo != null) {
            data2.add(ToolWindowEventLogGroup.VIEW_MODE.with((Object)ToolWindowViewModeAction.ViewMode.fromWindowInfo(windowInfo)));
            data2.add(ToolWindowEventLogGroup.LOCATION.with((Object)ToolWindowMoveAction.Anchor.fromWindowInfo(windowInfo)));
        }
        if (source != null) {
            data2.add(ToolWindowEventLogGroup.SOURCE.with((Object)source));
        }
    }

    @NotNull
    private static PluginInfo getToolWindowInfo(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(13);
        }
        if (toolwindowAllowList.containsKey(toolWindowId)) {
            PluginInfo pluginInfo = toolwindowAllowList.get(toolWindowId);
            if (pluginInfo == null) {
                ToolWindowCollector.$$$reportNull$$$0(14);
            }
            return pluginInfo;
        }
        PluginInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId, ToolWindowEP.EP_NAME.getExtensionList());
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList());
        }
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList());
        }
        PluginInfo pluginInfo = info != null ? info : PluginInfoDetectorKt.getUnknownPlugin();
        if (pluginInfo == null) {
            ToolWindowCollector.$$$reportNull$$$0(15);
        }
        return pluginInfo;
    }

    @Nullable
    private static PluginInfo getToolWindowInfo(@NotNull String toolWindowId, @NotNull List<? extends ToolWindowEP> toolWindows) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(16);
        }
        if (toolWindows == null) {
            ToolWindowCollector.$$$reportNull$$$0(17);
        }
        for (ToolWindowEP toolWindowEP : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)toolWindowEP.id)) continue;
            PluginDescriptor pluginDescriptor = toolWindowEP.getPluginDescriptor();
            return PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        }
        return null;
    }

    static {
        for (String id2 : List.of("Messages", "Debug", "Run", "Find", "Hierarchy", "Dependency Viewer", "Module Dependencies", "Duplicates", "Extract Method", "Documentation", "Preview", "Services", "Endpoints", "Build", "CVS", "Dependencies")) {
            toolwindowAllowList.put(id2, PluginInfoDetectorKt.getPlatformPlugin());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMaximized";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToolwindowToWhitelist";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordResized";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recordActivation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recordHidden";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recordShown";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultFields";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInfo";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        private static final ToolWindowCollector INSTANCE = new ToolWindowCollector();

        private Holder() {
        }
    }

    public static final class ToolWindowUtilValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "toolwindow";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(1);
            }
            if ("unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            if (ToolWindowUtilValidator.hasPluginField((EventContext)context2)) {
                ValidationResultType validationResultType = ToolWindowUtilValidator.acceptWhenReportedByJetBrainsPlugin((EventContext)context2);
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            PluginInfo info = ToolWindowCollector.getToolWindowInfo(data2);
            ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

