/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.ui.ComponentEventHandler;
import com.intellij.notification.impl.ui.NotificationComponent;
import com.intellij.notification.impl.ui.NotificationGroupComponent;
import com.intellij.notification.impl.ui.NotificationsPanel;
import com.intellij.notification.impl.ui.NotificationsPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.Clock;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.Side;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Alarm;
import com.intellij.util.UtilBundle;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SingleTextSelectionHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004*\u0001\u0010\b\u0002\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001;B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u0016\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001bH\u0002J\u0006\u0010%\u001a\u00020\u0006J\u0014\u0010&\u001a\u00020\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u000e\u0010(\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001eJ\u0014\u0010)\u001a\u00020\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0006\u0010*\u001a\u00020\u001bJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0,J\u0006\u0010-\u001a\u00020\u001bJ\u0006\u0010.\u001a\u00020\u001bJ \u0010/\u001a\u00020\u001b2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001b01H\u0086\b\u00f8\u0001\u0000J\b\u00103\u001a\u00020\u001bH\u0002J\u0015\u00104\u001a\u000705\u00a2\u0006\u0002\b62\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lcom/intellij/notification/impl/ui/NotificationGroupComponent;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/ui/NullableComponent;", "myMainContent", "Lcom/intellij/notification/impl/ui/NotificationsPanel;", "mySuggestionType", "", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/notification/impl/ui/NotificationsPanel;ZLcom/intellij/openapi/project/Project;)V", "myTitle", "Lcom/intellij/ui/components/JBLabel;", "myList", "Ljavax/swing/JPanel;", "myScrollPane", "com/intellij/notification/impl/ui/NotificationGroupComponent$myScrollPane$1", "Lcom/intellij/notification/impl/ui/NotificationGroupComponent$myScrollPane$1;", "myEventHandler", "Lcom/intellij/notification/impl/ui/ComponentEventHandler;", "myTimeComponents", "Ljava/util/ArrayList;", "Ljavax/swing/JLabel;", "myTimeAlarm", "Lcom/intellij/util/Alarm;", "myClearCallback", "Lkotlin/Function0;", "", "myRemoveCallback", "Ljava/util/function/Consumer;", "Lcom/intellij/notification/Notification;", "updateLaf", "add", "notification", "singleSelectionHandler", "Lcom/intellij/util/ui/SingleTextSelectionHandler;", "updateLayout", "isEmpty", "setRemoveCallback", "callback", "remove", "setClearCallback", "expireAll", "clear", "", "clearNewState", "updateComponents", "iterateComponents", "f", "Lkotlin/Function1;", "Lcom/intellij/notification/impl/ui/NotificationComponent;", "updateContent", "formatPrettyDateTime", "", "Lcom/intellij/openapi/util/NlsSafe;", "time", "", "isVisible", "isNull", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nNotificationsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/NotificationGroupComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1514:1\n673#1,5:1515\n673#1,5:1520\n673#1,5:1525\n673#1,5:1530\n673#1,5:1535\n1869#2,2:1540\n1#3:1542\n*S KotlinDebug\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/NotificationGroupComponent\n*L\n560#1:1515,5\n585#1:1520,5\n632#1:1525,5\n643#1:1530,5\n656#1:1535,5\n662#1:1540,2\n*E\n"})
final class NotificationGroupComponent
extends JBPanel<NotificationGroupComponent>
implements NullableComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationsPanel myMainContent;
    private final boolean mySuggestionType;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JBLabel myTitle;
    @NotNull
    private final JPanel myList;
    @NotNull
    private final myScrollPane.1 myScrollPane;
    @NotNull
    private final ComponentEventHandler myEventHandler;
    @NotNull
    private final ArrayList<JLabel> myTimeComponents;
    @NotNull
    private final Alarm myTimeAlarm;
    private Function0<Unit> myClearCallback;
    private Consumer<Notification> myRemoveCallback;

    public NotificationGroupComponent(@NotNull NotificationsPanel myMainContent, boolean mySuggestionType, @NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myMainContent, (String)"myMainContent");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        super((LayoutManager)new BorderLayout());
        this.myMainContent = myMainContent;
        this.mySuggestionType = mySuggestionType;
        this.myProject = myProject;
        this.myTitle = new JBLabel(IdeBundle.message((String)(this.mySuggestionType ? "notifications.toolwindow.suggestions" : "notifications.toolwindow.timeline"), (Object[])new Object[0]));
        JPanel jPanel = this.myList = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)10)));
        this.myScrollPane = new JBScrollPane(jPanel){

            protected void setupCorners() {
                super.setupCorners();
                this.setBorder(null);
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(null);
            }
        };
        this.myEventHandler = new ComponentEventHandler();
        this.myTimeComponents = new ArrayList();
        this.myTimeAlarm = new Alarm((Disposable)this.myProject);
        this.setBackground(NotificationComponent.Companion.getBG_COLOR());
        JPanel mainPanel = new JPanel(new BorderLayout(0, JBUI.scale((int)8)));
        mainPanel.setOpaque(false);
        mainPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.add(mainPanel);
        NotificationsPanelKt.access$mediumFontFunction((JComponent)this.myTitle);
        this.myTitle.setForeground((Color)NotificationComponent.Companion.getINFO_COLOR());
        if (this.mySuggestionType) {
            this.myTitle.setBorder((Border)JBUI.Borders.emptyLeft((int)18));
            mainPanel.add((Component)this.myTitle, "North");
        } else {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)18));
            panel2.add((Component)this.myTitle, "West");
            LinkLabel clearAll = new LinkLabel(IdeBundle.message((String)"notifications.toolwindow.timeline.clear.all", (Object[])new Object[0]), null, (arg_0, arg_1) -> NotificationGroupComponent._init_$lambda$0(this, arg_0, arg_1));
            NotificationsPanelKt.access$mediumFontFunction((JComponent)clearAll);
            clearAll.setBorder((Border)JBUI.Borders.emptyRight((int)20));
            panel2.add((Component)clearAll, "East");
            mainPanel.add((Component)panel2, "North");
        }
        this.myList.setOpaque(true);
        this.myList.setBackground(NotificationComponent.Companion.getBG_COLOR());
        this.myList.setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)0, (int)10));
        ScrollableContentBorder.Companion.setup$default((ScrollableContentBorder.Companion)ScrollableContentBorder.Companion, (JScrollPane)((JScrollPane)((Object)this.myScrollPane)), (Side)Side.TOP, null, (int)4, null);
        mainPanel.add((Component)((Object)this.myScrollPane));
        this.myEventHandler.add((Component)((Object)this));
    }

    public final void updateLaf() {
        this.updateComponents();
        NotificationGroupComponent this_$iv = this;
        boolean $i$f$iterateComponents = false;
        int count$iv = this_$iv.myList.getComponentCount();
        for (int i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = this_$iv.myList.getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            NotificationComponent it = (NotificationComponent)((Object)component2);
            boolean bl = false;
            it.updateLaf();
        }
    }

    public final void add(@NotNull Notification notification2, @NotNull SingleTextSelectionHandler singleSelectionHandler) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)singleSelectionHandler, (String)"singleSelectionHandler");
        NotificationComponent component2 = new NotificationComponent(this.myProject, notification2, this.myTimeComponents, singleSelectionHandler);
        component2.setNew(true);
        this.myList.add((Component)((Object)component2), 0);
        this.updateLayout();
        this.myEventHandler.add((Component)((Object)component2));
        this.updateContent();
        component2.setDoNotAskHandler((Function1<? super Boolean, Unit>)((Function1)arg_0 -> NotificationGroupComponent.add$lambda$0(component2, this, arg_0)));
        Consumer<Notification> consumer = this.myRemoveCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myRemoveCallback");
            consumer = null;
        }
        component2.setRemoveCallback(consumer);
    }

    private final void updateLayout() {
        LayoutManager layout2 = this.myList.getLayout();
        NotificationGroupComponent this_$iv = this;
        boolean $i$f$iterateComponents = false;
        int count$iv = this_$iv.myList.getComponentCount();
        for (int i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = this_$iv.myList.getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            NotificationComponent component3 = (NotificationComponent)((Object)component2);
            boolean bl = false;
            layout2.removeLayoutComponent((Component)((Object)component3));
            layout2.addLayoutComponent(null, (Component)((Object)component3));
        }
    }

    public final boolean isEmpty() {
        int count = this.myList.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            if (!(this.myList.getComponent(i2) instanceof NotificationComponent)) continue;
            return false;
        }
        return true;
    }

    public final void setRemoveCallback(@NotNull Consumer<Notification> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.myRemoveCallback = callback;
    }

    public final void remove(@NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        int count = this.myList.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = this.myList.getComponent(i2);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            NotificationComponent component3 = (NotificationComponent)((Object)component2);
            if (component3.getMyNotificationWrapper().getNotification() != notification2) continue;
            if (notification2.isSuggestionType() || notification2.isRemoveWhenExpired()) {
                component3.removeFromParent();
                this.myList.remove(i2);
                break;
            }
            component3.expire();
            break;
        }
        this.updateContent();
    }

    public final void setClearCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.myClearCallback = callback;
    }

    public final void expireAll() {
        if (this.mySuggestionType) {
            this.clear();
        } else {
            NotificationGroupComponent this_$iv = this;
            boolean $i$f$iterateComponents = false;
            int count$iv = this_$iv.myList.getComponentCount();
            for (int i$iv = 0; i$iv < count$iv; ++i$iv) {
                Component component2 = this_$iv.myList.getComponent(i$iv);
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
                NotificationComponent it = (NotificationComponent)((Object)component2);
                boolean bl = false;
                if (it.getMyNotificationWrapper().getNotification() == null) continue;
                it.expire();
            }
            this.updateContent();
        }
    }

    @NotNull
    public final List<Notification> clear() {
        List notifications = new ArrayList();
        NotificationGroupComponent this_$iv = this;
        boolean $i$f$iterateComponents = false;
        int count$iv = this_$iv.myList.getComponentCount();
        for (int i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = this_$iv.myList.getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            NotificationComponent it = (NotificationComponent)((Object)component2);
            boolean bl = false;
            Notification notification2 = it.getMyNotificationWrapper().getNotification();
            if (notification2 != null) {
                notifications.add(notification2);
            }
            it.removeFromParent();
        }
        this.myList.removeAll();
        this.updateContent();
        return CollectionsKt.toList((Iterable)notifications);
    }

    public final void clearNewState() {
        NotificationGroupComponent this_$iv = this;
        boolean $i$f$iterateComponents = false;
        int count$iv = this_$iv.myList.getComponentCount();
        for (int i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = this_$iv.myList.getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            NotificationComponent it = (NotificationComponent)((Object)component2);
            boolean bl = false;
            it.setNew(false);
        }
    }

    public final void updateComponents() {
        JBIterable jBIterable = UIUtil.uiTraverser((Component)((Component)((Object)this))).filter(JComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl = false;
            Object value = it.getClientProperty("FontFunction");
            if (value == null) continue;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)value, (int)1);
            Intrinsics.checkNotNull((Object)it);
            function1.invoke((Object)it);
        }
        this.myMainContent.fullRepaint();
    }

    public final void iterateComponents(@NotNull Function1<? super NotificationComponent, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$iterateComponents = false;
        int count = this.myList.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = this.myList.getComponent(i2);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            f.invoke((Object)((NotificationComponent)((Object)component2)));
        }
    }

    private final void updateContent() {
        if (!this.mySuggestionType && !this.myTimeAlarm.isDisposed()) {
            this.myTimeAlarm.cancelAllRequests();
            new Runnable(this){
                final /* synthetic */ NotificationGroupComponent this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    Iterator<E> iterator2 = NotificationGroupComponent.access$getMyTimeComponents$p(this.this$0).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator<E> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        E e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        JLabel timeComponent = (JLabel)e;
                        Object object = timeComponent.getClientProperty("TimestampKey");
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                        timeComponent.setText(NotificationGroupComponent.access$formatPrettyDateTime(this.this$0, (Long)object));
                    }
                    if (!((Collection)NotificationGroupComponent.access$getMyTimeComponents$p(this.this$0)).isEmpty() && !NotificationGroupComponent.access$getMyTimeAlarm$p(this.this$0).isDisposed()) {
                        NotificationGroupComponent.access$getMyTimeAlarm$p(this.this$0).addRequest((Runnable)this, 30000);
                    }
                }
            }.run();
        }
        this.myMainContent.fullRepaint();
    }

    private final String formatPrettyDateTime(long time) {
        boolean isYesterday;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Clock.getTime());
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (currentYear == year && currentDayOfYear == dayOfYear) {
            String string = DateFormatUtil.formatTime((long)time);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatTime(...)");
            return string;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            return UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]);
        }
        String string = DateFormatUtil.formatDate((long)time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDate(...)");
        return string;
    }

    public boolean isVisible() {
        if (super.isVisible()) {
            int count = this.myList.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                if (!this.myList.getComponent(i2).isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNull() {
        return !this.isVisible();
    }

    private static final void _init_$lambda$0(NotificationGroupComponent this$0, LinkLabel linkLabel, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)linkLabel, (String)"<unused var>");
        Function0<Unit> function0 = this$0.myClearCallback;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myClearCallback");
            function0 = null;
        }
        function0.invoke();
    }

    private static final Unit add$lambda$0(NotificationComponent $component, NotificationGroupComponent this$0, boolean forProject) {
        Notification notification2;
        Notification notification3 = $component.getMyNotificationWrapper().getNotification();
        Intrinsics.checkNotNull((Object)notification3);
        Notification it = notification2 = notification3.setDoNotAskFor(forProject ? this$0.myProject : null);
        boolean bl = false;
        Consumer<Notification> consumer = this$0.myRemoveCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myRemoveCallback");
            consumer = null;
        }
        consumer.accept(it);
        notification2.hideBalloon();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ArrayList access$getMyTimeComponents$p(NotificationGroupComponent $this) {
        return $this.myTimeComponents;
    }

    public static final /* synthetic */ String access$formatPrettyDateTime(NotificationGroupComponent $this, long time) {
        return $this.formatPrettyDateTime(time);
    }

    public static final /* synthetic */ Alarm access$getMyTimeAlarm$p(NotificationGroupComponent $this) {
        return $this.myTimeAlarm;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/notification/impl/ui/NotificationGroupComponent$Companion;", "", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

