/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="AbbreviationManager", storages={@Storage(value="abbrevs.xml")}, category=SettingsCategory.KEYMAP)
@ApiStatus.Internal
public final class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> abbreviationToActionId = new HashMap<String, List<String>>();
    private final Map<String, Set<String>> actionIdToAbbreviations = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> pluginsActionIdToAbbreviations = new HashMap<String, Set<String>>();

    @NotNull
    public Element getState() {
        Element actions = new Element("actions");
        if (this.actionIdToAbbreviations.isEmpty()) {
            Element element = actions;
            if (element == null) {
                AbbreviationManagerImpl.$$$reportNull$$$0(0);
            }
            return element;
        }
        Element result2 = null;
        for (Map.Entry<String, Set<String>> entry : this.actionIdToAbbreviations.entrySet()) {
            Set<String> pluginAbbreviations;
            String key = entry.getKey();
            Set<String> abbreviations = entry.getValue();
            if (Objects.equals(abbreviations, pluginAbbreviations = this.pluginsActionIdToAbbreviations.get(key)) || abbreviations == null) continue;
            if (result2 == null) {
                result2 = new Element("abbreviations");
                actions.addContent(result2);
            }
            Element action2 = new Element("action");
            action2.setAttribute("id", key);
            result2.addContent(action2);
            for (String abbr : abbreviations) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action2.addContent(abbreviation);
            }
        }
        Element element = actions;
        if (element == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(1);
        }
        return element;
    }

    public void loadState(@NotNull Element state2) {
        List abbreviations;
        if (state2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(2);
        }
        if ((abbreviations = state2.getChildren("abbreviations")).size() != 1) {
            return;
        }
        List actions = ((Element)abbreviations.get(0)).getChildren("action");
        for (Element action2 : actions) {
            String actionId = action2.getAttributeValue("id");
            Set values2 = this.actionIdToAbbreviations.computeIfAbsent(actionId, k -> new LinkedHashSet(1));
            for (Element abbr : action2.getChildren("abbreviation")) {
                String abbrValue = abbr.getAttributeValue("name");
                if (abbrValue == null) continue;
                values2.add(abbrValue);
                this.abbreviationToActionId.computeIfAbsent(abbrValue, k -> new ArrayList()).add(actionId);
            }
        }
    }

    @NotNull
    public Set<String> getAbbreviations() {
        Set<String> set = this.actionIdToAbbreviations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (set == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getAbbreviations(@NotNull String actionId) {
        Set<String> abbreviations;
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(4);
        }
        Set<Object> set = (abbreviations = this.actionIdToAbbreviations.get(actionId)) == null ? Collections.emptySet() : Collections.unmodifiableSet(abbreviations);
        if (set == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public List<String> findActions(@NotNull String abbreviation) {
        List<String> actions;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(6);
        }
        List<Object> list2 = (actions = this.abbreviationToActionId.get(abbreviation)) == null ? Collections.emptyList() : Collections.unmodifiableList(actions);
        if (list2 == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static void register(@NotNull String abbreviation, @NotNull String actionId, @NotNull Map<String, Set<String>> storage) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(8);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(9);
        }
        if (storage == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(10);
        }
        storage.computeIfAbsent(actionId, k -> new LinkedHashSet(1)).add(abbreviation);
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId, boolean fromPluginXml) {
        List ids;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(11);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(12);
        }
        if (fromPluginXml && this.actionIdToAbbreviations.containsKey(actionId)) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.pluginsActionIdToAbbreviations);
            return;
        }
        AbbreviationManagerImpl.register(abbreviation, actionId, this.actionIdToAbbreviations);
        if (fromPluginXml) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.pluginsActionIdToAbbreviations);
        }
        if (!(ids = this.abbreviationToActionId.computeIfAbsent(abbreviation, k -> new ArrayList(0))).contains(actionId)) {
            ids.add(actionId);
        }
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId) {
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(13);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(14);
        }
        this.register(abbreviation, actionId, false);
    }

    public void remove(@NotNull String abbreviation, @NotNull String actionId) {
        Set<String> abbreviations;
        List<String> actions;
        if (abbreviation == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(15);
        }
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(16);
        }
        if ((actions = this.abbreviationToActionId.get(abbreviation)) != null) {
            actions.remove(actionId);
        }
        if ((abbreviations = this.actionIdToAbbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            abbreviations = this.actionIdToAbbreviations.get(actionId);
            if (abbreviations != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbreviations);
                customValues.remove(abbreviation);
                this.actionIdToAbbreviations.put(actionId, customValues);
            }
        }
    }

    public void removeAllAbbreviations(@NotNull String actionId) {
        if (actionId == null) {
            AbbreviationManagerImpl.$$$reportNull$$$0(17);
        }
        Set<String> abbreviations = this.getAbbreviations(actionId);
        for (String abbreviation : abbreviations) {
            this.abbreviationToActionId.get(abbreviation).remove(actionId);
        }
        this.actionIdToAbbreviations.remove(actionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/AbbreviationManagerImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbbreviations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAbbreviations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findActions";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAbbreviations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

