/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00102\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\tH\u0016\u0082\u0001\u0005\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "", "<init>", "()V", "writeConfigMarkerFile", "", "configDir", "Ljava/nio/file/Path;", "getStringPresentation", "", "toString", "StartWithCleanConfig", "MigrateFromCustomPlace", "MigratePluginsFromCustomPlace", "SetProperties", "MergeConfigs", "Companion", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MergeConfigs;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigratePluginsFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCustomConfigMigrationOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n13#2:160\n*S KotlinDebug\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption\n*L\n76#1:160\n*E\n"})
public abstract sealed class CustomConfigMigrationOption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String IMPORT_PREFIX = "import ";
    @NotNull
    private static final String MIGRATE_PLUGINS_PREFIX = "migrate-plugins ";
    @NotNull
    private static final String SET_PROPERTIES_PREFIX = "set-properties ";
    @NotNull
    private static final String PROPERTIES_PREFIX = "properties ";
    @NotNull
    private static final String MERGE_CONFIGS_COMMAND = "merge-configs";

    private CustomConfigMigrationOption() {
    }

    @JvmOverloads
    public final void writeConfigMarkerFile(@NotNull Path configDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Path markerFile = Companion.getCustomConfigMarkerFilePath(configDir);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.error("Marker file " + markerFile + " shouldn't exist");
        }
        NioFiles.createDirectories((Path)markerFile.getParent());
        Files.writeString(markerFile, (CharSequence)this.getStringPresentation(), Charsets.UTF_8, new OpenOption[0]);
    }

    public static /* synthetic */ void writeConfigMarkerFile$default(CustomConfigMigrationOption customConfigMigrationOption, Path path, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeConfigMarkerFile");
        }
        if ((n & 1) != 0) {
            Path path2 = PathManager.getOriginalConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getOriginalConfigDir(...)");
            path = path2;
        }
        customConfigMigrationOption.writeConfigMarkerFile(path);
    }

    @NotNull
    public abstract String getStringPresentation();

    @NotNull
    public String toString() {
        return this.getStringPresentation();
    }

    @JvmOverloads
    public final void writeConfigMarkerFile() throws IOException {
        CustomConfigMigrationOption.writeConfigMarkerFile$default(this, null, 1, null);
    }

    @JvmStatic
    @Nullable
    public static final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
        return Companion.readCustomConfigMigrationOptionAndRemoveMarkerFile(configDir);
    }

    public /* synthetic */ CustomConfigMigrationOption(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(CustomConfigMigrationOption.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "IMPORT_PREFIX", "", "MIGRATE_PLUGINS_PREFIX", "SET_PROPERTIES_PREFIX", "PROPERTIES_PREFIX", "getPROPERTIES_PREFIX$annotations", "MERGE_CONFIGS_COMMAND", "readCustomConfigMigrationOptionAndRemoveMarkerFile", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "configDir", "Ljava/nio/file/Path;", "removeMarkerFile", "", "markerFile", "getCustomConfigMarkerFilePath", "doesCustomConfigMarkerExist", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCustomConfigMigrationOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1617#2,9:160\n1869#2:169\n1870#2:171\n1626#2:172\n1#3:170\n*S KotlinDebug\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption$Companion\n*L\n119#1:160,9\n119#1:169\n119#1:171\n119#1:172\n119#1:170\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Legacy version for compatibility with Toolbox", replaceWith=@ReplaceWith(expression="SET_PROPERTIES_PREFIX", imports={}))
        private static /* synthetic */ void getPROPERTIES_PREFIX$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path markerFile = this.getCustomConfigMarkerFilePath(configDir);
            if (!Files.exists(markerFile, new LinkOption[0])) {
                return null;
            }
            try {
                CustomConfigMigrationOption customConfigMigrationOption;
                List<String> lines = Files.readAllLines(markerFile);
                Intrinsics.checkNotNull(lines);
                String line = (String)CollectionsKt.firstOrNull(lines);
                Object object = line;
                if (object == null || object.length() == 0) {
                    customConfigMigrationOption = StartWithCleanConfig.INSTANCE;
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.IMPORT_PREFIX, (boolean)false, (int)2, null)) {
                    MigrateFromCustomPlace migrateFromCustomPlace;
                    Path path = markerFile.getFileSystem().getPath(StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.IMPORT_PREFIX), new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        Intrinsics.checkNotNull((Object)path);
                        migrateFromCustomPlace = new MigrateFromCustomPlace(path);
                    } else {
                        log.warn(markerFile + " points to non-existent config: [" + lines + "]");
                        migrateFromCustomPlace = null;
                    }
                    customConfigMigrationOption = migrateFromCustomPlace;
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX, (boolean)false, (int)2, null)) {
                    Path path = markerFile.getFileSystem().getPath(StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                    customConfigMigrationOption = new MigratePluginsFromCustomPlace(path);
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.PROPERTIES_PREFIX, (boolean)false, (int)2, null)) {
                    var6_9 = new char[]{' '};
                    properties = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.PROPERTIES_PREFIX), (char[])var6_9, (boolean)false, (int)0, (int)6, null);
                    customConfigMigrationOption = SetProperties.Companion.setToTrue(properties);
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.SET_PROPERTIES_PREFIX, (boolean)false, (int)2, null)) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    var6_9 = new char[]{';'};
                    var6_9 = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.SET_PROPERTIES_PREFIX), (char[])var6_9, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$mapNotNull = false;
                    void var8_11 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Pair it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        char[] cArray = new char[]{' '};
                        List list2 = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                        if ((list2.size() < 2 ? null : TuplesKt.to(list2.get(0), list2.get(1))) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    properties = (List)destination$iv$iv;
                    customConfigMigrationOption = new SetProperties(properties);
                } else if (Intrinsics.areEqual((Object)line, (Object)CustomConfigMigrationOption.MERGE_CONFIGS_COMMAND)) {
                    customConfigMigrationOption = MergeConfigs.INSTANCE;
                } else {
                    log.error("Invalid format of " + markerFile + ": " + lines);
                    customConfigMigrationOption = null;
                }
                object = customConfigMigrationOption;
                return object;
            }
            catch (Exception exception) {
                log.warn("Couldn't load content of " + markerFile);
                CustomConfigMigrationOption customConfigMigrationOption = null;
                return customConfigMigrationOption;
            }
            finally {
                this.removeMarkerFile(markerFile);
            }
        }

        private final void removeMarkerFile(Path markerFile) {
            try {
                Files.delete(markerFile);
            }
            catch (Exception e) {
                log.warn("Couldn't delete the custom config migration file " + markerFile, (Throwable)e);
            }
        }

        @VisibleForTesting
        @NotNull
        public final Path getCustomConfigMarkerFilePath(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path path = configDir.resolve("migrate.config");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        public final boolean doesCustomConfigMarkerExist(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(this.getCustomConfigMarkerFilePath(configDir), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MergeConfigs;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "<init>", "()V", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MergeConfigs
    extends CustomConfigMigrationOption {
        @NotNull
        public static final MergeConfigs INSTANCE = new MergeConfigs();

        private MergeConfigs() {
            super(null);
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.MERGE_CONFIGS_COMMAND;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "location", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getLocation", "()Ljava/nio/file/Path;", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MigrateFromCustomPlace
    extends CustomConfigMigrationOption {
        @NotNull
        private final Path location;

        public MigrateFromCustomPlace(@NotNull Path location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            super(null);
            this.location = location;
        }

        @NotNull
        public final Path getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.IMPORT_PREFIX + StringsKt.replace$default((String)((Object)this.location).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigratePluginsFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "configLocation", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getConfigLocation", "()Ljava/nio/file/Path;", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MigratePluginsFromCustomPlace
    extends CustomConfigMigrationOption {
        @NotNull
        private final Path configLocation;

        public MigratePluginsFromCustomPlace(@NotNull Path configLocation) {
            Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
            super(null);
            this.configLocation = configLocation;
        }

        @NotNull
        public final Path getConfigLocation() {
            return this.configLocation;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX + StringsKt.replace$default((String)((Object)this.configLocation).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0016R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "properties", "", "Lkotlin/Pair;", "", "<init>", "(Ljava/util/List;)V", "getProperties", "()Ljava/util/List;", "getStringPresentation", "Companion", "intellij.platform.ide.impl"})
    public static final class SetProperties
    extends CustomConfigMigrationOption {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Pair<String, String>> properties;

        public SetProperties(@NotNull List<Pair<String, String>> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(null);
            this.properties = properties;
        }

        @NotNull
        public final List<Pair<String, String>> getProperties() {
            return this.properties;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.SET_PROPERTIES_PREFIX + CollectionsKt.joinToString$default((Iterable)this.properties, (CharSequence)";", null, null, (int)0, null, SetProperties::getStringPresentation$lambda$0, (int)30, null);
        }

        private static final CharSequence getStringPresentation$lambda$0(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getFirst() + " " + it.getSecond();
        }

        @JvmStatic
        @NotNull
        public static final SetProperties setToTrue(@NotNull List<String> properties) {
            return Companion.setToTrue(properties);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties$Companion;", "", "<init>", "()V", "setToTrue", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "properties", "", "", "intellij.platform.ide.impl"})
        @SourceDebugExtension(value={"SMAP\nCustomConfigMigrationOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n*S KotlinDebug\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties$Companion\n*L\n67#1:160\n67#1:161,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public final SetProperties setToTrue(@NotNull List<String> properties) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                Iterable $this$map$iv = properties;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it, (Object)"true"));
                }
                List list2 = (List)destination$iv$iv;
                return new SetProperties(list2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "<init>", "()V", "getStringPresentation", "", "toString", "intellij.platform.ide.impl"})
    public static final class StartWithCleanConfig
    extends CustomConfigMigrationOption {
        @NotNull
        public static final StartWithCleanConfig INSTANCE = new StartWithCleanConfig();

        private StartWithCleanConfig() {
            super(null);
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return "";
        }

        @Override
        @NotNull
        public String toString() {
            return "Start with clean config";
        }
    }
}

