/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.rw;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.rw.CancellableReadActionKt;
import com.intellij.openapi.application.rw.InternalReadAction;
import com.intellij.openapi.application.rw.InternalReadActionKt;
import com.intellij.openapi.application.rw.ReadResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u000f\u001a\u00028\u0000H\u0086@\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\u0012\u001a\u00028\u0000H\u0082@\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/application/rw/InternalReadAction;", "T", "", "constraints", "", "Lcom/intellij/openapi/application/ReadConstraint;", "undispatched", "", "blocking", "action", "Lkotlin/Function0;", "<init>", "(Ljava/util/List;ZZLkotlin/jvm/functions/Function0;)V", "application", "Lcom/intellij/openapi/application/ex/ApplicationEx;", "runReadAction", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findUnsatisfiedConstraint", "readLoop", "tryReadAction", "Lcom/intellij/openapi/application/rw/ReadResult;", "tryReadBlocking", "tryReadCancellable", "insideReadAction", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nInternalReadAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalReadAction.kt\ncom/intellij/openapi/application/rw/InternalReadAction\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,158:1\n375#2:159\n375#2:160\n*S KotlinDebug\n*F\n+ 1 InternalReadAction.kt\ncom/intellij/openapi/application/rw/InternalReadAction\n*L\n40#1:159\n99#1:160\n*E\n"})
public final class InternalReadAction<T> {
    @NotNull
    private final List<ReadConstraint> constraints;
    private final boolean undispatched;
    private final boolean blocking;
    @NotNull
    private final Function0<T> action;
    @NotNull
    private final ApplicationEx application;

    public InternalReadAction(@NotNull List<? extends ReadConstraint> constraints, boolean undispatched, boolean blocking, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.constraints = constraints;
        this.undispatched = undispatched;
        this.blocking = blocking;
        this.action = action2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        this.application = (ApplicationEx)application;
    }

    @Nullable
    public final Object runReadAction(@NotNull Continuation<? super T> $completion) {
        if (this.undispatched) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (this.application.isReadAccessAllowed()) {
                ReadConstraint unsatisfiedConstraint = this.findUnsatisfiedConstraint();
                if (!(unsatisfiedConstraint == null)) {
                    boolean $i$a$-check-InternalReadAction$runReadAction$32 = false;
                    String $i$a$-check-InternalReadAction$runReadAction$32 = "Cannot suspend until constraints are satisfied while holding the read lock: " + unsatisfiedConstraint;
                    throw new IllegalStateException($i$a$-check-InternalReadAction$runReadAction$32.toString());
                }
                return ReadAction.compute(() -> InternalReadAction.runReadAction$lambda$1(this.action));
            }
            return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, null){
                int label;
                final /* synthetic */ InternalReadAction<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InternalReadAction.access$readLoop(this.this$0, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }
        boolean $i$f$currentCoroutineContext = false;
        if (this.application.isParallelizedReadAction($completion.getContext()) && this.application.isReadAccessAllowed()) {
            ReadConstraint unsatisfiedConstraint = this.findUnsatisfiedConstraint();
            if (!(unsatisfiedConstraint == null)) {
                boolean bl = false;
                String string = "Cannot suspend until constraints are satisfied while holding the read lock: " + unsatisfiedConstraint;
                throw new IllegalStateException(string.toString());
            }
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, null){
                int label;
                final /* synthetic */ InternalReadAction<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return ReadAction.compute(() -> runReadAction.5.invokeSuspend$lambda$0(InternalReadAction.access$getAction$p(this.this$0)));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Object invokeSuspend$lambda$0(Function0 $tmp0) {
                    return $tmp0.invoke();
                }
            }, $completion);
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, null){
            int label;
            final /* synthetic */ InternalReadAction<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        InternalReadAction.access$getApplication$p(this.this$0).assertReadAccessNotAllowed();
                        this.label = 1;
                        Object object2 = InternalReadAction.access$readLoop(this.this$0, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final ReadConstraint findUnsatisfiedConstraint() {
        for (ReadConstraint constraint : this.constraints) {
            if (constraint.isSatisfied()) continue;
            return constraint;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object readLoop(Continuation<? super T> $completion) {
        if (!($completion instanceof readLoop.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ InternalReadAction<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InternalReadAction.access$readLoop(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                loopJob = JobKt.getJob((CoroutineContext)$continuation.getContext());
lbl14:
                // 4 sources

                while (true) {
                    JobKt.ensureActive((Job)loopJob);
                    if (this.application.isWriteActionPending() || this.application.isWriteActionInProgress()) {
                        $continuation.L$0 = loopJob;
                        $continuation.L$1 = null;
                        $continuation.label = 1;
                        v0 = InternalReadActionKt.access$yieldToPendingWriteActions((Continuation)$continuation);
                        if (v0 == var6_4) {
                            return var6_4;
                        }
                    }
                    ** GOTO lbl28
                    break;
                }
            }
            case 1: {
                loopJob = (Job)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $continuation.L$0 = loopJob;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = this.tryReadAction((Continuation<? super ReadResult<? extends T>>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl39
            }
            case 2: {
                loopJob = (Job)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                if ((readResult = (ReadResult)v1) instanceof ReadResult.Successful) {
                    return ((ReadResult.Successful)readResult).getValue();
                }
                if (!(readResult instanceof ReadResult.UnsatisfiedConstraint)) break;
                $continuation.L$0 = loopJob;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)readResult);
                $continuation.label = 3;
                v2 = ((ReadResult.UnsatisfiedConstraint)readResult).getConstraint().awaitConstraint((Continuation)$continuation);
                if (v2 != var6_4) ** GOTO lbl14
                return var6_4;
            }
            case 3: {
                readResult = (ReadResult)$continuation.L$1;
                loopJob = (Job)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl14
            }
        }
        if (!(readResult instanceof ReadResult.WritePending)) ** break;
        ** while (true)
        throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object tryReadAction(Continuation<? super ReadResult<? extends T>> $completion) {
        if (this.blocking) {
            return this.tryReadBlocking($completion);
        }
        return this.tryReadCancellable($completion);
    }

    private final Object tryReadBlocking(Continuation<? super ReadResult<? extends T>> $completion) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        this.application.tryRunReadAction(() -> InternalReadAction.tryReadBlocking$lambda$0(result2, this));
        ReadResult readResult2 = (ReadResult)result2.element;
        if (readResult2 == null) {
            readResult2 = ReadResult.WritePending.INSTANCE;
        }
        return readResult2;
    }

    private final Object tryReadCancellable(Continuation<? super ReadResult<? extends T>> $completion) {
        ReadResult readResult2;
        try {
            boolean $i$f$currentCoroutineContext = false;
            CoroutineContext ctx = $completion.getContext();
            readResult2 = (ReadResult)CancellableReadActionKt.cancellableReadActionInternal(ctx, () -> InternalReadAction.tryReadCancellable$lambda$0(this));
        }
        catch (ReadAction.CannotReadException readCe) {
            readResult2 = ReadResult.WritePending.INSTANCE;
        }
        return readResult2;
    }

    private final ReadResult<T> insideReadAction() {
        ReadConstraint unsatisfiedConstraint = this.findUnsatisfiedConstraint();
        return unsatisfiedConstraint == null ? (ReadResult)new ReadResult.Successful<Object>(this.action.invoke()) : (ReadResult)new ReadResult.UnsatisfiedConstraint(unsatisfiedConstraint);
    }

    private static final Object runReadAction$lambda$1(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final void tryReadBlocking$lambda$0(Ref.ObjectRef $result, InternalReadAction this$0) {
        $result.element = this$0.insideReadAction();
    }

    private static final ReadResult tryReadCancellable$lambda$0(InternalReadAction this$0) {
        return this$0.insideReadAction();
    }

    public static final /* synthetic */ Object access$readLoop(InternalReadAction $this, Continuation $completion) {
        return $this.readLoop($completion);
    }

    public static final /* synthetic */ Function0 access$getAction$p(InternalReadAction $this) {
        return $this.action;
    }

    public static final /* synthetic */ ApplicationEx access$getApplication$p(InternalReadAction $this) {
        return $this.application;
    }

    public static final /* synthetic */ Object access$tryReadAction(InternalReadAction $this, Continuation $completion) {
        return $this.tryReadAction($completion);
    }

    public static final /* synthetic */ Object access$tryReadBlocking(InternalReadAction $this, Continuation $completion) {
        return $this.tryReadBlocking($completion);
    }

    public static final /* synthetic */ Object access$tryReadCancellable(InternalReadAction $this, Continuation $completion) {
        return $this.tryReadCancellable($completion);
    }
}

