/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAwareComponentManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionImplKt;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientType;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.kernel.util.KernelUtilsKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.PrecomputedExtensionModelKt;
import com.intellij.util.messages.MessageBus;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&J4\u0010'\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001c2\b\u0010*\u001a\u0004\u0018\u00010+2\u0014\u0010,\u001a\u0010\u0012\n\b\u0000\u0012\u00060.j\u0002`/\u0018\u00010-J\u0010\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0004J/\u00103\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u00105\u001a\u00020\u0010H\u0004\u00a2\u0006\u0002\u00106J5\u00103\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u00105\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u0004\u0018\u00010+J\b\u0010>\u001a\u00020?H\u0007J\u0006\u0010@\u001a\u00020AJ\u0010\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020\u0010H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006D"}, d2={"Lcom/intellij/openapi/client/ClientSessionImpl;", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "Lcom/intellij/openapi/client/ClientSession;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "type", "Lcom/intellij/openapi/client/ClientType;", "sharedComponentManager", "Lcom/intellij/openapi/client/ClientAwareComponentManager;", "<init>", "(Lcom/intellij/codeWithMe/ClientId;Lcom/intellij/openapi/client/ClientType;Lcom/intellij/openapi/client/ClientAwareComponentManager;)V", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "getType", "()Lcom/intellij/openapi/client/ClientType;", "isLightServiceSupported", "", "()Z", "isMessageBusSupported", "findConstructorAndInstantiateClass", "T", "", "lookup", "Ljava/lang/invoke/MethodHandles$Lookup;", "aClass", "Ljava/lang/Class;", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/Class;)Ljava/lang/Object;", "supportedSignaturesOfLightServiceConstructors", "", "Ljava/lang/invoke/MethodType;", "getSupportedSignaturesOfLightServiceConstructors", "()Ljava/util/List;", "preloadServices", "", "syncScope", "Lkotlinx/coroutines/CoroutineScope;", "isServiceSuitable", "descriptor", "Lcom/intellij/openapi/components/ServiceDescriptor;", "registerComponents", "modules", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "app", "Lcom/intellij/openapi/application/Application;", "listenerCallbacks", "", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "isComponentSuitable", "componentConfig", "Lcom/intellij/openapi/components/ComponentConfig;", "doGetService", "serviceClass", "createIfNeeded", "(Ljava/lang/Class;Z)Ljava/lang/Object;", "fallbackToShared", "(Ljava/lang/Class;ZZ)Ljava/lang/Object;", "getApplication", "componentStore", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "getComponentStore", "()Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "getMessageBus", "Lcom/intellij/util/messages/MessageBus;", "toString", "", "debugString", "short", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionImpl.kt\ncom/intellij/openapi/client/ClientSessionImpl\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n47#2,4:268\n1#3:272\n*S KotlinDebug\n*F\n+ 1 ClientSessionImpl.kt\ncom/intellij/openapi/client/ClientSessionImpl\n*L\n76#1:268,4\n*E\n"})
public abstract class ClientSessionImpl
extends ComponentManagerImpl
implements ClientSession {
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final ClientType type;
    @NotNull
    private final ClientAwareComponentManager sharedComponentManager;
    @NotNull
    private final List<MethodType> supportedSignaturesOfLightServiceConstructors;

    public ClientSessionImpl(@NotNull ClientId clientId, @NotNull ClientType type, @NotNull ClientAwareComponentManager sharedComponentManager) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)sharedComponentManager), (String)"sharedComponentManager");
        super(null, CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)("Client[" + clientId + "] Session scope"), (CoroutineContext)KernelUtilsKt.kernelCoroutineContext((CoroutineContext)sharedComponentManager.getCoroutineScope().getCoroutineContext()), (boolean)false, (int)4, null), (CoroutineContext)ClientIdKt.asContextElement((ClientId)clientId));
        this.clientId = clientId;
        this.type = type;
        this.sharedComponentManager = sharedComponentManager;
        this.registerServiceInstance(ClientSession.class, (Object)this, (PluginDescriptor)ComponentManagerImpl.fakeCorePluginDescriptor);
        Object[] objectArray = new MethodType[]{ClientSessionImplKt.access$getSessionConstructorMethodType$p()};
        this.supportedSignaturesOfLightServiceConstructors = (List)ExtensionsKt.persistentListOf((Object[])objectArray).addAll((Collection)super.getSupportedSignaturesOfLightServiceConstructors());
    }

    @NotNull
    public final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final ClientType getType() {
        return this.type;
    }

    protected final boolean isLightServiceSupported() {
        return false;
    }

    protected final boolean isMessageBusSupported() {
        return false;
    }

    @NotNull
    protected <T> T findConstructorAndInstantiateClass(@NotNull MethodHandles.Lookup lookup, @NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        MethodType methodType = ClientSessionImplKt.access$getSessionConstructorMethodType$p();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"access$getSessionConstructorMethodType$p(...)");
        MethodHandle methodHandle = ComponentManagerImplKt.findConstructorOrNull((MethodHandles.Lookup)lookup, aClass, (MethodType)methodType);
        Object object = methodHandle != null ? methodHandle.invoke(this) : null;
        if (object == null) {
            object = super.findConstructorAndInstantiateClass(lookup, aClass);
        }
        return (T)object;
    }

    @NotNull
    public List<MethodType> getSupportedSignaturesOfLightServiceConstructors() {
        return this.supportedSignaturesOfLightServiceConstructors;
    }

    public final void preloadServices(@NotNull CoroutineScope syncScope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)syncScope, (String)"syncScope");
        boolean bl2 = bl = this.containerState.get() == ComponentManagerImpl.ContainerState.PRE_INIT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean $i$f$CoroutineExceptionHandler = false;
        Object object = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler exceptionHandler = new CoroutineExceptionHandler((CoroutineExceptionHandler.Key)object){

            public void handleException(CoroutineContext context2, Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                ClientSessionImplKt.access$getLOG().error(exception2);
            }
        };
        this.preloadServices(PluginManagerCore.getPluginSet().getEnabledModules(), "client ", kotlinx.coroutines.CoroutineScopeKt.plus((CoroutineScope)syncScope, (CoroutineContext)((CoroutineContext)exceptionHandler)), false, this.getCoroutineScope());
        boolean bl3 = this.containerState.compareAndSet(ComponentManagerImpl.ContainerState.PRE_INIT, ComponentManagerImpl.ContainerState.COMPONENT_CREATED);
        if (_Assertions.ENABLED && !bl3) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
    }

    public final boolean isServiceSuitable(@NotNull ServiceDescriptor descriptor2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ClientKind clientKind = descriptor2.client;
        if (clientKind != null) {
            ClientKind it = clientKind;
            boolean bl2 = false;
            bl = this.type.matches(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final void registerComponents(@NotNull List<? extends IdeaPluginDescriptorImpl> modules, @Nullable Application app, @Nullable List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : modules) {
            this.registerServices(this.getContainerDescriptor((IdeaPluginDescriptorImpl)ideaPluginDescriptorImpl).services, (IdeaPluginDescriptor)ideaPluginDescriptorImpl);
            PrecomputedExtensionModelKt.executeRegisterTaskForOldContent((IdeaPluginDescriptorImpl)ideaPluginDescriptorImpl, arg_0 -> ClientSessionImpl.registerComponents$lambda$0(this, arg_0));
        }
    }

    protected final boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        Intrinsics.checkNotNullParameter((Object)componentConfig, (String)"componentConfig");
        ClientSessionImplKt.access$getLOG().error("components aren't supported");
        return false;
    }

    @Nullable
    protected final <T> T doGetService(@NotNull Class<T> serviceClass, boolean createIfNeeded) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return this.doGetService(serviceClass, createIfNeeded, true);
    }

    @Nullable
    public final <T> T doGetService(@NotNull Class<T> serviceClass, boolean createIfNeeded, boolean fallbackToShared) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        if (!(fallbackToShared || createIfNeeded || this.hasComponent(serviceClass))) {
            return null;
        }
        Object clientService = ClientId.Companion.withExplicitClientId(this.clientId, () -> ClientSessionImpl.doGetService$lambda$0(this, serviceClass, createIfNeeded));
        if (clientService != null || !fallbackToShared) {
            return (T)clientService;
        }
        if (createIfNeeded && !this.type.isLocal() && !this.type.isFrontend()) {
            ClientSessionImpl localSession;
            ClientSessionsManager sessionsManager;
            ClientSessionsManager clientSessionsManager = sessionsManager = (ClientSessionsManager)this.sharedComponentManager.getService(ClientSessionsManager.class);
            ClientSession clientSession = clientSessionsManager != null ? clientSessionsManager.getSession(ClientId.Companion.getLocalId()) : null;
            ClientSessionImpl clientSessionImpl = localSession = clientSession instanceof ClientSessionImpl ? (ClientSessionImpl)clientSession : null;
            if ((clientSessionImpl != null ? clientSessionImpl.doGetService(serviceClass, true, false) : null) != null) {
                ClientSessionImplKt.access$getLOG().error(serviceClass + " is registered only for client=\"local\", please provide a guest-specific implementation, or change to client=\"all\"");
                return null;
            }
        }
        return (T)ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> ClientSessionImpl.doGetService$lambda$1(createIfNeeded, this, serviceClass));
    }

    @Nullable
    public final Application getApplication() {
        return this.sharedComponentManager.getApplication();
    }

    @NotNull
    public IComponentStore getComponentStore() {
        return this.sharedComponentManager.getComponentStore();
    }

    @Deprecated(message="sessions don't have their own message bus", level=DeprecationLevel.ERROR)
    @NotNull
    public final MessageBus getMessageBus() {
        throw new IllegalStateException("Not supported".toString());
    }

    @NotNull
    public final String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(type=" + this.type + ", clientId=" + this.clientId + ")";
    }

    @NotNull
    protected String debugString(boolean bl) {
        String className = bl ? ((Object)((Object)this)).getClass().getSimpleName() : ((Object)((Object)this)).getClass().getName();
        return className + "::" + this.type + "#" + this.clientId;
    }

    private static final Unit registerComponents$lambda$0(ClientSessionImpl this$0, IdeaPluginDescriptorImpl module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this$0.registerServices(this$0.getContainerDescriptor((IdeaPluginDescriptorImpl)module).services, (IdeaPluginDescriptor)module);
        return Unit.INSTANCE;
    }

    private static final Object doGetService$lambda$0(ClientSessionImpl this$0, Class $serviceClass, boolean $createIfNeeded) {
        return super.doGetService($serviceClass, $createIfNeeded);
    }

    private static final Object doGetService$lambda$1(boolean $createIfNeeded, ClientSessionImpl this$0, Class $serviceClass) {
        return $createIfNeeded ? this$0.sharedComponentManager.getService($serviceClass) : this$0.sharedComponentManager.getServiceIfCreated($serviceClass);
    }
}

