/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CmdEvent;
import com.intellij.openapi.command.impl.CommandBuilder;
import com.intellij.openapi.command.impl.CommandIdService;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.LocalCommandMergerSnapshot;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.PerClientLocalUndoRedoSnapshot;
import com.intellij.openapi.command.impl.PerformedCommand;
import com.intellij.openapi.command.impl.Redo;
import com.intellij.openapi.command.impl.Undo;
import com.intellij.openapi.command.impl.UndoCommandFlushReason;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoIllegalStateException;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoSharedState;
import com.intellij.openapi.command.impl.UndoSpy;
import com.intellij.openapi.command.impl.UndoableActionType;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class UndoClientState
implements Disposable {
    private static final Logger LOG = Logger.getInstance(UndoClientState.class);
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    @Nullable
    private final Project project;
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final CommandMerger commandMerger;
    @NotNull
    private final CommandBuilder commandBuilder;
    @NotNull
    private final UndoRedoStacksHolder undoStacksHolder;
    @NotNull
    private final UndoRedoStacksHolder redoStacksHolder;
    private final boolean isConfirmationSupported;
    private final boolean isCompactSupported;
    private final boolean isGlobalSplitSupported;
    private final boolean isEditorStateRestoreSupported;
    @NotNull
    private final UndoSharedState sharedState;
    @NotNull
    private UndoRedoInProgress undoRedoInProgress;
    private int commandTimestamp;

    UndoClientState(@NotNull ClientProjectSession session) {
        if (session == null) {
            UndoClientState.$$$reportNull$$$0(0);
        }
        this((UndoManagerImpl)UndoManager.getInstance((Project)session.getProject()), session.getClientId());
    }

    UndoClientState(@NotNull ClientAppSession session) {
        if (session == null) {
            UndoClientState.$$$reportNull$$$0(1);
        }
        this((UndoManagerImpl)UndoManager.getGlobalInstance(), session.getClientId());
    }

    private UndoClientState(@NotNull UndoManagerImpl undoManager, @NotNull ClientId clientId) {
        if (undoManager == null) {
            UndoClientState.$$$reportNull$$$0(2);
        }
        if (clientId == null) {
            UndoClientState.$$$reportNull$$$0(3);
        }
        this.undoRedoInProgress = UndoRedoInProgress.NONE;
        this.commandTimestamp = 1;
        this.clientId = clientId;
        this.project = undoManager.getProject();
        this.isConfirmationSupported = undoManager.isConfirmationSupported();
        this.isCompactSupported = undoManager.isCompactSupported();
        this.isGlobalSplitSupported = undoManager.isGlobalSplitSupported();
        this.isEditorStateRestoreSupported = undoManager.isEditorStateRestoreSupported();
        this.sharedState = undoManager.getUndoSharedState();
        this.undoStacksHolder = new UndoRedoStacksHolder(this.sharedState.getAdjustableActions(), true);
        this.redoStacksHolder = new UndoRedoStacksHolder(this.sharedState.getAdjustableActions(), false);
        this.commandMerger = new CommandMerger(this.project != null, undoManager.isTransparentSupported());
        this.commandBuilder = new CommandBuilder(this.project, undoManager.isTransparentSupported(), undoManager.isGroupIdChangeSupported());
    }

    public void dispose() {
        Set<DocumentReference> affected = this.clearStacks();
        this.sharedState.trimStacks(affected);
    }

    boolean isActiveForCurrentProject() {
        return this.commandBuilder.isActive();
    }

    boolean isUndoRedoAvailable(@Nullable FileEditor editor2, boolean isUndo) {
        Collection<DocumentReference> refs = UndoDocumentUtil.getDocRefs(editor2);
        return refs != null && this.isUndoRedoAvailable(refs, isUndo);
    }

    boolean isUndoRedoAvailable(@NotNull Collection<DocumentReference> docRefs, boolean isUndo) {
        if (docRefs == null) {
            UndoClientState.$$$reportNull$$$0(4);
        }
        if (isUndo && this.commandMerger.isUndoAvailable(docRefs)) {
            return true;
        }
        UndoRedoStacksHolder stacksHolder = isUndo ? this.undoStacksHolder : this.redoStacksHolder;
        return stacksHolder.canBeUndoneOrRedone(docRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undoOrRedo(@Nullable FileEditor editor2, @NlsContexts.Command @NotNull String commandName, @NotNull Runnable beforeUndoRedoStarted, boolean undo) {
        if (commandName == null) {
            UndoClientState.$$$reportNull$$$0(5);
        }
        if (beforeUndoRedoStarted == null) {
            UndoClientState.$$$reportNull$$$0(6);
        }
        if (this.isUndoOrRedoInProgress()) {
            throw new UndoIllegalStateException("Undo/redo operation is already in progress");
        }
        this.undoRedoInProgress = undo ? UndoRedoInProgress.UNDO : UndoRedoInProgress.REDO;
        try {
            AtomicReference exception = new AtomicReference();
            CommandProcessor.getInstance().executeCommand(this.project, () -> {
                try {
                    beforeUndoRedoStarted.run();
                    CopyPasteManager.getInstance().stopKillRings();
                    this.undoOrRedo(editor2, undo);
                }
                catch (RuntimeException ex) {
                    exception.set(ex);
                }
            }, commandName, null, this.commandMerger.getUndoConfirmationPolicy());
            if (exception.get() != null) {
                throw (RuntimeException)exception.get();
            }
        }
        finally {
            this.undoRedoInProgress = UndoRedoInProgress.NONE;
        }
    }

    long getNextNanoTime(@NotNull FileEditor editor2, boolean isUndo) {
        UndoableGroup lastAction;
        if (editor2 == null) {
            UndoClientState.$$$reportNull$$$0(7);
        }
        return (lastAction = this.getLastAction(editor2, isUndo)) == null ? -1L : lastAction.getGroupStartPerformedTimestamp();
    }

    boolean isNextAskConfirmation(@NotNull FileEditor editor2, boolean isUndo) {
        UndoableGroup lastAction;
        if (editor2 == null) {
            UndoClientState.$$$reportNull$$$0(8);
        }
        return (lastAction = this.getLastAction(editor2, isUndo)) != null && lastAction.shouldAskConfirmation(!isUndo);
    }

    @Nullable
    String getLastCommandName(@Nullable FileEditor editor2, boolean isUndo) {
        Collection<DocumentReference> refs = UndoDocumentUtil.getDocRefs(editor2);
        if (refs == null) {
            return null;
        }
        if (isUndo && this.commandMerger.isUndoAvailable(refs)) {
            return this.commandMerger.getCommandName();
        }
        UndoRedoStacksHolder stack = isUndo ? this.undoStacksHolder : this.redoStacksHolder;
        UndoableGroup lastAction = stack.getLastAction(refs);
        return lastAction == null ? null : lastAction.getCommandName();
    }

    void commandStarted(@NotNull CmdEvent cmdEvent, @NotNull CurrentEditorProvider editorProvider) {
        if (cmdEvent == null) {
            UndoClientState.$$$reportNull$$$0(9);
        }
        if (editorProvider == null) {
            UndoClientState.$$$reportNull$$$0(10);
        }
        this.commandBuilder.commandStarted(cmdEvent, editorProvider);
        UndoSpy undoSpy = UndoSpy.getInstance();
        if (undoSpy != null) {
            undoSpy.commandBeforeStarted(this.project, editorProvider.getCurrentEditor(this.project), this.commandBuilder.getOriginalDocument());
        }
    }

    void commandFinished(@NotNull CmdEvent cmdEvent) {
        if (cmdEvent == null) {
            UndoClientState.$$$reportNull$$$0(11);
        }
        PerformedCommand performedCommand = this.commandBuilder.commandFinished(cmdEvent);
        this.commitCommand(performedCommand);
        this.notifyUndoSpy(performedCommand);
    }

    private void commitCommand(@NotNull PerformedCommand performedCommand) {
        UndoCommandFlushReason flushReason;
        if (performedCommand == null) {
            UndoClientState.$$$reportNull$$$0(12);
        }
        if (performedCommand.shouldClearRedoStack()) {
            this.redoStacksHolder.clearStacks(performedCommand.affectedDocuments().asCollection(), performedCommand.isGlobal());
        }
        if ((flushReason = this.commandMerger.shouldFlush(performedCommand)) != null) {
            this.flushCommandMerger(flushReason, performedCommand);
            this.compactIfNeeded();
        }
        this.commandMerger.mergeWithPerformedCommand(performedCommand);
    }

    private void notifyUndoSpy(@NotNull PerformedCommand performedCommand) {
        if (performedCommand == null) {
            UndoClientState.$$$reportNull$$$0(13);
        }
        for (UndoableAction action2 : performedCommand.undoableActions()) {
            this.sharedState.addAction(action2);
            UndoSpy undoSpy = UndoSpy.getInstance();
            if (undoSpy == null) continue;
            undoSpy.undoableActionAdded(this.project, action2, UndoableActionType.forAction(action2));
        }
    }

    void flushCommandMerger(@NotNull UndoCommandFlushReason flushReason) {
        if (flushReason == null) {
            UndoClientState.$$$reportNull$$$0(14);
        }
        this.flushCommandMerger(flushReason, null);
    }

    boolean isInsideCommand() {
        return this.commandBuilder.isInsideCommand();
    }

    void markCurrentCommandAsGlobal() {
        this.commandBuilder.markAsGlobal();
    }

    void addAffectedDocuments(Document ... docs) {
        if (docs == null) {
            UndoClientState.$$$reportNull$$$0(15);
        }
        this.commandBuilder.addAffectedDocuments(docs);
    }

    void addAffectedFiles(VirtualFile ... files2) {
        if (files2 == null) {
            UndoClientState.$$$reportNull$$$0(16);
        }
        this.commandBuilder.addAffectedFiles(files2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUndoableAction(@NotNull CurrentEditorProvider editorProvider, @NotNull UndoableAction action2) {
        if (editorProvider == null) {
            UndoClientState.$$$reportNull$$$0(17);
        }
        if (action2 == null) {
            UndoClientState.$$$reportNull$$$0(18);
        }
        if (this.isUndoOrRedoInProgress()) {
            return;
        }
        action2.setPerformedNanoTime(System.nanoTime());
        if (this.isInsideCommand()) {
            this.commandBuilder.addUndoableAction(action2);
        } else {
            LOG.assertTrue(action2 instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            CmdEvent cmdEvent = CmdEvent.create(CommandIdService.currCommandId(), null, "", null, UndoConfirmationPolicy.DEFAULT, false, false);
            this.commandStarted(cmdEvent, editorProvider);
            try {
                this.commandBuilder.addUndoableAction(action2);
            }
            finally {
                this.commandFinished(cmdEvent);
            }
        }
    }

    void addDocumentAsAffected(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            UndoClientState.$$$reportNull$$$0(19);
        }
        this.commandBuilder.addDocumentAsAffected(docRef);
    }

    void invalidateActions(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoClientState.$$$reportNull$$$0(20);
        }
        if (this.isInsideCommand()) {
            this.commandBuilder.invalidateIfAffects(ref2);
        }
        this.commandMerger.invalidateActionsFor(ref2);
        this.undoStacksHolder.invalidateActionsFor(ref2);
        this.redoStacksHolder.invalidateActionsFor(ref2);
    }

    boolean isUndoInProgress() {
        return this.undoRedoInProgress == UndoRedoInProgress.UNDO;
    }

    boolean isRedoInProgress() {
        return this.undoRedoInProgress == UndoRedoInProgress.REDO;
    }

    void clearUndoRedoQueue(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            UndoClientState.$$$reportNull$$$0(21);
        }
        this.commandBuilder.assertOutsideCommand();
        this.flushCommandMerger(UndoCommandFlushReason.CLEAR_QUEUE);
        this.undoStacksHolder.clearStacks(Collections.singleton(docRef), false);
        this.redoStacksHolder.clearStacks(Collections.singleton(docRef), false);
    }

    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            UndoClientState.$$$reportNull$$$0(22);
        }
        this.undoStacksHolder.clearDocumentReferences(document2);
        this.redoStacksHolder.clearDocumentReferences(document2);
        this.commandMerger.clearDocumentReferences(document2);
    }

    @Nullable
    PerClientLocalUndoRedoSnapshot getUndoRedoSnapshotForDocument(@NotNull DocumentReference reference) {
        if (reference == null) {
            UndoClientState.$$$reportNull$$$0(23);
        }
        if (this.isInsideCommand() && this.commandBuilder.hasActions()) {
            return null;
        }
        LocalCommandMergerSnapshot mergerSnapshot = this.commandMerger.getSnapshot(reference);
        if (mergerSnapshot == null) {
            return null;
        }
        return new PerClientLocalUndoRedoSnapshot(mergerSnapshot, ((UndoRedoList)this.undoStacksHolder.getStack(reference)).snapshot(), ((UndoRedoList)this.redoStacksHolder.getStack(reference)).snapshot());
    }

    boolean resetLocalHistory(DocumentReference reference, PerClientLocalUndoRedoSnapshot snapshot2) {
        if (this.isInsideCommand() && this.commandBuilder.hasActions()) {
            return false;
        }
        if (!this.commandMerger.resetLocalHistory(snapshot2.getLocalCommandMergerSnapshot())) {
            return false;
        }
        ((UndoRedoList)this.undoStacksHolder.getStack(reference)).resetTo(snapshot2.getUndoStackSnapshot());
        ((UndoRedoList)this.redoStacksHolder.getStack(reference)).resetTo(snapshot2.getRedoStackSnapshot());
        return true;
    }

    @NotNull
    ClientId getClientId() {
        ClientId clientId = this.clientId;
        if (clientId == null) {
            UndoClientState.$$$reportNull$$$0(24);
        }
        return clientId;
    }

    int getStackSize(@Nullable DocumentReference docRef, boolean isUndo) {
        UndoRedoStacksHolder stacks = isUndo ? this.undoStacksHolder : this.redoStacksHolder;
        return stacks.getStackSize(docRef);
    }

    void clearStacks(@Nullable FileEditor editor2) {
        Collection<DocumentReference> refs = UndoDocumentUtil.getDocRefs(editor2);
        if (refs != null) {
            this.flushCommandMerger(UndoCommandFlushReason.CLEAR_STACKS);
            this.redoStacksHolder.clearStacks(new HashSet<DocumentReference>(refs), true);
            this.undoStacksHolder.clearStacks(new HashSet<DocumentReference>(refs), true);
            this.sharedState.trimStacks(refs);
        }
    }

    @NotNull
    String dump(@Nullable FileEditor editor2) {
        String currentMerger = "";
        String merger = this.commandMerger.dumpState();
        Collection<DocumentReference> refs = UndoDocumentUtil.getDocRefs(editor2);
        HashSet<DocumentReference> forEditor = refs == null ? null : new HashSet<DocumentReference>(refs);
        LinkedHashSet<DocumentReference> docRefs = new LinkedHashSet<DocumentReference>();
        if (forEditor != null) {
            docRefs.addAll(forEditor);
            docRefs.addAll(this.commandMerger.getAffectedDocuments());
            docRefs.addAll(this.commandMerger.getAdditionalAffectedDocuments());
            docRefs.addAll(this.undoStacksHolder.getAffectedDocuments(forEditor));
            docRefs.addAll(this.redoStacksHolder.getAffectedDocuments(forEditor));
        } else {
            this.undoStacksHolder.collectAllAffectedDocuments(docRefs);
            this.redoStacksHolder.collectAllAffectedDocuments(docRefs);
        }
        String stacks = docRefs.stream().map(docRef -> this.dump((DocumentReference)docRef, (Collection<DocumentReference>)forEditor)).collect(Collectors.joining("\n"));
        String globalStack = this.dump(null, forEditor);
        String string = "%s\n>>CurrentMerger %s\n>>Merger %s\n%s\n%s".formatted(this.clientId, currentMerger.isEmpty() ? "null" : "\n  " + currentMerger, merger.isEmpty() ? "null" : "\n  " + merger + "\n", stacks, globalStack);
        if (string == null) {
            UndoClientState.$$$reportNull$$$0(25);
        }
        return string;
    }

    @TestOnly
    void dropHistoryInTests() {
        this.commandBuilder.assertOutsideCommand();
        this.undoStacksHolder.clearAllStacksInTests();
        this.redoStacksHolder.clearAllStacksInTests();
    }

    private void flushCommandMerger(@NotNull UndoCommandFlushReason flushReason, @Nullable PerformedCommand performedCommand) {
        UndoableGroup group2;
        UndoSpy undoSpy;
        if (flushReason == null) {
            UndoClientState.$$$reportNull$$$0(26);
        }
        if (performedCommand != null && !performedCommand.hasActions() && this.commandMerger.hasActions() && !this.isUndoOrRedoInProgress() && (undoSpy = UndoSpy.getInstance()) != null) {
            undoSpy.commandMergerFlushed(this.project);
        }
        if ((group2 = this.commandMerger.formGroup(flushReason, this.nextCommandTimestamp())) != null) {
            this.composeStartFinishGroup(group2);
            this.undoStacksHolder.addToStacks(group2);
        }
    }

    private void compactIfNeeded() {
        if (this.isCompactSupported && !this.isUndoOrRedoInProgress() && this.commandTimestamp % 20 == 0) {
            Set<DocumentReference> docsOnStacks = this.collectReferencesWithoutMergers();
            docsOnStacks.removeIf(doc -> UndoDocumentUtil.isDocumentOpened(this.project, doc));
            if (docsOnStacks.size() > 30) {
                DocumentReference doc2;
                DocumentReference[] docsBackSorted = docsOnStacks.toArray(DocumentReference.EMPTY_ARRAY);
                Arrays.sort(docsBackSorted, Comparator.comparingInt(this::getLastCommandTimestamp));
                for (int i2 = 0; i2 < docsBackSorted.length - 30 && this.getLastCommandTimestamp(doc2 = docsBackSorted[i2]) + 100 <= this.commandTimestamp; ++i2) {
                    this.clearUndoRedoQueue(doc2);
                    this.sharedState.trimStacks(Collections.singleton(doc2));
                }
            }
        }
    }

    private void undoOrRedo(@Nullable FileEditor editor2, boolean isUndo) {
        UndoRedo undoRedo;
        this.flushCommandMerger(isUndo ? UndoCommandFlushReason.UNDO : UndoCommandFlushReason.REDO);
        while ((undoRedo = this.createUndoOrRedo(editor2, true)) != null && undoRedo.isTemporary()) {
            if (!undoRedo.execute(true, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        while ((undoRedo = this.createUndoOrRedo(editor2, isUndo)) != null && undoRedo.isTransparent()) {
            if (!undoRedo.execute(false, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        boolean isInsideStartFinishGroup = false;
        while ((undoRedo = this.createUndoOrRedo(editor2, isUndo)) != null) {
            boolean shouldRepeat;
            boolean executed;
            if (editor2 != null && undoRedo.isBlockedByOtherChanges()) {
                UndoRedo splittedUndo;
                UndoRedo blockingChange = this.createUndoOrRedo(null, isUndo);
                if (blockingChange != null && !blockingChange.isSameUndoableGroup(undoRedo)) {
                    if (!undoRedo.confirmSwitchTo(blockingChange)) break;
                    blockingChange.execute(false, true);
                    break;
                }
                if (isUndo && undoRedo.isGlobal() && this.isGlobalSplitEnabled() && undoRedo.splitGlobalCommand() && (splittedUndo = this.createUndoOrRedo(editor2, true)) != null) {
                    undoRedo = splittedUndo;
                }
            }
            if (!(executed = undoRedo.execute(false, isInsideStartFinishGroup))) {
                return;
            }
            if (editor2 != null && !isUndo && this.isGlobalSplitEnabled()) {
                undoRedo.gatherGlobalCommand();
            }
            if ((isInsideStartFinishGroup = undoRedo.isInsideStartFinishGroup(isInsideStartFinishGroup)) || (shouldRepeat = undoRedo.isTransparent() && undoRedo.hasMoreActions())) continue;
            break;
        }
    }

    @Nullable
    private UndoRedo createUndoOrRedo(@Nullable FileEditor editor2, boolean isUndo) {
        if (!this.isUndoRedoAvailable(editor2, isUndo)) {
            return null;
        }
        return isUndo ? new Undo(this.project, editor2, this.undoStacksHolder, this.redoStacksHolder, this.sharedState.getUndoStacks(), this.sharedState.getRedoStacks(), this.isConfirmationSupported, this.isEditorStateRestoreSupported) : new Redo(this.project, editor2, this.undoStacksHolder, this.redoStacksHolder, this.sharedState.getUndoStacks(), this.sharedState.getRedoStacks(), this.isConfirmationSupported, this.isEditorStateRestoreSupported);
    }

    private boolean isGlobalSplitEnabled() {
        return this.isGlobalSplitSupported && Registry.is((String)"ide.undo.fallback");
    }

    @Nullable
    private UndoableGroup getLastAction(@NotNull FileEditor editor2, boolean isUndo) {
        Collection<DocumentReference> refs;
        if (editor2 == null) {
            UndoClientState.$$$reportNull$$$0(27);
        }
        if ((refs = UndoDocumentUtil.getDocRefs(editor2)) == null) {
            return null;
        }
        if (isUndo) {
            this.flushCommandMerger(UndoCommandFlushReason.GET_LAST_GROUP);
        }
        UndoRedoStacksHolder stack = isUndo ? this.undoStacksHolder : this.redoStacksHolder;
        return stack.getLastAction(refs);
    }

    @NotNull
    private Set<DocumentReference> collectReferencesWithoutMergers() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        this.undoStacksHolder.collectAllAffectedDocuments(result2);
        this.redoStacksHolder.collectAllAffectedDocuments(result2);
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoClientState.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    @NotNull
    private Set<DocumentReference> clearStacks() {
        HashSet<DocumentReference> affected = new HashSet<DocumentReference>();
        this.flushCommandMerger(UndoCommandFlushReason.CLEAR_STACKS);
        this.redoStacksHolder.collectAllAffectedDocuments(affected);
        this.redoStacksHolder.clearStacks(affected, true);
        this.undoStacksHolder.collectAllAffectedDocuments(affected);
        this.undoStacksHolder.clearStacks(affected, true);
        HashSet<DocumentReference> hashSet = affected;
        if (hashSet == null) {
            UndoClientState.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    private boolean isUndoOrRedoInProgress() {
        return this.undoRedoInProgress != UndoRedoInProgress.NONE;
    }

    private int nextCommandTimestamp() {
        return ++this.commandTimestamp;
    }

    private int getLastCommandTimestamp(@NotNull DocumentReference doc) {
        if (doc == null) {
            UndoClientState.$$$reportNull$$$0(30);
        }
        return Math.max(this.undoStacksHolder.getLastCommandTimestamp(doc), this.redoStacksHolder.getLastCommandTimestamp(doc));
    }

    private void composeStartFinishGroup(@NotNull UndoableGroup createdGroup) {
        FinishMarkAction finishMark;
        if (createdGroup == null) {
            UndoClientState.$$$reportNull$$$0(31);
        }
        if ((finishMark = createdGroup.getFinishMark()) != null) {
            boolean global = false;
            String commandName = null;
            UndoRedoList stack = (UndoRedoList)this.undoStacksHolder.getStack(finishMark.getAffectedDocument());
            Iterator iterator2 = stack.descendingIterator();
            while (iterator2.hasNext()) {
                UndoableGroup group2 = (UndoableGroup)iterator2.next();
                if (group2.isGlobal()) {
                    global = true;
                    commandName = group2.getCommandName();
                    break;
                }
                if (group2.getStartMark() == null) continue;
                break;
            }
            if (global) {
                finishMark.setGlobal(true);
                finishMark.setCommandName(commandName);
            }
        }
    }

    @NotNull
    private String dump(@Nullable DocumentReference docRef, @Nullable Collection<DocumentReference> editorRefs) {
        String s = docRef == null ? "Global" : docRef.toString();
        String redo = this.redoStacksHolder.dump(docRef);
        String undo = this.undoStacksHolder.dump(docRef);
        String inEditor = docRef != null && editorRefs != null && editorRefs.contains(docRef) ? "inEditor" : "";
        String string = ">>%s %s\n%s\n%s\n".formatted(s, inEditor, redo, undo);
        if (string == null) {
            UndoClientState.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 25, 28, 29, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRefs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeUndoRedoStarted";
                break;
            }
            case 7: 
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdEvent";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performedCommand";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushReason";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoClientState";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoClientState";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientId";
                break;
            }
            case 25: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencesWithoutMergers";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "clearStacks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUndoRedoAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "undoOrRedo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNextNanoTime";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNextAskConfirmation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commitCommand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notifyUndoSpy";
                break;
            }
            case 14: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "flushCommandMerger";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addUndoableAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentAsAffected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUndoRedoSnapshotForDocument";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLastAction";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "composeStartFinishGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 25, 28, 29, 32 -> new IllegalStateException(string);
        };
    }

    private static enum UndoRedoInProgress {
        NONE,
        UNDO,
        REDO;

    }
}

