/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.MovementAvailability;
import com.intellij.openapi.command.impl.SharedUndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProblemReport;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.impl.UndoableGroupOriginalContext;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.ImmutableActionChangeRange;
import com.intellij.openapi.command.undo.MutableActionChangeRange;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class UndoRedo {
    @Nullable
    private final Project project;
    @Nullable
    private final FileEditor editor;
    @NotNull
    private final UndoRedoStacksHolder stacksHolder;
    @NotNull
    private final UndoRedoStacksHolder stacksHolderReversed;
    @NotNull
    private final SharedUndoRedoStacksHolder sharedStacksHolder;
    @NotNull
    private final SharedUndoRedoStacksHolder sharedStacksHolderReversed;
    @NotNull
    private final UndoProblemReport undoProblemReport;
    @NotNull
    protected final UndoableGroup undoableGroup;
    private final boolean isConfirmationSupported;
    private final boolean isEditorStateRestoreSupported;
    private final boolean isRedo;

    protected UndoRedo(@Nullable Project project2, @Nullable FileEditor editor2, @NotNull UndoRedoStacksHolder stacksHolder, @NotNull UndoRedoStacksHolder stacksHolderReversed, @NotNull SharedUndoRedoStacksHolder sharedStacksHolder, @NotNull SharedUndoRedoStacksHolder sharedStacksHolderReversed, boolean isConfirmationSupported, boolean isEditorStateRestoreSupported, boolean isRedo) {
        if (stacksHolder == null) {
            UndoRedo.$$$reportNull$$$0(0);
        }
        if (stacksHolderReversed == null) {
            UndoRedo.$$$reportNull$$$0(1);
        }
        if (sharedStacksHolder == null) {
            UndoRedo.$$$reportNull$$$0(2);
        }
        if (sharedStacksHolderReversed == null) {
            UndoRedo.$$$reportNull$$$0(3);
        }
        this.project = project2;
        this.editor = editor2;
        this.stacksHolder = stacksHolder;
        this.stacksHolderReversed = stacksHolderReversed;
        this.sharedStacksHolder = sharedStacksHolder;
        this.sharedStacksHolderReversed = sharedStacksHolderReversed;
        this.isConfirmationSupported = isConfirmationSupported;
        this.isEditorStateRestoreSupported = isEditorStateRestoreSupported;
        this.isRedo = isRedo;
        this.undoProblemReport = new UndoProblemReport(project2, isRedo);
        this.undoableGroup = Objects.requireNonNull(stacksHolder.getLastAction(this.getDocRefs()), "undo is not available");
    }

    @NlsContexts.DialogTitle
    protected abstract String getActionName();

    @NlsContexts.DialogMessage
    protected abstract String getActionName(String var1);

    @Nullable
    protected abstract EditorAndState getBeforeState();

    @Nullable
    protected abstract EditorAndState getAfterState();

    protected abstract void performAction() throws UnexpectedUndoException;

    protected abstract void setBeforeState(@NotNull EditorAndState var1);

    boolean isGlobal() {
        return this.undoableGroup.isGlobal();
    }

    boolean isTransparent() {
        return this.undoableGroup.isTransparent();
    }

    boolean isTemporary() {
        return this.undoableGroup.isTemporary();
    }

    boolean hasMoreActions() {
        return this.stacksHolder.canBeUndoneOrRedone(this.getDocRefs());
    }

    boolean execute(boolean drop2, boolean disableConfirmation) {
        Collection<Document> readOnlyDocuments;
        Collection<VirtualFile> readOnlyFiles;
        EditorAndState stateToRestore;
        FileEditorState restoredState;
        if (!this.undoableGroup.isUndoable()) {
            String operationName = Objects.requireNonNull(CommandProcessor.getInstance().getCurrentCommandName(), "performing undo/redo operation outside command context");
            this.undoProblemReport.reportNonUndoable(operationName, this.undoableGroup.getAffectedDocuments());
            return false;
        }
        Set<DocumentReference> clashing = this.stacksHolder.collectClashingActions(this.undoableGroup);
        if (!clashing.isEmpty()) {
            this.undoProblemReport.reportClashingDocuments(clashing);
            return false;
        }
        Map<DocumentReference, Map<Integer, MutableActionChangeRange>> reference2Ranges = UndoRedo.decompose(this.undoableGroup, this.isRedo);
        boolean shouldMove = false;
        for (Map.Entry<DocumentReference, Map<Integer, MutableActionChangeRange>> entry : reference2Ranges.entrySet()) {
            Object availability = this.sharedStacksHolder.canMoveToStackTop(entry.getKey(), entry.getValue());
            if (availability == MovementAvailability.CANNOT_MOVE) {
                this.undoProblemReport.reportCannotAdjust(Collections.singleton(entry.getKey()));
                return false;
            }
            if (availability != MovementAvailability.CAN_MOVE) continue;
            shouldMove = true;
        }
        if (!disableConfirmation && this.isConfirmationSupported && this.undoableGroup.shouldAskConfirmation(this.isRedo) && !UndoRedo.isNeverAskUser()) {
            if (!this.askUser()) {
                return false;
            }
        } else if (!shouldMove && this.editor != null && (restoredState = this.restore(stateToRestore = this.getBeforeState(), true)) != null) {
            this.setBeforeState(new EditorAndState(this.editor, restoredState));
            if (!this.isCaretMovementUndoTransparent()) {
                return true;
            }
        }
        if (!(readOnlyFiles = UndoDocumentUtil.collectReadOnlyAffectedFiles(this.undoableGroup.getActions())).isEmpty()) {
            if (this.project == null) {
                return false;
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)this.project).ensureFilesWritable(readOnlyFiles);
            if (operationStatus.hasReadonlyFiles()) {
                return false;
            }
        }
        if (!(readOnlyDocuments = UndoDocumentUtil.collectReadOnlyDocuments(this.undoableGroup.getActions())).isEmpty()) {
            for (Document document2 : readOnlyDocuments) {
                document2.fireReadOnlyModificationAttempt();
            }
            return false;
        }
        if (shouldMove) {
            for (Map.Entry entry : reference2Ranges.entrySet()) {
                ImmutableActionChangeRange[] affected = this.sharedStacksHolder.moveToStackTop((DocumentReference)entry.getKey(), (Map)entry.getValue());
                if (affected == null) continue;
                for (ImmutableActionChangeRange range : affected) {
                    MutableActionChangeRange mutableRange = (MutableActionChangeRange)((Map)entry.getValue()).get(range.getId());
                    if (mutableRange == null) continue;
                    mutableRange.setState(range);
                }
            }
        }
        this.stacksHolder.removeFromStacks(this.undoableGroup);
        if (!drop2) {
            this.stacksHolderReversed.addToStacks(this.undoableGroup);
        }
        for (Map.Entry entry : reference2Ranges.entrySet()) {
            DocumentReference reference = (DocumentReference)entry.getKey();
            int rangeCount = ((Map)entry.getValue()).size();
            for (int i2 = 0; i2 < rangeCount; ++i2) {
                ImmutableActionChangeRange changeRange = this.sharedStacksHolder.removeLastFromStack(reference);
                ImmutableActionChangeRange inverted = changeRange.asInverted().toImmutable(drop2);
                this.sharedStacksHolderReversed.addToStack(reference, inverted);
            }
        }
        try {
            this.performAction();
        }
        catch (UnexpectedUndoException e) {
            this.undoProblemReport.reportException(e);
            return false;
        }
        if (!shouldMove) {
            this.restore(this.getAfterState(), false);
        }
        return true;
    }

    boolean isInsideStartFinishGroup(boolean isInsideStartFinishGroup) {
        return this.undoableGroup.isInsideStartFinishGroup(!this.isRedo, isInsideStartFinishGroup);
    }

    boolean isBlockedByOtherChanges() {
        return this.undoableGroup.isGlobal() && this.undoableGroup.isUndoable() && !this.stacksHolder.collectClashingActions(this.undoableGroup).isEmpty();
    }

    boolean splitGlobalCommand() {
        if (this.isRedo) {
            throw new IllegalStateException("splitGlobalCommand is allowed only for Undo but current operation is Redo");
        }
        Collection<DocumentReference> refs = this.getDocRefs();
        if (refs == null || refs.size() != 1) {
            return false;
        }
        DocumentReference docRef = refs.iterator().next();
        UndoRedoList stack = (UndoRedoList)this.stacksHolder.getStack(docRef);
        if (stack.getLast() == this.undoableGroup) {
            Pair<List<UndoableAction>, List<UndoableAction>> actions = UndoDocumentUtil.separateLocalAndNonLocalActions(this.undoableGroup.getActions(), docRef);
            List localActions = (List)actions.getFirst();
            List nonLocalActions = (List)actions.getSecond();
            if (localActions.isEmpty()) {
                return false;
            }
            stack.removeLast();
            UndoableGroup replacingGroup = new UndoableGroup(this.undoableGroup.getCommandIds(), IdeBundle.message((String)"undo.command.local.name", (Object[])new Object[0]) + this.undoableGroup.getCommandName(), localActions, this.undoableGroup.getConfirmationPolicy(), this.undoableGroup.getStateBefore(), this.undoableGroup.getStateAfter(), null, this.undoableGroup.getCommandTimestamp(), this.undoableGroup.isLocalHistoryActivity(), this.undoableGroup.isTransparent(), false, this.undoableGroup.isValid());
            stack.add(replacingGroup);
            UndoableGroup groupWithoutLocalChanges = new UndoableGroup(this.undoableGroup.getCommandIds(), this.undoableGroup.getCommandName(), nonLocalActions, this.undoableGroup.getConfirmationPolicy(), this.undoableGroup.getStateBefore(), this.undoableGroup.getStateAfter(), null, this.undoableGroup.getCommandTimestamp(), this.undoableGroup.isLocalHistoryActivity(), this.undoableGroup.isTransparent(), this.undoableGroup.isGlobal(), this.undoableGroup.isValid());
            if (this.stacksHolder.replaceOnStacks(this.undoableGroup, groupWithoutLocalChanges)) {
                replacingGroup.setOriginalContext(new UndoableGroupOriginalContext(this.undoableGroup, groupWithoutLocalChanges));
            }
            return true;
        }
        return false;
    }

    void gatherGlobalCommand() {
        if (!this.isRedo) {
            throw new IllegalStateException("gatherGlobalCommand is allowed only for Redo but current operation is Undo");
        }
        UndoableGroupOriginalContext context2 = this.undoableGroup.getOriginalContext();
        if (context2 == null) {
            return;
        }
        Collection<DocumentReference> refs = this.getDocRefs();
        if (refs.size() > 1) {
            return;
        }
        UndoRedoStacksHolder undoStacksHolder = this.stacksHolderReversed;
        DocumentReference docRef = refs.iterator().next();
        UndoRedoList undoStack = (UndoRedoList)undoStacksHolder.getStack(docRef);
        if (undoStack.getLast() != this.undoableGroup) {
            return;
        }
        boolean shouldGatherGroup = undoStacksHolder.replaceOnStacks(context2.currentStackGroup(), context2.originalGroup());
        if (!shouldGatherGroup) {
            return;
        }
        undoStack.removeLast();
        undoStack.add(context2.originalGroup());
    }

    boolean isSameUndoableGroup(@NotNull UndoRedo otherUndoRedo) {
        if (otherUndoRedo == null) {
            UndoRedo.$$$reportNull$$$0(4);
        }
        return this.undoableGroup == otherUndoRedo.undoableGroup;
    }

    boolean confirmSwitchTo(@NotNull UndoRedo other) {
        if (other == null) {
            UndoRedo.$$$reportNull$$$0(5);
        }
        String message = IdeBundle.message((String)"undo.conflicting.change.confirmation", (Object[])new Object[0]) + "\n" + this.getActionName(other.undoableGroup.getCommandName()) + "?";
        return this.showDialog(message);
    }

    private boolean askUser() {
        return this.showDialog(this.getActionName(this.undoableGroup.getCommandName()) + "?");
    }

    private boolean showDialog(@NlsContexts.DialogMessage @NotNull String message) {
        if (message == null) {
            UndoRedo.$$$reportNull$$$0(6);
        }
        return 0 == Messages.showOkCancelDialog((Project)this.project, (String)message, (String)this.getActionName(), (Icon)Messages.getQuestionIcon());
    }

    private static boolean isNeverAskUser() {
        return UndoManagerImpl.ourNeverAskUser;
    }

    @Nullable
    private FileEditorState restore(@Nullable EditorAndState pair, boolean onlyIfDiffers) {
        if (pair == null || this.editor == null || !this.editor.isValid() || !pair.canBeAppliedTo(this.editor)) {
            return null;
        }
        FileEditorState stateToRestore = pair.getState();
        FileEditorState currentState = this.editor.getState(FileEditorStateLevel.UNDO);
        if (onlyIfDiffers && currentState.equals((Object)stateToRestore)) {
            return null;
        }
        this.editor.setState(stateToRestore);
        FileEditorState newState = this.editor.getState(FileEditorStateLevel.UNDO);
        return newState.equals((Object)stateToRestore) ? newState : null;
    }

    private Collection<DocumentReference> getDocRefs() {
        return this.editor == null ? Collections.emptySet() : UndoDocumentUtil.getDocumentReferences(this.editor);
    }

    public String toString() {
        return (this.isRedo ? "Redo" : "Undo") + "{" + String.valueOf(this.undoableGroup) + "}";
    }

    @NotNull
    private static Map<DocumentReference, Map<Integer, MutableActionChangeRange>> decompose(@NotNull UndoableGroup group2, boolean isRedo) {
        if (group2 == null) {
            UndoRedo.$$$reportNull$$$0(7);
        }
        HashMap<DocumentReference, Map<Integer, MutableActionChangeRange>> reference2Ranges = new HashMap<DocumentReference, Map<Integer, MutableActionChangeRange>>();
        for (UndoableAction undoableAction : group2.getActions()) {
            AdjustableUndoableAction adjustable;
            DocumentReference[] affected;
            if (!(undoableAction instanceof AdjustableUndoableAction) || (affected = (adjustable = (AdjustableUndoableAction)undoableAction).getAffectedDocuments()) == null) continue;
            for (DocumentReference reference : affected) {
                Map savedChangeRanges = reference2Ranges.computeIfAbsent(reference, r -> new HashMap());
                for (MutableActionChangeRange changeRange : adjustable.getChangeRanges(reference)) {
                    MutableActionChangeRange range = isRedo ? changeRange.asInverted() : changeRange;
                    savedChangeRanges.put(range.getId(), range);
                }
            }
        }
        HashMap<DocumentReference, Map<Integer, MutableActionChangeRange>> hashMap = reference2Ranges;
        if (hashMap == null) {
            UndoRedo.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private boolean isCaretMovementUndoTransparent() {
        return Registry.is((String)"ide.undo.transparent.caret.movement") || AdvancedSettings.getBoolean((String)"editor.undo.transparent.caret.movement") || !this.isEditorStateRestoreSupported;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacksHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacksHolderReversed";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedStacksHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedStacksHolderReversed";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherUndoRedo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "decompose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSameUndoableGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "confirmSwitchTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decompose";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

