/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

final class CutLineActionHandler
extends EditorWriteActionHandler.ForEachCaret {
    private final boolean myToLineStart;

    CutLineActionHandler(boolean toLineStart) {
        this.myToLineStart = toLineStart;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        int end;
        int start2;
        if (editor2 == null) {
            CutLineActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            CutLineActionHandler.$$$reportNull$$$0(1);
        }
        if (caret.hasSelection()) {
            CutLineActionHandler.delete(editor2, caret, caret.getSelectionStart(), caret.getSelectionEnd());
            return;
        }
        Document doc = editor2.getDocument();
        int caretOffset = caret.getOffset();
        if (this.myToLineStart && caretOffset == 0 || !this.myToLineStart && caretOffset >= doc.getTextLength()) {
            return;
        }
        int lineNumber = doc.getLineNumber(caretOffset);
        int lineEndOffset = doc.getLineEndOffset(lineNumber);
        int lineStartOffset = doc.getLineStartOffset(lineNumber);
        if (this.myToLineStart) {
            start2 = caret.getLogicalPosition().column == 0 ? lineStartOffset - 1 : lineStartOffset;
            end = caretOffset;
        } else if (caretOffset >= lineEndOffset) {
            start2 = lineEndOffset;
            end = lineEndOffset + 1;
        } else {
            start2 = caretOffset;
            end = lineEndOffset;
            if (lineEndOffset < doc.getTextLength() && CharArrayUtil.isEmptyOrSpaces((CharSequence)doc.getCharsSequence(), (int)caretOffset, (int)lineEndOffset)) {
                ++end;
            }
        }
        CutLineActionHandler.delete(editor2, caret, start2, end);
    }

    private static void delete(@NotNull Editor editor2, @NotNull Caret caret, int start2, int end) {
        if (editor2 == null) {
            CutLineActionHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            CutLineActionHandler.$$$reportNull$$$0(3);
        }
        CopyPasteManager.getInstance().stopKillRings();
        editor2.getDocument().deleteString(start2, end);
        caret.moveToOffset(start2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/CutLineActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

