/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.TargetUIType;
import com.intellij.ide.ui.ThemeListProvider;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoKt;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.openapi.editor.colors.EditorColorSchemesSorter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.ui.ExperimentalUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\rH\u0002J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\rH\u0002J4\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/editor/colors/impl/EditorColorSchemesSorterImpl;", "Lcom/intellij/openapi/editor/colors/EditorColorSchemesSorter;", "<init>", "()V", "getOrderedSchemes", "Lcom/intellij/openapi/editor/colors/Groups;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "schemesMap", "", "", "filterOutRedundantSchemes", "", "schemes", "", "findSchemesFromThemes", "", "themes", "", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfo;", "findAndAddToSchemesGroup", "schemeId", "source", "destination", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEditorColorSchemesSorterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorColorSchemesSorterImpl.kt\ncom/intellij/openapi/editor/colors/impl/EditorColorSchemesSorterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n216#3,2:121\n1011#4,2:123\n1869#4,2:125\n1869#4:127\n1869#4,2:128\n1870#4:130\n*S KotlinDebug\n*F\n+ 1 EditorColorSchemesSorterImpl.kt\ncom/intellij/openapi/editor/colors/impl/EditorColorSchemesSorterImpl\n*L\n44#1:121,2\n56#1:123,2\n82#1:125,2\n93#1:127\n97#1:128,2\n93#1:130\n*E\n"})
public final class EditorColorSchemesSorterImpl
implements EditorColorSchemesSorter {
    @NotNull
    public Groups<EditorColorsScheme> getOrderedSchemes(@NotNull Map<String, ? extends EditorColorsScheme> schemesMap) {
        Object[] it;
        Object object;
        List groupInfos;
        Map unhandledSchemes;
        block12: {
            block11: {
                Map map2;
                Intrinsics.checkNotNullParameter(schemesMap, (String)"schemesMap");
                Map it2 = map2 = MapsKt.toMutableMap(schemesMap);
                boolean bl = false;
                this.filterOutRedundantSchemes(it2);
                unhandledSchemes = map2;
                groupInfos = new ArrayList();
                object = (Groups.GroupInfo)CollectionsKt.firstOrNull((List)ThemeListProvider.Companion.getInstance().getShownThemes().getInfos());
                if (object == null || (object = object.getItems()) == null) break block11;
                it = object;
                boolean bl2 = false;
                List<EditorColorsScheme> list2 = this.findSchemesFromThemes((List<? extends UIThemeLookAndFeelInfo>)it, unhandledSchemes);
                object = list2;
                if (list2 != null) break block12;
            }
            object = CollectionsKt.emptyList();
        }
        Object schemesFirstGroup = object;
        List bundledSchemesFromThemes = CollectionsKt.emptyList();
        if (ExperimentalUI.Companion.isNewUI()) {
            if (!((Collection)schemesFirstGroup).isEmpty()) {
                groupInfos.add(new Groups.GroupInfo((List)schemesFirstGroup, null, 2, null));
            }
        } else {
            bundledSchemesFromThemes = schemesFirstGroup;
        }
        List bundledSchemes = new ArrayList();
        List customSchemes = new ArrayList();
        it = new String[]{"Darcula", "Darcula Contrast", "IntelliJ Light", "Default"};
        Set oldBundledSchemeNames = SetsKt.setOf((Object[])it);
        Map $this$forEach$iv = unhandledSchemes;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String baseName;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            EditorColorsScheme scheme = (EditorColorsScheme)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)Scheme.getBaseName((String)scheme.getName()), (String)"getBaseName(...)");
            EditorColorsScheme originalScheme = EditorColorsManager.getInstance().getScheme(baseName);
            EditorColorsSchemeImpl editorColorsSchemeImpl = originalScheme instanceof EditorColorsSchemeImpl ? (EditorColorsSchemeImpl)originalScheme : null;
            boolean bl3 = (editorColorsSchemeImpl != null ? editorColorsSchemeImpl.isFromIntellij() : false) || oldBundledSchemeNames.contains(baseName) ? bundledSchemes.add(scheme) : customSchemes.add(scheme);
        }
        List $this$sortBy$iv = bundledSchemes;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    EditorColorsScheme it = (EditorColorsScheme)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (EditorColorsScheme)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
                }
            });
        }
        bundledSchemes.addAll(0, bundledSchemesFromThemes);
        if (!((Collection)bundledSchemes).isEmpty()) {
            groupInfos.add(new Groups.GroupInfo(bundledSchemes, null, 2, null));
        }
        if (!((Collection)customSchemes).isEmpty()) {
            EditorColorSchemesComparator editorColorSchemesComparator = EditorColorSchemesComparator.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorSchemesComparator, (String)"INSTANCE");
            CollectionsKt.sortWith((List)customSchemes, (Comparator)editorColorSchemesComparator);
            groupInfos.add(new Groups.GroupInfo(customSchemes, IdeBundle.message((String)"combobox.list.custom.section.title", (Object[])new Object[0])));
        }
        return new Groups(groupInfos);
    }

    private final void filterOutRedundantSchemes(Map<String, EditorColorsScheme> schemes) {
        List schemesToFilterOut = new ArrayList();
        if (!ExperimentalUI.Companion.isNewUI()) {
            Sequence newUiSchemeIds = SequencesKt.mapNotNull(UiThemeProviderListManager.Companion.getInstance().getThemeListForTargetUI(TargetUIType.NEW), EditorColorSchemesSorterImpl::filterOutRedundantSchemes$lambda$0);
            CollectionsKt.addAll((Collection)schemesToFilterOut, (Sequence)newUiSchemeIds);
        }
        Iterable $this$forEach$iv = schemesToFilterOut;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            schemes.remove(it);
            schemes.remove("_@user_" + it);
        }
    }

    private final List<EditorColorsScheme> findSchemesFromThemes(List<? extends UIThemeLookAndFeelInfo> themes, Map<String, EditorColorsScheme> schemes) {
        List result2 = new ArrayList();
        Object[] objectArray = new String[]{"Darcula", "Darcula Contrast"};
        Set darculaFamilyNames = SetsKt.setOf((Object[])objectArray);
        Iterable $this$forEach$iv = themes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIThemeLookAndFeelInfo theme = (UIThemeLookAndFeelInfo)element$iv;
            boolean bl = false;
            String schemeId = UIThemeLookAndFeelInfoKt.getDefaultSchemeName((UIThemeLookAndFeelInfo)theme);
            if (darculaFamilyNames.contains(schemeId)) {
                Iterable $this$forEach$iv2 = darculaFamilyNames;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String darculaSchemeName = (String)element$iv2;
                    boolean bl2 = false;
                    this.findAndAddToSchemesGroup(darculaSchemeName, schemes, result2);
                }
                continue;
            }
            this.findAndAddToSchemesGroup(schemeId, schemes, result2);
        }
        return result2;
    }

    private final void findAndAddToSchemesGroup(String schemeId, Map<String, EditorColorsScheme> source, List<EditorColorsScheme> destination) {
        block2: {
            EditorColorsScheme editorColorsScheme;
            if (schemeId == null) break block2;
            String it = schemeId;
            boolean bl = false;
            EditorColorsScheme editorColorsScheme2 = source.get(schemeId);
            if (editorColorsScheme2 == null) {
                editorColorsScheme2 = source.get("_@user_" + schemeId);
            }
            if ((editorColorsScheme = editorColorsScheme2) != null) {
                EditorColorsScheme scheme = editorColorsScheme;
                boolean bl2 = false;
                source.remove(scheme.getName());
                destination.add(scheme);
            }
        }
    }

    private static final String filterOutRedundantSchemes$lambda$0(UIThemeLookAndFeelInfo theme) {
        String string;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        String it = string = UIThemeLookAndFeelInfoKt.getDefaultSchemeName((UIThemeLookAndFeelInfo)theme);
        boolean bl = false;
        return !UIThemeLookAndFeelInfoKt.isThemeFromPlugin((UIThemeLookAndFeelInfo)theme) ? string : null;
    }
}

