/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessibleGutterLine
extends JPanel {
    private final EditorGutterComponentImpl myGutter;
    private AccessibleGutterElement mySelectedElement;
    private final int myLogicalLineNum;
    private final int myVisualLineNum;
    private static boolean actionHandlerInstalled;

    @NotNull
    private static AccessibleGutterLine createAndActivate(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(0);
        }
        return new AccessibleGutterLine(gutter);
    }

    void escape(boolean requestFocusToEditor) {
        this.myGutter.remove(this);
        this.myGutter.repaint();
        this.myGutter.setCurrentAccessibleLine(null);
        if (requestFocusToEditor) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myGutter.getEditor().getContentComponent(), true);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.mySelectedElement.paint(g);
    }

    static void installListeners(final @NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(1);
        }
        if (!actionHandlerInstalled) {
            actionHandlerInstalled = true;
            EditorActionManager.getInstance().setActionHandler("EditorShowGutterIconTooltip", new EditorActionHandler(){

                protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
                    AccessibleGutterLine line;
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((line = ((EditorGutterComponentImpl)editor2.getGutter()).getCurrentAccessibleLine()) != null) {
                        line.showTooltipIfPresent();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/AccessibleGutterLine$1", "doExecute"));
                }
            });
        }
        gutter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                gutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(gutter));
            }
        });
        gutter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                gutter.escapeCurrentAccessibleLine();
            }
        });
        gutter.getEditor().getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                AccessibleGutterLine line;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((line = gutter.getCurrentAccessibleLine()) != null) {
                    line.maybeLineChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/AccessibleGutterLine$4", "caretPositionChanged"));
            }
        });
    }

    private void moveRight() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentAfter(this, this.mySelectedElement), true);
    }

    @NotNull
    private static AnActionEvent convertAnActionEventToMouseAnActionEvent(@NotNull AnActionEvent e, @NotNull Component component2) {
        if (e == null) {
            AccessibleGutterLine.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            AccessibleGutterLine.$$$reportNull$$$0(3);
        }
        int x = component2.getX() + component2.getWidth() / 2;
        int y = component2.getY() + component2.getHeight() / 2;
        return new AnActionEvent((InputEvent)new MouseEvent(component2, 500, 0L, 0, x, y, 1, false), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
    }

    private void pressEnter(AnActionEvent e) {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner instanceof AccessibleGutterElement) {
            ((AccessibleGutterElement)focusOwner).myAccessible.performAction(AccessibleGutterLine.convertAnActionEventToMouseAnActionEvent(e, focusOwner));
        }
    }

    private void moveLeft() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentBefore(this, this.mySelectedElement), true);
    }

    private void showTooltipIfPresent() {
        this.mySelectedElement.showTooltip();
    }

    private AccessibleGutterLine(@NotNull EditorGutterComponentImpl gutter) {
        if (gutter == null) {
            AccessibleGutterLine.$$$reportNull$$$0(4);
        }
        super(null);
        EditorImpl editor2 = gutter.getEditor();
        int lineHeight = editor2.getLineHeight();
        this.myGutter = gutter;
        this.myLogicalLineNum = editor2.getCaretModel().getPrimaryCaret().getLogicalPosition().line;
        this.myVisualLineNum = editor2.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (this.myGutter.isLineNumbersShown()) {
            this.addNewElement(new MySimpleAccessible(){

                @NotNull
                public String getAccessibleName() {
                    String string = IdeBundle.message((String)"accessible.name.line", (Object[])new Object[]{AccessibleGutterLine.this.myLogicalLineNum + 1});
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getAccessibleTooltipText() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$5", "getAccessibleName"));
                }
            }, this.myGutter.getLineNumberAreaOffset(), 0, this.myGutter.getLineNumberAreaWidth(), lineHeight);
        }
        if (this.myGutter.isAnnotationsShown()) {
            int x2 = this.myGutter.getAnnotationsAreaOffset();
            AtomicInteger width = new AtomicInteger();
            AtomicReference tooltipText = new AtomicReference();
            final StringBuilder buf = new StringBuilder();
            this.myGutter.processTextAnnotationGutterProviders((gutterProvider, annotationSize) -> {
                if (tooltipText.get() == null) {
                    tooltipText.set(gutterProvider.getToolTip(this.myLogicalLineNum, (Editor)editor2));
                }
                buf.append((String)ObjectUtils.notNull((Object)gutterProvider.getLineText(this.myLogicalLineNum, (Editor)editor2), (Object)""));
                width.getAndAdd((int)annotationSize);
            });
            if (!buf.isEmpty()) {
                final String tt = (String)tooltipText.get();
                this.addNewElement(new MySimpleAccessible(){

                    @NotNull
                    public String getAccessibleName() {
                        String string = IdeBundle.message((String)"accessible.name.annotation", (Object[])new Object[]{buf.toString()});
                        if (string == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public String getAccessibleTooltipText() {
                        return tt;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$6", "getAccessibleName"));
                    }
                }, x2, 0, width.get(), lineHeight);
            }
        }
        if (this.myGutter.areIconsShown()) {
            List<GutterMark> row2 = this.myGutter.getGutterRenderers(this.myVisualLineNum);
            this.myGutter.processIconsRow(this.myVisualLineNum, row2, (x, y, renderer2) -> {
                Icon icon2 = this.myGutter.scaleIcon(renderer2.getIcon());
                this.addNewElement(new MySimpleAccessible(){
                    final AnAction myAction;
                    {
                        this.myAction = ((GutterIconRenderer)renderer2).getClickAction();
                    }

                    @Override
                    public void performAction(@NotNull AnActionEvent e) {
                        if (e == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        this.myAction.actionPerformed(e);
                    }

                    @NotNull
                    public String getAccessibleName() {
                        if (renderer2 instanceof SimpleAccessible) {
                            String string = ((SimpleAccessible)renderer2).getAccessibleName();
                            if (string == null) {
                                7.$$$reportNull$$$0(1);
                            }
                            return string;
                        }
                        String string = IdeBundle.message((String)"accessible.name.icon", (Object[])new Object[]{renderer2.getClass().getSimpleName()});
                        if (string == null) {
                            7.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    public String getAccessibleTooltipText() {
                        return renderer2.getTooltipText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1, 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$7";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$7";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAccessibleName";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "performAction";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1, 2 -> new IllegalStateException(string);
                        };
                    }
                }, x, 0, icon2.getIconWidth(), lineHeight);
            });
        }
        if (this.myGutter.isLineMarkersShown()) {
            int firstVisibleOffset = editor2.visualLineStartOffset(this.myVisualLineNum);
            int lastVisibleOffset = editor2.visualLineStartOffset(this.myVisualLineNum + 1);
            this.myGutter.processGutterRangeHighlighters(firstVisibleOffset, lastVisibleOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                Rectangle bounds;
                Rectangle rect;
                LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
                if (renderer2 instanceof ActiveGutterRenderer && (rect = this.myGutter.getLineRendererRectangle((RangeHighlighter)highlighter)) != null && (bounds = ((ActiveGutterRenderer)renderer2).calcBounds((Editor)editor2, this.myVisualLineNum, rect)) != null) {
                    this.addNewElement(new MySimpleAccessibleDelegate((SimpleAccessible)((ActiveGutterRenderer)renderer2)), bounds.x, 0, bounds.width, bounds.height);
                }
                return true;
            }));
        }
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setBounds(0, editor2.visualLineToY(this.myVisualLineNum), this.myGutter.getWhitespaceSeparatorOffset(), lineHeight);
        this.myGutter.add(this);
        this.mySelectedElement = (AccessibleGutterElement)this.getFocusTraversalPolicy().getFirstComponent(this);
        if (this.mySelectedElement == null) {
            Rectangle b = this.getBounds();
            this.mySelectedElement = this.addNewElement(new MySimpleAccessible(this){

                @NotNull
                public String getAccessibleName() {
                    String string = IdeBundle.message((String)"accessible.name.empty", (Object[])new Object[0]);
                    if (string == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getAccessibleTooltipText() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/AccessibleGutterLine$8", "getAccessibleName"));
                }
            }, 0, 0, b.width, b.height);
        }
        this.installActionHandler(CommonShortcuts.ESCAPE, () -> this.escape(true));
        this.installActionHandler(CommonShortcuts.ENTER, this::pressEnter);
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_RIGHT, this::moveRight);
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_LEFT, this::moveLeft);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.mySelectedElement, true);
    }

    private void installActionHandler(ShortcutSet shortcut, Runnable action2) {
        DumbAwareAction.create(e -> action2.run()).registerCustomShortcutSet(shortcut, (JComponent)this);
    }

    private void installActionHandler(ShortcutSet shortcut, Consumer<? super AnActionEvent> action2) {
        DumbAwareAction.create(e -> action2.accept((AnActionEvent)e)).registerCustomShortcutSet(shortcut, (JComponent)this);
    }

    @NotNull
    private AccessibleGutterElement addNewElement(@NotNull MySimpleAccessible accessible, int x, int y, int width, int height) {
        if (accessible == null) {
            AccessibleGutterLine.$$$reportNull$$$0(5);
        }
        AccessibleGutterElement obj2 = new AccessibleGutterElement(accessible, new Rectangle(x, y, width, height));
        this.add(obj2);
        AccessibleGutterElement accessibleGutterElement = obj2;
        if (accessibleGutterElement == null) {
            AccessibleGutterLine.$$$reportNull$$$0(6);
        }
        return accessibleGutterElement;
    }

    @Override
    public void removeNotify() {
        this.repaint();
        super.removeNotify();
    }

    private void maybeLineChanged() {
        if (this.myLogicalLineNum == this.myGutter.getEditor().getCaretModel().getPrimaryCaret().getLogicalPosition().line) {
            return;
        }
        this.myGutter.remove(this);
        this.myGutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(this.myGutter));
    }

    @Override
    public void repaint() {
        if (this.myGutter == null) {
            return;
        }
        int y = this.myGutter.getEditor().visualLineToY(this.myVisualLineNum);
        this.myGutter.repaint(0, y, this.myGutter.getWhitespaceSeparatorOffset(), y + this.myGutter.getEditor().getLineHeight());
    }

    private boolean isActive() {
        return this == this.myGutter.getCurrentAccessibleLine();
    }

    static boolean isAccessibleGutterElement(Object element) {
        return element instanceof MySimpleAccessible;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessible";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndActivate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installListeners";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertAnActionEventToMouseAnActionEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNewElement";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private final class AccessibleGutterElement
    extends JLabel {
        @NotNull
        private final MySimpleAccessible myAccessible;

        AccessibleGutterElement(@NotNull MySimpleAccessible accessible, Rectangle bounds) {
            if (accessible == null) {
                AccessibleGutterElement.$$$reportNull$$$0(0);
            }
            if (bounds == null) {
                AccessibleGutterElement.$$$reportNull$$$0(1);
            }
            this.myAccessible = accessible;
            this.setFocusable(true);
            this.setBounds(bounds.x, bounds.y, bounds.width, AccessibleGutterLine.this.myGutter.getEditor().getLineHeight());
            this.setOpaque(false);
            this.setText(this.myAccessible.getAccessibleName());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AccessibleGutterLine.this.mySelectedElement = AccessibleGutterElement.this;
                    AccessibleGutterElement.this.getParent().repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(e.getOppositeComponent() instanceof AccessibleGutterElement) && AccessibleGutterLine.this.isActive()) {
                        AccessibleGutterLine.this.escape(false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (AccessibleGutterLine.this.mySelectedElement != this) {
                return;
            }
            Color oldColor = g.getColor();
            try {
                g.setColor((Color)JBColor.blue);
                Point parentLoc = this.getParent().getLocation();
                Rectangle bounds = this.getBounds();
                bounds.setLocation(parentLoc.x + bounds.x, parentLoc.y + bounds.y);
                int y = bounds.y + bounds.height - JBUIScale.scale((int)1);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)bounds.x, (double)y, (double)(bounds.x + bounds.width), (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)JBUIScale.scale((int)1));
            }
            finally {
                g.setColor(oldColor);
            }
        }

        void showTooltip() {
            if (this.myAccessible.getAccessibleTooltipText() != null) {
                Rectangle bounds = this.getBounds();
                Rectangle pBounds = this.getParent().getBounds();
                int x = pBounds.x + bounds.x + bounds.width / 2;
                int y = pBounds.y + bounds.y + bounds.height / 2;
                AccessibleGutterLine.this.myGutter.showToolTip(this.myAccessible.getAccessibleTooltipText(), new Point(x, y), Balloon.Position.atRight);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JLabel.AccessibleJLabel(){

                    @Override
                    public String getAccessibleName() {
                        return AccessibleGutterElement.this.getText();
                    }
                };
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bounds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$AccessibleGutterElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface MySimpleAccessible
    extends SimpleAccessible {
        default public void performAction(@NotNull AnActionEvent e) {
            if (e == null) {
                MySimpleAccessible.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessible", "performAction"));
        }
    }

    private static final class MyShortcuts {
        static final CustomShortcutSet MOVE_RIGHT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(39, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null)});
        static final CustomShortcutSet MOVE_LEFT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(37, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 64), null)});

        private MyShortcuts() {
        }
    }

    private static final class MySimpleAccessibleDelegate
    implements MySimpleAccessible {
        @NotNull
        private final SimpleAccessible simpleAccessible;

        private MySimpleAccessibleDelegate(@NotNull SimpleAccessible accessible) {
            if (accessible == null) {
                MySimpleAccessibleDelegate.$$$reportNull$$$0(0);
            }
            this.simpleAccessible = accessible;
        }

        @Nls
        @NotNull
        public String getAccessibleName() {
            String string = this.simpleAccessible.getAccessibleName();
            if (string == null) {
                MySimpleAccessibleDelegate.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getAccessibleTooltipText() {
            return this.simpleAccessible.getAccessibleTooltipText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessible";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessibleDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/AccessibleGutterLine$MySimpleAccessibleDelegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

