/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.paint.LinePainter2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ArrowPainter {
    private final ColorProvider myColorHolder;
    private final Computable<Integer> myWidthProvider;
    private final Computable<Integer> myHeightProvider;

    public ArrowPainter(@NotNull ColorProvider colorHolder, @NotNull Computable<Integer> widthProvider, @NotNull Computable<Integer> heightProvider) {
        if (colorHolder == null) {
            ArrowPainter.$$$reportNull$$$0(0);
        }
        if (widthProvider == null) {
            ArrowPainter.$$$reportNull$$$0(1);
        }
        if (heightProvider == null) {
            ArrowPainter.$$$reportNull$$$0(2);
        }
        this.myColorHolder = colorHolder;
        this.myWidthProvider = widthProvider;
        this.myHeightProvider = heightProvider;
    }

    public void paint(Graphics g, int y, int start2, int stop) {
        stop -= (Integer)this.myWidthProvider.compute() / 4;
        Color oldColor = g.getColor();
        g.setColor(this.myColorHolder.getColor());
        int height = (Integer)this.myHeightProvider.compute();
        int halfHeight = height / 2;
        int mid = y - halfHeight;
        int top = y - height;
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)start2, (double)mid, (double)stop, (double)mid);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)stop, (double)y, (double)stop, (double)top);
        g.fillPolygon(new int[]{stop - halfHeight, stop - halfHeight, stop}, new int[]{y, y - height, y - halfHeight}, 3);
        g.setColor(oldColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "colorHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "widthProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "heightProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/ArrowPainter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

