/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    private final RangeMarkerTree<FoldRegionImpl> myMarkerTree;
    @NotNull
    private volatile CachedData myCachedData;
    private static final Comparator<FoldRegion> BY_END_OFFSET = Comparator.comparingInt(RangeMarker::getEndOffset);
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);

    FoldRegionsTree(@NotNull RangeMarkerTree<FoldRegionImpl> markerTree) {
        if (markerTree == null) {
            FoldRegionsTree.$$$reportNull$$$0(0);
        }
        this.myCachedData = new CachedData();
        this.myMarkerTree = markerTree;
    }

    void clear() {
        this.clearCachedValues();
        this.myMarkerTree.clear();
    }

    void clearCachedValues() {
        this.myCachedData = new CachedData();
    }

    void clearCachedInlayValues() {
        this.myCachedData.topFoldedInlaysHeightValid = false;
    }

    protected abstract boolean isFoldingEnabled();

    protected abstract boolean hasBlockInlays();

    protected abstract int getFoldedBlockInlaysHeight(int var1, int var2);

    protected abstract int getLineHeight();

    CachedData rebuild() {
        final ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myMarkerTree.size());
        SweepProcessor.Generator generator2 = processor2 -> this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, processor2);
        SweepProcessor.sweep((SweepProcessor.Generator)generator2, (SweepProcessor)new SweepProcessor<FoldRegionImpl>(this){
            FoldRegionImpl lastCollapsedRegion;

            public boolean process(int offset, @NotNull FoldRegionImpl region, boolean atStart, @NotNull Collection<? extends FoldRegionImpl> overlapping) {
                if (region == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (overlapping == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (atStart && (this.lastCollapsedRegion == null || region.getEndOffset() > this.lastCollapsedRegion.getEndOffset() || region instanceof CustomFoldRegion && region.getStartOffset() == this.lastCollapsedRegion.getStartOffset() && region.getEndOffset() == this.lastCollapsedRegion.getEndOffset())) {
                    if (!region.isExpanded()) {
                        this.hideContainedRegions(region);
                        this.lastCollapsedRegion = region;
                    }
                    visible.add(region);
                }
                return true;
            }

            private void hideContainedRegions(FoldRegion region) {
                for (int i2 = visible.size() - 1; i2 >= 0 && region.getStartOffset() == ((FoldRegion)visible.get(i2)).getStartOffset(); --i2) {
                    visible.remove(i2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "region";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "overlapping";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        return this.updateCachedAndSortOffsets(visibleRegions, true);
    }

    private static FoldRegion @NotNull [] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            FoldRegionsTree.$$$reportNull$$$0(1);
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(FoldRegion.EMPTY_ARRAY);
        if (foldRegionArray == null) {
            FoldRegionsTree.$$$reportNull$$$0(2);
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        CachedData cachedData = this.myCachedData;
        this.updateCachedAndSortOffsets(cachedData.visibleRegions, false);
    }

    private CachedData updateCachedAndSortOffsets(FoldRegion @Nullable [] visibleRegions, boolean fromRebuild) {
        CachedData data2;
        if (!this.isFoldingEnabled()) {
            return null;
        }
        if (visibleRegions == null) {
            return this.rebuild();
        }
        ArrayList<FoldRegion> topLevel = new ArrayList<FoldRegion>(visibleRegions.length / 2);
        for (FoldRegion region : visibleRegions) {
            if (!region.isValid()) {
                if (fromRebuild) {
                    throw new RuntimeExceptionWithAttachments("FoldRegionsTree.rebuild() failed", new Attachment[]{new Attachment("visibleRegions.txt", Arrays.toString(visibleRegions))});
                }
                return this.rebuild();
            }
            if (region.isExpanded()) continue;
            topLevel.add(region);
        }
        FoldRegion[] topLevelRegions = topLevel.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(topLevelRegions, BY_END_OFFSET);
        int[] startOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] endOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] foldedLines = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] customYAdjustment = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int foldedLinesSum = 0;
        int currentCustomYAdjustment = 0;
        int lineHeight = this.getLineHeight();
        for (int i2 = 0; i2 < topLevelRegions.length; ++i2) {
            FoldRegion region = topLevelRegions[i2];
            startOffsets[i2] = region.getStartOffset();
            endOffsets[i2] = region.getEndOffset() - 1;
            Document document2 = region.getDocument();
            foldedLines[i2] = foldedLinesSum += document2.getLineNumber(region.getEndOffset()) - document2.getLineNumber(region.getStartOffset());
            if (region instanceof CustomFoldRegion) {
                currentCustomYAdjustment += ((CustomFoldRegion)region).getHeightInPixels() - lineHeight;
            }
            customYAdjustment[i2] = currentCustomYAdjustment;
        }
        this.myCachedData = data2 = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines, customYAdjustment);
        return data2;
    }

    boolean checkIfValidToCreate(int start2, int end, boolean custom, FoldRegion toIgnore) {
        int length = end - start2;
        return this.myMarkerTree.processOverlappingWith(start2, end, region -> {
            if (region == toIgnore || !region.isValid()) {
                return true;
            }
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            int rLength = rEnd - rStart;
            boolean rCustom = region instanceof CustomFoldRegion;
            int overlapLength = Math.min(end, rEnd) - Math.max(start2, rStart);
            if (overlapLength == 0) {
                return !custom && !rCustom;
            }
            if (overlapLength < length && overlapLength < rLength) {
                return false;
            }
            if (length == rLength) {
                return custom != rCustom;
            }
            return start2 != rStart && end != rEnd || (length < rLength ? !custom || rCustom : !rCustom || custom);
        });
    }

    private CachedData ensureAvailableData() {
        CachedData cachedData = this.myCachedData;
        if (!cachedData.isAvailable() && ApplicationManager.getApplication().isDispatchThread()) {
            return this.rebuild();
        }
        return cachedData;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] starts = cachedData.topStartOffsets;
        int[] ends = cachedData.topEndOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int i2 = ObjectUtils.binarySearch((int)0, (int)ends.length, mid -> ends[mid] < offset ? -1 : (starts[mid] > offset ? 1 : 0));
        return i2 < 0 ? null : cachedData.topLevelRegions[i2];
    }

    FoldRegion @Nullable [] fetchVisible() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.visibleRegions;
    }

    FoldRegion @Nullable [] fetchTopLevel() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.topLevelRegions;
    }

    static boolean containsStrict(@NotNull FoldRegion region, int offset) {
        if (region == null) {
            FoldRegionsTree.$$$reportNull$$$0(3);
        }
        return region.getStartOffset() < offset && offset < region.getEndOffset();
    }

    FoldRegion @NotNull [] fetchCollapsedAt(int offset) {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(4);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        this.myMarkerTree.processContaining(offset, region -> {
            if (!region.isExpanded() && FoldRegionsTree.containsStrict(region, offset)) {
                allCollapsed.add((FoldRegion)region);
            }
            return true;
        });
        return FoldRegionsTree.toFoldArray(allCollapsed);
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        return !this.myMarkerTree.processAll(region -> {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.containsStrict(region, startOffset);
            return contains1 == (contains2 = FoldRegionsTree.containsStrict(region, endOffset));
        });
    }

    FoldRegion @NotNull [] fetchAllRegions() {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(5);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, (Processor)new CommonProcessors.CollectProcessor(regions));
        return FoldRegionsTree.toFoldArray(regions);
    }

    List<FoldRegion> fetchOverlapping(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, (Processor)new CommonProcessors.CollectProcessor(regions));
        return regions;
    }

    private void forEach(@NotNull Consumer<? super FoldRegion> consumer) {
        if (consumer == null) {
            FoldRegionsTree.$$$reportNull$$$0(6);
        }
        this.myMarkerTree.processAll(region -> {
            consumer.consume((Object)region);
            return true;
        });
    }

    int getFoldedLinesCountBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
        if (idx == -1) {
            return 0;
        }
        assert (cachedData.topFoldedLines != null);
        return cachedData.topFoldedLines[idx];
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] foldedLines = cachedData.topFoldedLines;
        if (foldedLines == null || foldedLines.length == 0) {
            return 0;
        }
        return foldedLines[foldedLines.length - 1];
    }

    int getHeightOfFoldedBlockInlaysBefore(int idx) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        if (idx == -1) {
            return 0;
        }
        cachedData.ensureInlayDataAvailable();
        int[] topFoldedInlaysHeight = cachedData.topFoldedInlaysHeight;
        return topFoldedInlaysHeight == null ? 0 : topFoldedInlaysHeight[idx];
    }

    int getTotalHeightOfFoldedBlockInlays() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        cachedData.ensureInlayDataAvailable();
        int[] foldedInlaysHeight = cachedData.topFoldedInlaysHeight;
        return foldedInlaysHeight == null || foldedInlaysHeight.length == 0 ? 0 : foldedInlaysHeight[foldedInlaysHeight.length - 1];
    }

    @NotNull
    IntPair getCustomRegionsYAdjustment(int offset, int idx) {
        if (!this.isFoldingEnabled()) {
            return new IntPair(0, 0);
        }
        CachedData cachedData = this.ensureAvailableData();
        int prevAdjustment = idx == -1 ? 0 : cachedData.topCustomYAdjustment[idx];
        int curAdjustment = idx + 1 < cachedData.topStartOffsets.length && cachedData.topStartOffsets[idx + 1] == offset ? cachedData.topCustomYAdjustment[idx + 1] - prevAdjustment : 0;
        return new IntPair(prevAdjustment, curAdjustment);
    }

    int getLastTopLevelIndexBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return -1;
        }
        CachedData cachedData = this.ensureAvailableData();
        return FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(@NotNull CachedData cachedData, int offset) {
        int i2;
        int[] endOffsets;
        if (cachedData == null) {
            FoldRegionsTree.$$$reportNull$$$0(7);
        }
        if ((endOffsets = cachedData.topEndOffsets) == null) {
            return -1;
        }
        return (i2 = Arrays.binarySearch(endOffsets, --offset)) < 0 ? -i2 - 2 : i2;
    }

    @Nullable
    FoldRegion getRegionAt(int startOffset, int endOffset) {
        FoldRegionImpl[] found = new FoldRegionImpl[]{null};
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, region -> {
            if (region.getStartOffset() == startOffset && region.getEndOffset() == endOffset) {
                found[0] = region;
                return false;
            }
            return true;
        });
        return found[0];
    }

    void clearDocumentRangesModificationStatus() {
        this.forEach((Consumer<? super FoldRegion>)((Consumer)region -> ((FoldRegionImpl)((Object)region)).resetDocumentRegionChanged()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevels";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toFoldArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCollapsedAt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAllRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toFoldArray";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsStrict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLastTopLevelIndexBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class CachedData {
        private final FoldRegion[] visibleRegions;
        private final FoldRegion[] topLevelRegions;
        private final int[] topStartOffsets;
        private final int[] topEndOffsets;
        private final int[] topFoldedLines;
        private final int[] topCustomYAdjustment;
        private int[] topFoldedInlaysHeight;
        private boolean topFoldedInlaysHeightValid;

        private CachedData() {
            this.visibleRegions = null;
            this.topLevelRegions = null;
            this.topStartOffsets = null;
            this.topEndOffsets = null;
            this.topFoldedLines = null;
            this.topCustomYAdjustment = null;
        }

        private CachedData(FoldRegion @NotNull [] visibleRegions, FoldRegion @NotNull [] topLevelRegions, int @NotNull [] topStartOffsets, int @NotNull [] topEndOffsets, int @NotNull [] topFoldedLines, int[] topCustomYAdjustment) {
            if (visibleRegions == null) {
                CachedData.$$$reportNull$$$0(0);
            }
            if (topLevelRegions == null) {
                CachedData.$$$reportNull$$$0(1);
            }
            if (topStartOffsets == null) {
                CachedData.$$$reportNull$$$0(2);
            }
            if (topEndOffsets == null) {
                CachedData.$$$reportNull$$$0(3);
            }
            if (topFoldedLines == null) {
                CachedData.$$$reportNull$$$0(4);
            }
            if (topCustomYAdjustment == null) {
                CachedData.$$$reportNull$$$0(5);
            }
            this.visibleRegions = visibleRegions;
            this.topLevelRegions = topLevelRegions;
            this.topStartOffsets = topStartOffsets;
            this.topEndOffsets = topEndOffsets;
            this.topFoldedLines = topFoldedLines;
            this.topCustomYAdjustment = topCustomYAdjustment;
            this.ensureInlayDataAvailable();
        }

        private boolean isAvailable() {
            return this.visibleRegions != null;
        }

        private void ensureInlayDataAvailable() {
            if (this.topFoldedInlaysHeightValid || !ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            this.topFoldedInlaysHeightValid = true;
            if (FoldRegionsTree.this.hasBlockInlays()) {
                int count = this.topLevelRegions.length;
                this.topFoldedInlaysHeight = ArrayUtil.newIntArray((int)count);
                int inlaysHeightSum = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    this.topFoldedInlaysHeight[i2] = inlaysHeightSum += FoldRegionsTree.this.getFoldedBlockInlaysHeight(this.topStartOffsets[i2], this.topEndOffsets[i2] + 1);
                }
            } else {
                this.topFoldedInlaysHeight = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visibleRegions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topLevelRegions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topStartOffsets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topEndOffsets";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topFoldedLines";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topCustomYAdjustment";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

