/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicate;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/editor/impl/HighlighterFilter;", "", "predicates", "", "Lcom/intellij/openapi/editor/impl/EditorHighlightingPredicate;", "<init>", "([Lcom/intellij/openapi/editor/impl/EditorHighlightingPredicate;)V", "()V", "[Lcom/intellij/openapi/editor/impl/EditorHighlightingPredicate;", "updatePredicate", "predicate", "oldPredicate", "removePredicate", "shouldRender", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHighlighterFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlighterFilter.kt\ncom/intellij/openapi/editor/impl/HighlighterFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n13#2:72\n13#2:79\n81#3,6:73\n12767#4,2:80\n*S KotlinDebug\n*F\n+ 1 HighlighterFilter.kt\ncom/intellij/openapi/editor/impl/HighlighterFilter\n*L\n39#1:72\n61#1:79\n57#1:73,6\n69#1:80,2\n*E\n"})
public final class HighlighterFilter {
    @NotNull
    private EditorHighlightingPredicate[] predicates;

    private HighlighterFilter(EditorHighlightingPredicate[] predicates) {
        this.predicates = predicates;
    }

    public HighlighterFilter() {
        this(new EditorHighlightingPredicate[0]);
    }

    @RequiresEdt
    @Nullable
    public final HighlighterFilter updatePredicate(@NotNull EditorHighlightingPredicate predicate, @Nullable EditorHighlightingPredicate oldPredicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (oldPredicate == null) {
            if (ArraysKt.contains((Object[])this.predicates, (Object)predicate)) {
                return null;
            }
            EditorHighlightingPredicate[] oldPredicates = this.predicates;
            this.predicates = (EditorHighlightingPredicate[])ArraysKt.plus((Object[])this.predicates, (Object)predicate);
            return new HighlighterFilter(oldPredicates);
        }
        int index = ArraysKt.indexOf((Object[])this.predicates, (Object)oldPredicate);
        if (index == -1) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(HighlighterFilter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Predicate " + oldPredicate + " is missing in the list");
            return this.updatePredicate(predicate, null);
        }
        EditorHighlightingPredicate[] oldPredicates = this.predicates;
        EditorHighlightingPredicate[] editorHighlightingPredicateArray = Arrays.copyOf(this.predicates, this.predicates.length);
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlightingPredicateArray, (String)"copyOf(...)");
        EditorHighlightingPredicate[] newPredicates = editorHighlightingPredicateArray;
        newPredicates[index] = predicate;
        this.predicates = newPredicates;
        return new HighlighterFilter(oldPredicates);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    public final HighlighterFilter removePredicate(@NotNull EditorHighlightingPredicate predicate) {
        void elt$iv;
        void $this$remove$iv;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        EditorHighlightingPredicate[] oldPredicates = this.predicates;
        EditorHighlightingPredicate[] editorHighlightingPredicateArray = this.predicates;
        EditorHighlightingPredicate editorHighlightingPredicate = predicate;
        HighlighterFilter highlighterFilter = this;
        boolean $i$f$remove = false;
        int idx$iv = ArraysKt.indexOf((Object[])$this$remove$iv, (Object)elt$iv);
        if (idx$iv == -1) {
            v0 = $this$remove$iv;
        } else {
            int n = ((void)$this$remove$iv).length - 1;
            EditorHighlightingPredicate[] editorHighlightingPredicateArray2 = new EditorHighlightingPredicate[n];
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                editorHighlightingPredicateArray2[n2] = n2 < idx$iv ? $this$remove$iv[n2] : $this$remove$iv[n2 + 1];
            }
            v0 = highlighterFilter.predicates = editorHighlightingPredicateArray2;
        }
        if (oldPredicates == this.predicates) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(HighlighterFilter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Predicate " + predicate + " is missing in the list");
            return null;
        }
        return new HighlighterFilter(oldPredicates);
    }

    public final boolean shouldRender(@NotNull RangeHighlighter highlighter) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            EditorHighlightingPredicate[] $this$all$iv = this.predicates;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                EditorHighlightingPredicate element$iv;
                EditorHighlightingPredicate it = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (it.shouldRender(highlighter)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }
}

