/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.configurable;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.stickyLines.configurable.StickyLinesProviderConfigurable;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.builder.UtilsKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u00100\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/configurable/StickyLinesConfigurableUI;", "", "configurables", "", "Lcom/intellij/openapi/editor/impl/stickyLines/configurable/StickyLinesProviderConfigurable;", "<init>", "(Ljava/util/List;)V", "showCheckbox", "Ljavax/swing/JCheckBox;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "setPanel", "(Lcom/intellij/openapi/ui/DialogPanel;)V", "languageCheckboxList", "Lkotlin/Pair;", "", "intellij.platform.ide.impl"})
public final class StickyLinesConfigurableUI {
    private JCheckBox showCheckbox;
    public DialogPanel panel;

    public StickyLinesConfigurableUI(@NotNull List<StickyLinesProviderConfigurable> configurables2) {
        Intrinsics.checkNotNullParameter(configurables2, (String)"configurables");
        this.setPanel(BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI._init_$lambda$0(this, configurables2, arg_0))));
    }

    @NotNull
    public final DialogPanel getPanel() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel != null) {
            return dialogPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
        return null;
    }

    public final void setPanel(@NotNull DialogPanel dialogPanel) {
        Intrinsics.checkNotNullParameter((Object)dialogPanel, (String)"<set-?>");
        this.panel = dialogPanel;
    }

    private final List<Pair<String, JCheckBox>> languageCheckboxList(List<StickyLinesProviderConfigurable> configurables2) {
        Map map2 = new LinkedHashMap();
        for (StickyLinesProviderConfigurable configurable : configurables2) {
            String languageId = configurable.getId();
            if (map2.containsKey(languageId)) continue;
            map2.put(languageId, configurable.createComponent());
        }
        return CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)map2), StickyLinesConfigurableUI::languageCheckboxList$lambda$0);
    }

    private static final Unit _init_$lambda$0(StickyLinesConfigurableUI this$0, List $configurables, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        List<Pair<String, JCheckBox>> languages = this$0.languageCheckboxList($configurables);
        Panel.row$default($this$panel, null, arg_0 -> StickyLinesConfigurableUI.lambda$0$0(this$0, settings, arg_0), 1, null);
        RowsRange rowsRange = $this$panel.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI.lambda$0$1(languages, settings, arg_0)));
        JCheckBox jCheckBox = this$0.showCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showCheckbox");
            jCheckBox = null;
        }
        rowsRange.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
        Panel.row$default($this$panel, null, arg_0 -> StickyLinesConfigurableUI.lambda$0$2(this$0, arg_0), 1, null).topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(StickyLinesConfigurableUI this$0, EditorSettingsExternalizable $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"checkbox.show.sticky.lines", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        this$0.showCheckbox = (JCheckBox)ButtonKt.bindSelected(cell, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((EditorSettingsExternalizable)this.receiver).areStickyLinesShown();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((EditorSettingsExternalizable)this.receiver).setStickyLinesShown(p0);
            }
        })).gap(RightGap.SMALL).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(List $languages, EditorSettingsExternalizable $settings, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = ApplicationBundle.message((String)"label.show.sticky.lines", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI.lambda$0$1$0($settings, arg_0)));
        if (!((Collection)$languages).isEmpty()) {
            Panel.row$default($this$indent, null, StickyLinesConfigurableUI::lambda$0$1$1, 1, null);
            $this$indent.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI.lambda$0$1$2($languages, $settings, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$0(EditorSettingsExternalizable $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = Row.intTextField$default($this$row, UtilsKt.asRange((UINumericRange)new UINumericRange(5, 1, 20)), null, 2, null);
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.columns(TextFieldKt.bindIntText(cell, (Function0<Integer>)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((EditorSettingsExternalizable)this.receiver).getStickyLineLimit();
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((EditorSettingsExternalizable)this.receiver).setStickyLineLimit(p0);
            }
        })), 2);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"label.sticky.lines.languages", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$2(List $languages, EditorSettingsExternalizable $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        int rowCount = ($languages.size() + 2) / 3;
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Panel.row$default($this$panel, null, arg_0 -> StickyLinesConfigurableUI.lambda$0$1$2$0($languages, i2, rowCount, $settings, arg_0), 1, null).layout(RowLayout.PARENT_GRID);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$2$0(List $languages, int $i, int $rowCount, EditorSettingsExternalizable $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        for (int j = 0; j < 3; ++j) {
            Pair pair;
            if ((Pair)CollectionsKt.getOrNull((List)$languages, (int)($i + $rowCount * j)) == null) continue;
            boolean bl = false;
            String langId = (String)pair.component1();
            JCheckBox checkBox = (JCheckBox)pair.component2();
            ButtonKt.bindSelected($this$row.cell((JComponent)checkBox), (Function0<Boolean>)((Function0)() -> StickyLinesConfigurableUI.lambda$0$1$2$0$0$0($settings, langId)), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI.lambda$0$1$2$0$0$1($settings, langId, arg_0))).gap(RightGap.COLUMNS);
        }
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$1$2$0$0$0(EditorSettingsExternalizable $settings, String $langId) {
        return $settings.areStickyLinesShownFor($langId);
    }

    private static final Unit lambda$0$1$2$0$0$1(EditorSettingsExternalizable $settings, String $langId, boolean it) {
        $settings.setStickyLinesShownFor($langId, it);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(StickyLinesConfigurableUI this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"configure.sticky.lines.colors", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> StickyLinesConfigurableUI.lambda$0$2$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$0(StickyLinesConfigurableUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this$0.getPanel());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext context2 = dataContext2;
        ColorAndFontOptions.selectOrEditColor(context2, "Sticky Lines//Background", GeneralColorsPage.class);
        return Unit.INSTANCE;
    }

    private static final int languageCheckboxList$lambda$0(Pair o1, Pair o2) {
        return StringUtil.naturalCompare((String)((JCheckBox)o1.getSecond()).getText(), (String)((JCheckBox)o2.getSecond()).getText());
    }
}

