/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Component;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextComponentCaret
extends UserDataHolderBase
implements Caret {
    private final TextComponentEditorImpl myEditor;

    TextComponentCaret(TextComponentEditorImpl editor2) {
        this.myEditor = editor2;
    }

    @NotNull
    public Editor getEditor() {
        TextComponentEditorImpl textComponentEditorImpl = this.myEditor;
        if (textComponentEditorImpl == null) {
            TextComponentCaret.$$$reportNull$$$0(0);
        }
        return textComponentEditorImpl;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        if (caretModel == null) {
            TextComponentCaret.$$$reportNull$$$0(1);
        }
        return caretModel;
    }

    public boolean isValid() {
        return true;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(2);
        }
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaret.$$$reportNull$$$0(3);
        }
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int currentPosition;
        JTextComponent textComponent = this.getTextComponent();
        int targetOffset = Math.min(offset, textComponent.getText().length());
        if (targetOffset != (currentPosition = textComponent.getCaretPosition())) {
            if (targetOffset == textComponent.getCaret().getMark()) {
                textComponent.setCaretPosition(currentPosition);
                textComponent.moveCaretPosition(targetOffset);
            } else {
                textComponent.setCaretPosition(targetOffset);
            }
        }
    }

    public boolean isUpToDate() {
        return true;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        JTextComponent textComponent = this.getTextComponent();
        int caretPos = textComponent.getCaretPosition();
        if (textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)textComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        return new LogicalPosition(line, caretPos - lineStart);
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        return new VisualPosition(pos.line, pos.column);
    }

    public int getOffset() {
        return this.getTextComponent().getCaretPosition();
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public int getSelectionStart() {
        return this.getTextComponent().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionStart());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(4);
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.getTextComponent().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getSelectionEnd());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.getTextComponent().getSelectedText();
    }

    public int getLeadSelectionOffset() {
        JTextComponent textComponent = this.getTextComponent();
        int caretPosition = textComponent.getCaretPosition();
        int start2 = textComponent.getSelectionStart();
        int end = textComponent.getSelectionEnd();
        return caretPosition == start2 ? end : start2;
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myEditor.offsetToVisualPosition(this.getLeadSelectionOffset());
        if (visualPosition == null) {
            TextComponentCaret.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public void setSelection(int startOffset, int endOffset) {
        JTextComponent textComponent = this.getTextComponent();
        if (textComponent.getCaretPosition() == startOffset) {
            textComponent.setCaretPosition(endOffset);
            textComponent.moveCaretPosition(startOffset);
        } else {
            textComponent.setCaretPosition(startOffset);
            textComponent.moveCaretPosition(endOffset);
        }
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void removeSelection() {
        JTextComponent textComponent = this.getTextComponent();
        int position2 = textComponent.getCaretPosition();
        textComponent.select(position2, position2);
    }

    public void selectLineAtCaret() {
        EditorActionUtil.selectEntireLines(this, true);
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler2.execute((Editor)this.myEditor, null, DataManager.getInstance().getDataContext((Component)this.myEditor.getComponent()));
    }

    @Nullable
    public Caret clone(boolean above) {
        return null;
    }

    public void dispose() {
    }

    public boolean isAtRtlLocation() {
        return false;
    }

    public boolean isAtBidiRunBoundary() {
        return false;
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = CaretVisualAttributes.getDefault();
        if (caretVisualAttributes == null) {
            TextComponentCaret.$$$reportNull$$$0(7);
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            TextComponentCaret.$$$reportNull$$$0(8);
        }
    }

    private JTextComponent getTextComponent() {
        return this.myEditor.getContentComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8 -> new IllegalArgumentException(string);
        };
    }
}

