/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositeKt;
import com.intellij.openapi.fileEditor.impl.EditorCompositePanel;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0091\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0003\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a*\u0010\u0013\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00150\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007\u001a(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0016H\u0002\u001a,\u0010%\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\bH\u0001\u001a0\u0010+\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020&2\u0006\u00100\u001a\u000201H\u0002\u001a\"\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\u00a8\u00065"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INITIAL_EMPTY", "com/intellij/openapi/fileEditor/impl/EditorCompositeKt$INITIAL_EMPTY$1", "Lcom/intellij/openapi/fileEditor/impl/EditorCompositeKt$INITIAL_EMPTY$1;", "createTopBottomSideBorder", "Lcom/intellij/ui/SideBorder;", "top", "", "borderColor", "Ljava/awt/Color;", "calcComponentInsertionIndex", "", "newComponent", "Ljavax/swing/JComponent;", "container", "isEditorComposite", "component", "Ljava/awt/Component;", "retrofitEditorComposite", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "composite", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "restoreEditorState", "", "fileEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "exactState", "project", "Lcom/intellij/openapi/project/Project;", "isDumbAware", "editor", "focusEditorOnComposite", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "splitters", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "toFront", "forceFocus", "triggerStatOpen", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "start", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "stateToElement", "Lorg/jdom/Element;", "provider", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorComposite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComposite.kt\ncom/intellij/openapi/fileEditor/impl/EditorCompositeKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1142:1\n13#2:1143\n*S KotlinDebug\n*F\n+ 1 EditorComposite.kt\ncom/intellij/openapi/fileEditor/impl/EditorCompositeKt\n*L\n68#1:1143\n*E\n"})
public final class EditorCompositeKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final INITIAL_EMPTY.1 INITIAL_EMPTY;

    private static final SideBorder createTopBottomSideBorder(boolean top, Color borderColor) {
        int n = top ? 8 : 2;
        return new SideBorder(borderColor, n){
            final /* synthetic */ Color $borderColor;
            {
                this.$borderColor = $borderColor;
                super(null, $super_call_param$1);
            }

            public Color getLineColor() {
                if (this.$borderColor != null) {
                    return this.$borderColor;
                }
                EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
                EditorColorsScheme scheme = editorColorsScheme;
                if (ExperimentalUI.Companion.isNewUI()) {
                    Color color = scheme.getDefaultBackground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
                    return color;
                }
                Color color = scheme.getColor(EditorColors.TEARLINE_COLOR);
                if (color == null) {
                    JBColor jBColor = JBColor.BLACK;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
                    color = (Color)jBColor;
                }
                return color;
            }
        };
    }

    private static final int calcComponentInsertionIndex(JComponent newComponent, JComponent container) {
        int i2 = 0;
        int max = container.getComponentCount();
        while (i2 < max) {
            Component childWrapper = container.getComponent(i2);
            Component childComponent = childWrapper instanceof Wrapper ? (Component)((Wrapper)childWrapper).getTargetComponent() : childWrapper;
            boolean weighted1 = newComponent instanceof Weighted;
            boolean weighted2 = childComponent instanceof Weighted;
            if (!weighted2) {
                ++i2;
                continue;
            }
            if (!weighted1) {
                return i2;
            }
            Intrinsics.checkNotNull((Object)newComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.util.Weighted");
            double w1 = ((Weighted)newComponent).getWeight();
            Intrinsics.checkNotNull((Object)childComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.util.Weighted");
            double w2 = ((Weighted)childComponent).getWeight();
            if (w1 < w2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static final boolean isEditorComposite(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return component2 instanceof EditorCompositePanel;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Pair<FileEditor[], FileEditorProvider[]> retrofitEditorComposite(@Nullable FileEditorComposite composite2) {
        if (composite2 == null) {
            return new Pair((Object)FileEditor.EMPTY_ARRAY, (Object)FileEditorProvider.EMPTY_ARRAY);
        }
        return composite2.retrofit();
    }

    public static final void restoreEditorState(@NotNull FileEditorWithProvider fileEditorWithProvider, @NotNull FileEditorState state2, boolean exactState, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)fileEditorWithProvider, (String)"fileEditorWithProvider");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        FileEditor editor2 = fileEditorWithProvider.getFileEditor();
        if (EditorCompositeKt.isDumbAware(editor2)) {
            editor2.setState(state2, exactState);
        } else {
            DumbService.Companion.getInstance(project2).runWhenSmart(() -> EditorCompositeKt.restoreEditorState$lambda$0(editor2, state2, exactState));
        }
    }

    private static final boolean isDumbAware(FileEditor editor2) {
        return Intrinsics.areEqual((Object)editor2.getUserData(FileEditorManagerKeys.DUMB_AWARE), (Object)true) && (!(editor2 instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor2).isDumbAware());
    }

    @RequiresEdt
    public static final boolean focusEditorOnComposite(@NotNull EditorComposite composite2, @NotNull EditorsSplitters splitters2, boolean toFront, boolean forceFocus) {
        EditorComposite currentSelectedComposite;
        EditorWindow currentWindow;
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        Intrinsics.checkNotNullParameter((Object)splitters2, (String)"splitters");
        EditorWindow editorWindow = currentWindow = splitters2.getCurrentWindow();
        EditorComposite editorComposite = currentSelectedComposite = editorWindow != null ? editorWindow.getSelectedComposite() : null;
        if (currentSelectedComposite == composite2 || forceFocus) {
            JComponent preferredFocusedComponent = composite2.getPreferredFocusedComponent();
            if (preferredFocusedComponent == null) {
                LOG.warn("Cannot focus editor (splitters=" + splitters2 + ", composite=" + composite2 + ", reason=preferredFocusedComponent is null)");
                return false;
            }
            Boolean bl = toFront ? IdeFocusManager.getGlobalInstance().requestFocusInProject((Component)preferredFocusedComponent, composite2.project) : Boolean.valueOf(preferredFocusedComponent.requestFocusInWindow());
            return true;
        }
        LOG.warn("Cannot focus editor (splitters=" + splitters2 + ", composite=" + composite2 + ", currentComposite=" + currentSelectedComposite + ", reason=selection changed)");
        return false;
    }

    public static /* synthetic */ boolean focusEditorOnComposite$default(EditorComposite editorComposite, EditorsSplitters editorsSplitters, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return EditorCompositeKt.focusEditorOnComposite(editorComposite, editorsSplitters, bl, bl2);
    }

    private static final void triggerStatOpen(Project project2, VirtualFile file2, long start2, EditorComposite composite2, CoroutineScope coroutineScope) {
        TextEditor textEditor;
        StartUpMeasurer.addCompletedActivity((long)start2, (String)"editor time-to-show", (ActivityCategory)ActivityCategory.DEFAULT, null);
        long timeToShow = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
        FileEditorWithProvider fileEditorWithProvider = (FileEditorWithProvider)CollectionsKt.firstOrNull(composite2.getAllEditorsWithProviders());
        FileEditor fileEditor = fileEditorWithProvider != null ? fileEditorWithProvider.getFileEditor() : null;
        TextEditor textEditor2 = textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, file2, fileEditor, timeToShow, composite2, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ FileEditor $fileEditor;
                final /* synthetic */ long $timeToShow;
                final /* synthetic */ EditorComposite $composite;
                {
                    this.$project = $project;
                    this.$file = $file;
                    this.$fileEditor = $fileEditor;
                    this.$timeToShow = $timeToShow;
                    this.$composite = $composite;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            FileTypeUsageCounterCollector.INSTANCE.logOpened(this.$project, this.$file, this.$fileEditor, this.$timeToShow, -1L, this.$composite);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            ContextAwareRunnable runnable2 = () -> EditorCompositeKt.triggerStatOpen$lambda$0(start2, coroutineScope, project2, file2, fileEditor, timeToShow, composite2);
            if (textEditor instanceof TextEditorImpl) {
                AsyncEditorLoader.Companion.performWhenLoaded(((TextEditorImpl)textEditor).getEditor(), (Runnable)runnable2);
            } else {
                runnable2.run();
            }
        }
    }

    private static final Element stateToElement(FileEditorState state2, FileEditorProvider provider, Project project2) {
        if (state2 != FileEditorState.INSTANCE) {
            Element stateElement = new Element("state");
            provider.writeState(state2, project2, stateElement);
            if (!stateElement.isEmpty()) {
                return stateElement;
            }
        }
        return null;
    }

    private static final void restoreEditorState$lambda$0(FileEditor $editor, FileEditorState $state, boolean $exactState) {
        $editor.setState($state, $exactState);
    }

    private static final void triggerStatOpen$lambda$0(long $start, CoroutineScope $coroutineScope, Project $project, VirtualFile $file, FileEditor $fileEditor, long $timeToShow, EditorComposite $composite) {
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - $start);
        BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($start, $project, $file, $fileEditor, $timeToShow, durationMs, $composite, null){
            int label;
            final /* synthetic */ long $start;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ FileEditor $fileEditor;
            final /* synthetic */ long $timeToShow;
            final /* synthetic */ long $durationMs;
            final /* synthetic */ EditorComposite $composite;
            {
                this.$start = $start;
                this.$project = $project;
                this.$file = $file;
                this.$fileEditor = $fileEditor;
                this.$timeToShow = $timeToShow;
                this.$durationMs = $durationMs;
                this.$composite = $composite;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        StartUpMeasurer.addCompletedActivity((long)this.$start, (String)"editor time-to-edit", (ActivityCategory)ActivityCategory.DEFAULT, null);
                        FileTypeUsageCounterCollector.INSTANCE.logOpened(this.$project, this.$file, this.$fileEditor, this.$timeToShow, this.$durationMs, this.$composite);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ INITIAL_EMPTY.1 access$getINITIAL_EMPTY$p() {
        return INITIAL_EMPTY;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$triggerStatOpen(Project project2, VirtualFile file2, long start2, EditorComposite composite2, CoroutineScope coroutineScope) {
        EditorCompositeKt.triggerStatOpen(project2, file2, start2, composite2, coroutineScope);
    }

    public static final /* synthetic */ boolean access$isDumbAware(FileEditor editor2) {
        return EditorCompositeKt.isDumbAware(editor2);
    }

    public static final /* synthetic */ SideBorder access$createTopBottomSideBorder(boolean top, Color borderColor) {
        return EditorCompositeKt.createTopBottomSideBorder(top, borderColor);
    }

    public static final /* synthetic */ int access$calcComponentInsertionIndex(JComponent newComponent, JComponent container) {
        return EditorCompositeKt.calcComponentInsertionIndex(newComponent, container);
    }

    public static final /* synthetic */ Element access$stateToElement(FileEditorState state2, FileEditorProvider provider, Project project2) {
        return EditorCompositeKt.stateToElement(state2, provider, project2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(EditorComposite.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        INITIAL_EMPTY = new ArrayList<FileEditorWithProvider>(){

            public boolean equals(Object other) {
                return other == this;
            }
        };
    }
}

