/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCustomizer;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImplKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileEditor.impl.text.TransientEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B1\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0004\b\r\u0010\u0011J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020!H\u0016J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\fH\u0016J\b\u0010'\u001a\u00020\fH\u0016J\b\u0010(\u001a\u00020\fH\u0016J\u0006\u0010)\u001a\u00020\u0017J\"\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0016J\u000e\u00107\u001a\u00020\f2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u00172\u0006\u00108\u001a\u000209J\r\u0010;\u001a\u00070\u001f\u00a2\u0006\u0002\b<H\u0016J\u0006\u0010=\u001a\u00020\fR\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u00a8\u0006?"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "component", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;", "asyncLoader", "Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;", "startLoading", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;Z)V", "componentAndLoader", "Lkotlin/Pair;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/Pair;)V", "changeSupport", "Ljava/beans/PropertyChangeSupport;", "getChangeSupport$annotations", "()V", "dispose", "", "getFile", "getComponent", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getName", "", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "state", "exactState", "isModified", "isValid", "updateModifiedProperty", "firePropertyChange", "propertyName", "oldValue", "", "newValue", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "canNavigateTo", "navigatable", "Lcom/intellij/pom/Navigatable;", "navigateTo", "toString", "Lorg/jetbrains/annotations/NonNls;", "isEditorLoaded", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nTextEditorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorImpl.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project project;
    @JvmField
    @NotNull
    protected final VirtualFile file;
    @NotNull
    private final TextEditorComponent component;
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public final AsyncEditorLoader asyncLoader;
    @NotNull
    private final PropertyChangeSupport changeSupport;

    @ApiStatus.Internal
    public TextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorComponent component2, @NotNull AsyncEditorLoader asyncLoader, boolean startLoading2) {
        TransientEditorState state2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)asyncLoader, (String)"asyncLoader");
        this.project = project2;
        this.file = file2;
        this.component = component2;
        this.asyncLoader = asyncLoader;
        this.changeSupport = new PropertyChangeSupport((Object)this);
        TextEditorProvider.Companion.putTextEditor(this.component.getEditor(), this);
        if (startLoading2) {
            this.asyncLoader.start(this, BuildersKt.async$default((CoroutineScope)this.asyncLoader.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("HighlighterTextEditorInitializer")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TextEditorImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Project project2 = this.this$0.project;
                            VirtualFile virtualFile2 = this.this$0.file;
                            DocumentEx documentEx = this.this$0.getEditor().getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                            this.label = 1;
                            Object object2 = TextEditorImplKt.access$setHighlighterToEditor(project2, virtualFile2, (Document)documentEx, ((TextEditorImpl)this.this$0).component.editorImpl, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null));
        }
        if ((state2 = (TransientEditorState)this.file.getUserData(TextEditorImplKt.access$getTRANSIENT_EDITOR_STATE_KEY$p())) != null) {
            this.file.putUserData(TextEditorImplKt.access$getTRANSIENT_EDITOR_STATE_KEY$p(), null);
            state2.applyTo(this.component.getEditor());
        }
        BuildersKt.launch$default((CoroutineScope)this.asyncLoader.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TextEditorImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        for (LazyExtension extension : TextEditorImplKt.access$getTEXT_EDITOR_CUSTOMIZER_EP$p().filterableLazySequence()) {
                            try {
                                TextEditorCustomizer customizer;
                                if ((TextEditorCustomizer)extension.getInstance() == null) continue;
                                CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)this.this$0.asyncLoader.coroutineScope, (String)extension.getImplementationClassName(), null, (boolean)false, (int)6, null);
                                Project project2 = this.this$0.project;
                                Intrinsics.checkNotNull((Object)project2, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                                ComponentManagerEx componentManagerEx = (ComponentManagerEx)project2;
                                ClassLoader classLoader = customizer.getClass().getClassLoader();
                                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                                CoroutineScopeKt.attachAsChildTo((CoroutineScope)scope, (CoroutineScope)componentManagerEx.pluginCoroutineScope(classLoader));
                                BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(customizer, this.this$0, null){
                                    int label;
                                    final /* synthetic */ TextEditorCustomizer $customizer;
                                    final /* synthetic */ TextEditorImpl this$0;
                                    {
                                        this.$customizer = $customizer;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.$customizer.execute(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                            catch (CancellationException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                boolean $i$f$logger = false;
                                Logger logger2 = Logger.getInstance(TextEditorImpl.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                                logger2.error((Throwable)new PluginException(e, extension.getPluginDescriptor().getPluginId()));
                            }
                        }
                        this.this$0.component.listenChanges$intellij_platform_ide_impl((Disposable)this.this$0, this.this$0.asyncLoader, this.this$0, this.this$0.project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static /* synthetic */ void getChangeSupport$annotations() {
    }

    public TextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Pair<? extends TextEditorComponent, AsyncEditorLoader> componentAndLoader) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(componentAndLoader, (String)"componentAndLoader");
        this(project2, file2, (TextEditorComponent)componentAndLoader.getFirst(), (AsyncEditorLoader)componentAndLoader.getSecond(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.asyncLoader.dispose$intellij_platform_ide_impl();
        }
        finally {
            if (!this.component.isDisposed()) {
                this.component.dispose();
            }
        }
        if (Intrinsics.areEqual((Object)this.file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN), (Object)true)) {
            this.file.putUserData(TextEditorImplKt.access$getTRANSIENT_EDITOR_STATE_KEY$p(), (Object)TransientEditorState.Companion.forEditor(this.getEditor()));
        }
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public TextEditorComponent getComponent() {
        return this.component;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.component.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    @NotNull
    public EditorEx getEditor() {
        return this.component.getEditor();
    }

    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"tab.title.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.asyncLoader.getEditorState(level, this.getEditor());
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.setState(state2, false);
    }

    public void setState(@NotNull FileEditorState state2, boolean exactState) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (state2 instanceof TextEditorState) {
            this.asyncLoader.setEditorState((TextEditorState)state2, exactState, this.getEditor());
        }
    }

    public boolean isModified() {
        return this.component.isModified();
    }

    public boolean isValid() {
        return this.component.isEditorValid();
    }

    public final void updateModifiedProperty() {
        this.component.updateModifiedProperty(this);
    }

    public final void firePropertyChange(@NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.changeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.changeSupport.removePropertyChangeListener(listener2);
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return (FileEditorLocation)new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        Object object;
        block3: {
            block2: {
                VirtualFile virtualFile2;
                object = FileDocumentManager.getInstance().getFile((Document)this.component.getEditor().getDocument());
                if (object == null) break block2;
                VirtualFile it = virtualFile2 = object;
                boolean bl = false;
                object = it.isValid() ? virtualFile2 : null;
                if (object != null) break block3;
            }
            return null;
        }
        VirtualFile file2 = object;
        return StructureViewBuilder.Companion.getProvider().getStructureViewBuilder(file2.getFileType(), file2, this.project);
    }

    public final boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() >= 0 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    public final void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        ((OpenFileDescriptor)navigatable).navigateIn((Editor)this.getEditor());
    }

    @NotNull
    public String toString() {
        return "Editor: " + this.component.getFile();
    }

    public final boolean isEditorLoaded() {
        return this.asyncLoader.isLoaded();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl$Companion;", "", "<init>", "()V", "getDocumentLanguage", "Lcom/intellij/lang/Language;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nTextEditorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorImpl.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,281:1\n1#2:282\n13#3:283\n*S KotlinDebug\n*F\n+ 1 TextEditorImpl.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorImpl$Companion\n*L\n122#1:283\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        @Nullable
        public final Language getDocumentLanguage(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Project project2 = editor2.getProject();
            if (project2 == null) {
                Language language;
                VirtualFile virtualFile2 = editor2.getVirtualFile();
                if (virtualFile2 != null) {
                    VirtualFile file2 = virtualFile2;
                    boolean bl = false;
                    language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
                } else {
                    language = null;
                }
                return language;
            }
            Project project3 = project2;
            if (project3.isDisposed()) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(TextEditorImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("Attempting to get a language for document on a disposed project: " + project3.getName());
                return null;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project3).getPsiFile(editor2.getDocument());
            return psiFile != null ? psiFile.getLanguage() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

