/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.IntelliJResourceBundle;
import com.intellij.ide.actions.ConfigurablesPatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableGroupEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.EpBasedConfigurableGroup;
import com.intellij.openapi.options.ex.HierarchicalConfigurable;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurableExtensionPointUtil {
    @NonNls
    public static final String CONFIGURABLE_ID_PREFIX = "configurable.group.";
    @NonNls
    private static final String ROOT_ID = "root";
    @NonNls
    private static final String OTHER_ID = "other";
    @NonNls
    public static final String ROOT_CONFIGURABLE_ID = "configurable.group.root";
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    @NotNull
    public static List<Configurable> buildConfigurablesList(@NotNull List<? extends ConfigurableEP<Configurable>> extensions, @Nullable ConfigurableFilter filter2) {
        if (extensions == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap<String, HierarchicalConfigurable> idToConfigurable = new HashMap<String, HierarchicalConfigurable>();
        ArrayList<String> idsInEpOrder = new ArrayList<String>();
        for (ConfigurableEP<Configurable> configurableEP : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(configurableEP);
            if (filter2 != null && !filter2.isIncluded(configurable)) continue;
            if (configurable instanceof HierarchicalConfigurable) {
                HierarchicalConfigurable wrapper2 = (HierarchicalConfigurable)configurable;
                idToConfigurable.put(wrapper2.getId(), wrapper2);
                idsInEpOrder.add(wrapper2.getId());
                continue;
            }
            if (configurable == null) continue;
            result2.add(configurable);
        }
        HashSet visited = new HashSet();
        Map<String, List<String>> map2 = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id2 : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id2, idToConfigurable, visited, map2);
        }
        for (String id2 : idsInEpOrder) {
            HierarchicalConfigurable wrapper3 = (HierarchicalConfigurable)idToConfigurable.get(id2);
            String parentId = wrapper3.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper3);
        }
        ArrayList<Configurable> arrayList = result2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static HierarchicalConfigurable addChildrenRec(@NotNull String id2, @NotNull Map<String, HierarchicalConfigurable> idToConfigurable, @NotNull Set<? super String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(2);
        }
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(4);
        }
        if (idTree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(5);
        }
        HierarchicalConfigurable wrapper2 = idToConfigurable.get(id2);
        if (visited.contains(id2)) {
            HierarchicalConfigurable hierarchicalConfigurable = wrapper2;
            if (hierarchicalConfigurable == null) {
                ConfigurableExtensionPointUtil.$$$reportNull$$$0(6);
            }
            return hierarchicalConfigurable;
        }
        visited.add(id2);
        List<String> childIds = idTree.get(id2);
        if (childIds != null) {
            for (String childId : childIds) {
                HierarchicalConfigurable childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper2 = wrapper2.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id2, wrapper2);
        }
        HierarchicalConfigurable hierarchicalConfigurable = wrapper2;
        if (hierarchicalConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(7);
        }
        return hierarchicalConfigurable;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, HierarchicalConfigurable> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(8);
        }
        if (idsInEpOrder == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, List<String>> tree2 = new HashMap<String, List<String>>();
        for (String id2 : idsInEpOrder) {
            HierarchicalConfigurable hierarchical = idToConfigurable.get(id2);
            String parentId = hierarchical.getParentId();
            if (parentId == null) continue;
            HierarchicalConfigurable parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + String.valueOf(hierarchical) + ")");
                continue;
            }
            tree2.computeIfAbsent(parentId, k -> new ArrayList(5)).add(id2);
        }
        HashMap<String, List<String>> hashMap = tree2;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project2, boolean withIdeSettings) {
        Project targetProject = withIdeSettings ? project2 : ProjectUtil.currentOrDefaultProject((Project)project2);
        return ConfigurableExtensionPointUtil.doGetConfigurableGroup(targetProject, withIdeSettings);
    }

    @ApiStatus.Internal
    @NotNull
    public static ConfigurableGroup doGetConfigurableGroup(@Nullable Project targetProject, boolean withIdeSettings) {
        return new EpBasedConfigurableGroup(targetProject, (Function0<? extends ConfigurableGroup>)((Function0)() -> {
            List<Configurable> configurables2 = ConfigurableExtensionPointUtil.getConfigurables(targetProject, withIdeSettings);
            return ConfigurableExtensionPointUtil.getConfigurableGroup(configurables2, targetProject);
        }));
    }

    @Nullable
    public static ConfigurableGroup getConfigurableGroup(@NotNull List<? extends Configurable> configurables2, @Nullable Project project2) {
        if (configurables2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(11);
        }
        Map<String, List<Configurable>> map2 = ConfigurableExtensionPointUtil.groupConfigurables(configurables2);
        HashMap<String, Node<SortedConfigurableGroup>> tree2 = new HashMap<String, Node<SortedConfigurableGroup>>();
        for (Map.Entry<String, List<Configurable>> entry : map2.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree2, project2, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree2, ROOT_ID);
        if (!tree2.isEmpty()) {
            LOG.warn("ignore groups: " + String.valueOf(tree2.keySet()));
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            SortedConfigurableGroup group2;
            Configurable configurable = list2.get(i2);
            if (!(configurable instanceof SortedConfigurableGroup) || (configurable = ConfigurableExtensionPointUtil.getConfigurableToReplace(group2.myList, (group2 = (SortedConfigurableGroup)configurable).getWeight())) == null) continue;
            list2.set(i2, configurable);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable = list2.get(0);
                if (configurable instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group2 = (SortedConfigurableGroup)configurable;
                    group2.myWeight = weight;
                    return group2;
                }
                if (configurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
                    wrapper2.myWeight = weight;
                    return wrapper2;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree2, String groupId) {
        Node<SortedConfigurableGroup> node = tree2.remove(groupId);
        if (node.myChildren != null) {
            Iterator<Object> iterator2 = node.myChildren.iterator();
            while (iterator2.hasNext()) {
                String childId = (String)iterator2.next();
                ((SortedConfigurableGroup)node.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree2, childId));
                iterator2.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(@NotNull Map<String, Node<SortedConfigurableGroup>> tree2, Project project2, String groupId, List<? extends Configurable> configurables2, ResourceBundle alternative) {
        ResourceBundle bundle2;
        boolean root;
        if (tree2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(12);
        }
        ConfigurableGroupEP ep = (root = ROOT_ID.equals(groupId)) ? null : ConfigurableGroupEP.find(groupId);
        Object id2 = CONFIGURABLE_ID_PREFIX + groupId;
        ResourceBundle resourceBundle = bundle2 = ep != null ? ep.getResourceBundle() : ConfigurableExtensionPointUtil.getBundle((String)id2 + ".settings.display.name", configurables2, alternative);
        if (bundle2 == null) {
            bundle2 = OptionsBundle.INSTANCE.getResourceBundle();
            if (!root) {
                LOG.warn("use other group instead of unexpected one: " + groupId);
                groupId = OTHER_ID;
                id2 = "configurable.group.other";
            }
        }
        Node<SortedConfigurableGroup> node = Node.get(tree2, groupId);
        if (node.myValue == null) {
            if (ep != null) {
                String name2 = project2 == null || project2.isDefault() || !"project".equals(groupId) ? ep.getDisplayName() : StringUtil.first((String)MessageFormat.format(ep.getResourceValue("configurable.group.project.named.settings.display.name"), project2.getName()), (int)30, (boolean)true);
                node.myValue = new SortedConfigurableGroup((String)id2, name2, ep.getDescription(), ep.helpTopic, ep.weight);
            } else if (root) {
                node.myValue = new SortedConfigurableGroup((String)id2, "ROOT GROUP", null, null, 0);
            } else {
                LOG.warn("Use <groupConfigurable> to specify custom configurable group: " + groupId);
                int weight = ConfigurableExtensionPointUtil.getInt(bundle2, (String)id2 + ".settings.weight");
                String help = ConfigurableExtensionPointUtil.getString(bundle2, (String)id2 + ".settings.help.topic");
                String name3 = ConfigurableExtensionPointUtil.getString(bundle2, (String)id2 + ".settings.display.name");
                String desc = ConfigurableExtensionPointUtil.getString(bundle2, (String)id2 + ".settings.description");
                if (name3 != null && project2 != null) {
                    if (!project2.isDefault() && !name3.contains("{")) {
                        String named = ConfigurableExtensionPointUtil.getString(bundle2, (String)id2 + ".named.settings.display.name");
                        String string = name3 = named != null ? named : name3;
                    }
                    if (name3.contains("{")) {
                        name3 = StringUtil.first((String)MessageFormat.format(name3, project2.getName()), (int)30, (boolean)true);
                    }
                }
                node.myValue = new SortedConfigurableGroup((String)id2, Objects.requireNonNullElse(name3, ""), desc, help, weight);
            }
        }
        if (configurables2 != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables2);
        }
        if (!root && node.myParent == null) {
            String parentId = ep != null ? ep.parentId : ConfigurableExtensionPointUtil.getString(bundle2, (String)id2 + ".settings.parent");
            parentId = Node.cyclic(tree2, parentId, ROOT_ID, groupId, node);
            node.myParent = Node.add(tree2, parentId, groupId);
            ConfigurableExtensionPointUtil.addGroup(tree2, project2, parentId, null, bundle2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<? extends Configurable> configurables2) {
        if (configurables2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(13);
        }
        HashMap<String, Node<HierarchicalConfigurable>> tree2 = new HashMap<String, Node<HierarchicalConfigurable>>();
        for (Configurable configurable : configurables2) {
            String groupId;
            void id2;
            if (!(configurable instanceof HierarchicalConfigurable)) {
                Node.add(tree2, OTHER_ID, configurable);
                continue;
            }
            HierarchicalConfigurable hierarchical = (HierarchicalConfigurable)configurable;
            try {
                String id22 = hierarchical.getId();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create configurable", e);
                continue;
            }
            Node node = Node.get(tree2, id2);
            if (node.myValue != null) {
                LOG.warn("ignore configurable with duplicated id: " + (String)id2);
                continue;
            }
            String parentId = hierarchical.getParentId();
            if (hierarchical instanceof ConfigurableWrapper && (groupId = ((ConfigurableWrapper)hierarchical).getExtensionPoint().groupId) != null) {
                if (parentId != null) {
                    LOG.warn("ignore deprecated groupId: " + groupId + " for id: " + (String)id2);
                } else {
                    parentId = groupId;
                }
            }
            parentId = (String)Node.cyclic(tree2, parentId, OTHER_ID, id2, node);
            node.myParent = Node.add(tree2, parentId, node);
            node.myValue = hierarchical;
        }
        HashMap<String, List<Configurable>> map2 = new HashMap<String, List<Configurable>>();
        for (String id3 : ArrayUtilRt.toStringArray(tree2.keySet())) {
            List<Configurable> list2;
            Node node = (Node)tree2.get(id3);
            if (node == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables(tree2, node)) == null) continue;
            map2.put(id3, list2);
            tree2.remove(id3);
        }
        HashMap<String, List<Configurable>> hashMap = map2;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<HierarchicalConfigurable>> tree2, Node<HierarchicalConfigurable> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return new ArrayList<Configurable>();
            }
            return null;
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>(node.myChildren.size());
        Iterator<Object> iterator2 = node.myChildren.iterator();
        while (iterator2.hasNext()) {
            Object child = iterator2.next();
            if (child instanceof Configurable) {
                list2.add((Configurable)child);
            } else {
                Node value = (Node)child;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree2, value) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add((Configurable)value.myValue);
                tree2.remove(((HierarchicalConfigurable)value.myValue).getId());
            }
            iterator2.remove();
        }
        if (node.myValue == null) {
            return list2;
        }
        for (Configurable configurable : list2) {
            node.myValue = ((HierarchicalConfigurable)node.myValue).addChild(configurable);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        return ConfigurableExtensionPointUtil.getConfigurables(project2, withIdeSettings, true);
    }

    @ApiStatus.Internal
    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings, boolean checkNonDefaultProject) {
        Object application;
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            for (ConfigurableEP extension : Configurable.APPLICATION_CONFIGURABLE.getExtensionList()) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), null, checkNonDefaultProject);
            }
        }
        if (project2 != null && !project2.isDisposed()) {
            for (ConfigurableEP extension : Configurable.PROJECT_CONFIGURABLE.getExtensions((AreaInstance)project2)) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension, true), project2, checkNonDefaultProject);
            }
        }
        List modificators = ConfigurablesPatcher.EP_NAME.getExtensionList();
        for (ConfigurablesPatcher modificator : modificators) {
            modificator.modifyOriginalConfigurablesList(list2, project2);
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addValid(@NotNull List<? super Configurable> list2, Configurable configurable, Project project2, boolean checkNonDefaultProject) {
        if (list2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(16);
        }
        if (ConfigurableExtensionPointUtil.isValid(configurable, project2, checkNonDefaultProject)) {
            list2.add((Configurable)configurable);
        }
    }

    private static boolean isValid(Configurable configurable, Project project2, boolean checkNonDefault) {
        if (configurable == null) {
            return false;
        }
        return project2 == null || !checkNonDefault || !project2.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable);
    }

    @Nullable
    public static ResourceBundle getBundle(@NonNls @NotNull String resource2, @Nullable Iterable<? extends Configurable> configurables2, @Nullable ResourceBundle alternative) {
        ResourceBundle bundle2;
        if (resource2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(17);
        }
        if (ConfigurableExtensionPointUtil.getString(bundle2 = OptionsBundle.INSTANCE.getResourceBundle(), resource2) != null) {
            return bundle2;
        }
        if (configurables2 != null) {
            for (Configurable configurable : configurables2) {
                ConfigurableWrapper wrapper2;
                if (!(configurable instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle2 = (wrapper2 = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle(), resource2) == null) continue;
                return bundle2;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource2) != null) {
            return alternative;
        }
        return null;
    }

    @Nls
    @Nullable
    private static String getString(ResourceBundle bundle2, @NonNls String resource2) {
        if (bundle2 == null) {
            return null;
        }
        if (bundle2 instanceof IntelliJResourceBundle) {
            IntelliJResourceBundle b = (IntelliJResourceBundle)bundle2;
            return b.getMessageOrNull(resource2);
        }
        try {
            return bundle2.getString(resource2);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle2, @NonNls String resource2) {
        try {
            String value = ConfigurableExtensionPointUtil.getString(bundle2, resource2);
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project2, Class<? extends ConfigurableProvider> providerClass) {
        if (project2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(18);
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(() -> Configurable.PROJECT_CONFIGURABLE.asSequence((AreaInstance)project2).iterator(), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.APPLICATION_CONFIGURABLE.getIterable(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(@NotNull Iterable<? extends ConfigurableEP<Configurable>> extensions, Class<? extends ConfigurableProvider> providerClass) {
        if (extensions == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(19);
        }
        for (ConfigurableEP<Configurable> configurableEP : extensions) {
            Class aClass;
            if (configurableEP.providerClass == null || (aClass = configurableEP.findClassOrNull(configurableEP.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)configurableEP.createConfigurable();
        }
        return null;
    }

    @Nls
    public static String getConfigurablePath(Class<? extends Configurable> configurableClass, Project project2) {
        ArrayList path = new ArrayList();
        ConfigurableExtensionPointUtil.collectPath(configurableClass, path, ConfigurableExtensionPointUtil.getConfigurableGroup(project2, true).getConfigurables());
        return StringUtil.join(path, (String)" | ");
    }

    private static void collectPath(Class<? extends Configurable> configurableClass, List<? super String> path, Configurable[] configurables2) {
        for (Configurable configurable : configurables2) {
            if (configurableClass.equals(configurable.getClass()) || configurable instanceof ConfigurableWrapper && configurableClass.getName().equals(((ConfigurableWrapper)configurable).getExtensionPoint().instanceClass)) {
                path.add(configurable.getDisplayName());
            }
            if (!(configurable instanceof Configurable.Composite)) continue;
            ArrayList thisPart = new ArrayList();
            ConfigurableExtensionPointUtil.collectPath(configurableClass, thisPart, ((Configurable.Composite)configurable).getConfigurables());
            if (thisPart.isEmpty()) continue;
            path.add(configurable.getDisplayName());
            path.addAll(thisPart);
            break;
        }
    }

    @ApiStatus.Internal
    public static void patch(@NotNull String id2, @Nullable String parentId, @Nullable String bundle2) {
        ConfigurableGroupEP ep;
        if (id2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(20);
        }
        if ((ep = ConfigurableGroupEP.find(id2)) != null) {
            ep.parentId = parentId;
            if (bundle2 != null) {
                ep.bundle = bundle2;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 10, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsInEpOrder";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurablesList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addChildrenRec";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "groupConfigurables";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildConfigurablesList";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenRec";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildIdTree";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "groupConfigurables";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addValid";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProjectConfigurableForProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurableForProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 10, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(@NotNull Map<I, Node<V>> tree2, @NotNull I id2) {
            Node<V> node;
            if (tree2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            if ((node = tree2.get(id2)) == null) {
                node = new Node<V>();
                tree2.put(id2, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(@NotNull Map<I, Node<V>> tree2, @NotNull I id2, Object child) {
            if (tree2 == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            Node<V> node = Node.get(tree2, id2);
            if (node.myChildren == null) {
                node.myChildren = new SmartList();
            }
            node.myChildren.add(child);
            return node;
        }

        private static <I, V> boolean cyclic(@NotNull Map<I, Node<V>> tree2, @NotNull I id2, Node<V> parent) {
            if (tree2 == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            Node<V> node = tree2.get(id2);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(@NotNull Map<I, Node<V>> tree2, @Nullable I id2, I idDefault, I idNode, Node<V> parent) {
            if (tree2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (id2 == null) {
                id2 = idDefault;
            }
            if (Node.cyclic(tree2, id2, parent)) {
                LOG.warn("ignore cyclic dependency: " + String.valueOf(id2) + " cannot contain " + String.valueOf(idNode));
                id2 = idDefault;
            }
            return id2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil$Node";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cyclic";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

