/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.ActionCallback;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class Settings {
    public static final DataKey<Settings> KEY = DataKey.create((String)"settings.editor");
    private final List<? extends ConfigurableGroup> myGroups;
    private final Map<UnnamedConfigurable, ConfigurableWrapper> myMap;

    protected Settings(@NotNull List<? extends ConfigurableGroup> groups) {
        if (groups == null) {
            Settings.$$$reportNull$$$0(0);
        }
        this.myMap = new IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper>();
        this.myGroups = groups;
    }

    @Nullable
    public final <T extends Configurable> T find(@NotNull Class<T> type) {
        if (type == null) {
            Settings.$$$reportNull$$$0(1);
        }
        return this.unwrap(ConfigurableVisitor.findByType(type, this.myGroups), type);
    }

    @Nullable
    public final Configurable find(@NotNull String id2) {
        if (id2 == null) {
            Settings.$$$reportNull$$$0(2);
        }
        return this.unwrap(ConfigurableVisitor.findById(id2, this.myGroups), Configurable.class);
    }

    @NotNull
    public final ActionCallback select(Configurable configurable) {
        ActionCallback actionCallback = configurable == null ? ActionCallback.REJECTED : Promises.toActionCallback(this.selectImpl(Settings.choose(configurable, (Configurable)this.myMap.get(configurable))));
        if (actionCallback == null) {
            Settings.$$$reportNull$$$0(3);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback select(Configurable configurable, String option2) {
        ActionCallback callback = this.select(configurable);
        if (option2 != null && configurable instanceof SearchableConfigurable) {
            Runnable runnable2 = ((SearchableConfigurable)configurable).enableSearch(option2);
            callback.doWhenDone(() -> {
                if (runnable2 != null) {
                    runnable2.run();
                } else {
                    this.setSearchText(option2);
                }
            });
        }
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            Settings.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @NotNull
    protected abstract Promise<? super Object> selectImpl(Configurable var1);

    @Nullable
    public final Configurable getConfigurableWithInitializedUiComponent(@NotNull String configurableId, boolean initializeUiComponentIfNotYet) {
        Configurable c;
        if (configurableId == null) {
            Settings.$$$reportNull$$$0(5);
        }
        if ((c = this.find(configurableId)) == null) {
            return null;
        }
        Configurable configurable = Settings.choose(c, (Configurable)this.myMap.get(c));
        return this.getConfigurableWithInitializedUiComponentImpl(configurable, initializeUiComponentIfNotYet);
    }

    protected abstract Configurable getConfigurableWithInitializedUiComponentImpl(@NotNull Configurable var1, boolean var2);

    public final void checkModified(@NotNull String configurableId) {
        Configurable c;
        if (configurableId == null) {
            Settings.$$$reportNull$$$0(6);
        }
        if ((c = this.find(configurableId)) == null) {
            return;
        }
        Configurable configurable = Settings.choose(c, (Configurable)this.myMap.get(c));
        this.checkModifiedImpl(configurable);
    }

    protected abstract void checkModifiedImpl(@NotNull Configurable var1);

    protected abstract void setSearchText(String var1);

    private <T extends Configurable> T unwrap(Configurable configurable, Class<T> type) {
        Configurable result2 = (Configurable)ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable);
        if (result2 != null && configurable instanceof ConfigurableWrapper) {
            this.myMap.put((UnnamedConfigurable)result2, (ConfigurableWrapper)configurable);
        }
        return (T)result2;
    }

    private static Configurable choose(Configurable configurable, Configurable variant) {
        return variant != null ? variant : configurable;
    }

    public void revalidate() {
    }

    public void reload() {
        this.myMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/Settings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/Settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableWithInitializedUiComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkModified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

