/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadWriteActionSupport;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.rw.PlatformReadWriteActionSupport;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.EternalEventStealer;
import com.intellij.openapi.progress.util.EventStealer;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinOverlayProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.progress.util.SuvorovProgressKt;
import com.intellij.openapi.progress.util.ui.NiceOverlayUi;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ'\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\tJ\u0014\u0010\u0016\u001a\u00020\t2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0007J\u001c\u0010\u0019\u001a\u00020\t2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\t2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\t2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\t2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\b\u0010#\u001a\u00020\tH\u0002R\u0016\u0010\u0004\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/progress/util/SuvorovProgress;", "", "<init>", "()V", "awtComponentLock", "kotlin.jvm.PlatformType", "eternalStealer", "Lcom/intellij/openapi/progress/util/EternalEventStealer;", "init", "", "disposable", "Lcom/intellij/openapi/Disposable;", "title", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lorg/jetbrains/annotations/Nls;", "withProgressTitle", "T", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tryProgressWithPendingBackgroundWriteAction", "dispatchEventsUntilComputationCompletes", "awaitedValue", "Lkotlinx/coroutines/Deferred;", "showNiceOverlay", "rootPane", "Ljavax/swing/JRootPane;", "showPotemkinProgress", "isBar", "", "processInvocationEventsWithoutDialog", "showingDelay", "", "showSpinningProgress", "sleep", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSuvorovProgress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuvorovProgress.kt\ncom/intellij/openapi/progress/util/SuvorovProgress\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,425:1\n58#2:426\n23#3:427\n1#4:428\n94#5:429\n107#5:430\n98#5,4:431\n*S KotlinDebug\n*F\n+ 1 SuvorovProgress.kt\ncom/intellij/openapi/progress/util/SuvorovProgress\n*L\n108#1:426\n144#1:427\n195#1:429\n195#1:430\n195#1:431,4\n*E\n"})
public final class SuvorovProgress {
    @NotNull
    public static final SuvorovProgress INSTANCE = new SuvorovProgress();
    private static final Object awtComponentLock = new Component(){}.getTreeLock();
    private static volatile EternalEventStealer eternalStealer;
    @NotNull
    private static final AtomicReference<String> title;

    private SuvorovProgress() {
    }

    public final void init(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        eternalStealer = new EternalEventStealer(disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withProgressTitle(@NotNull String title2, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        String oldTitle = title.getAndSet(title2);
        try {
            Object object = action2.invoke();
            return (T)object;
        }
        finally {
            title.set(oldTitle);
        }
    }

    public final void tryProgressWithPendingBackgroundWriteAction() {
        if (Thread.holdsLock(awtComponentLock)) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)application;
            boolean $i$f$serviceIfCreated = false;
            ReadWriteActionSupport rwService = (ReadWriteActionSupport)$this$serviceIfCreated$iv.getServiceIfCreated(ReadWriteActionSupport.class);
            if (rwService instanceof PlatformReadWriteActionSupport) {
                ((PlatformReadWriteActionSupport)rwService).signalWriteActionNeedsToBeRetried();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void dispatchEventsUntilComputationCompletes(@NotNull Deferred<?> awaitedValue) {
        String value;
        block19: {
            JRootPane currentFocusedPane;
            block20: {
                Intrinsics.checkNotNullParameter(awaitedValue, (String)"awaitedValue");
                int showingDelay = Registry.Companion.get("ide.suvorov.progress.showing.delay.ms").asInteger();
                INSTANCE.tryProgressWithPendingBackgroundWriteAction();
                INSTANCE.processInvocationEventsWithoutDialog(awaitedValue, showingDelay);
                if (awaitedValue.isCompleted()) {
                    return;
                }
                LifecycleUsageTriggerCollector.onFreezePopupShown();
                boolean isScaleInitialized = ApplicationKt.getApplication().isUnitTestMode() || JBUIScale.isInitialized();
                String string = value = !LoadingState.COMPONENTS_LOADED.isOccurred() || !isScaleInitialized ? "None" : Registry.Companion.get("ide.suvorov.progress.kind").getSelectedOption();
                if (string == null) throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                switch (string.hashCode()) {
                    case 66547: {
                        if (!string.equals("Bar")) {
                            throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                        }
                        break block19;
                    }
                    case 71850515: {
                        if (!string.equals("NiceOverlay")) {
                            throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                        }
                        break block20;
                    }
                    case -1943403498: {
                        if (string.equals("Spinning")) break;
                        throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                    }
                    case 573365296: {
                        if (!string.equals("Overlay")) {
                            throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                        }
                        break block19;
                    }
                    case 2433880: {
                        if (!string.equals("None")) throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
                        INSTANCE.processInvocationEventsWithoutDialog(awaitedValue, Integer.MAX_VALUE);
                        return;
                    }
                }
                if (Registry.Companion.is("editor.allow.raw.access.on.edt")) {
                    INSTANCE.showSpinningProgress(awaitedValue);
                    return;
                } else {
                    SuvorovProgress $this$thisLogger$iv = INSTANCE;
                    boolean $i$f$thisLogger = false;
                    com.intellij.openapi.diagnostic.Logger logger2 = com.intellij.openapi.diagnostic.Logger.getInstance(SuvorovProgress.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.warn("Spinning progress would not work without enabled registry value `editor.allow.raw.access.on.edt`");
                    INSTANCE.processInvocationEventsWithoutDialog(awaitedValue, Integer.MAX_VALUE);
                }
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window != null) {
                Component p0 = window;
                boolean bl = false;
                v2 = SwingUtilities.getRootPane(p0);
            } else {
                v2 = currentFocusedPane = null;
            }
            if (currentFocusedPane == null || GraphicsUtil.safelyGetGraphics((Component)currentFocusedPane) == null) {
                INSTANCE.processInvocationEventsWithoutDialog(awaitedValue, Integer.MAX_VALUE);
                return;
            } else if (title.get() != null) {
                INSTANCE.showPotemkinProgress(awaitedValue, true);
                return;
            } else {
                INSTANCE.showNiceOverlay(awaitedValue, currentFocusedPane);
            }
            return;
        }
        INSTANCE.showPotemkinProgress(awaitedValue, Intrinsics.areEqual((Object)value, (Object)"Bar"));
        return;
        throw new IllegalArgumentException("Unknown value for registry key `ide.freeze.fake.progress.kind`: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showNiceOverlay(Deferred<?> awaitedValue, JRootPane rootPane) {
        NiceOverlayUi niceOverlay = new NiceOverlayUi(rootPane, false);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        EventStealer stealer = new EventStealer(disposable2, true, arg_0 -> SuvorovProgress.showNiceOverlay$lambda$1(arg_0 -> SuvorovProgress.showNiceOverlay$lambda$0(niceOverlay, arg_0), arg_0));
        SuvorovProgressKt.access$repostAllEvents();
        long oldTimestamp = System.currentTimeMillis();
        try {
            while (!awaitedValue.isCompleted()) {
                if (ThreadingRuntimeFlagsKt.getUseDebouncedDrawingInSuvorovProgress()) {
                    long newTimestamp = System.currentTimeMillis();
                    if (newTimestamp - oldTimestamp >= 10L) {
                        oldTimestamp = newTimestamp;
                        niceOverlay.redrawMainComponent();
                    }
                    stealer.dispatchEvents(0);
                    stealer.waitForPing(10);
                    continue;
                }
                niceOverlay.redrawMainComponent();
                stealer.dispatchEvents(0);
                Thread.sleep(10L);
            }
        }
        finally {
            niceOverlay.close();
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private final void showPotemkinProgress(Deferred<?> awaitedValue, boolean isBar) {
        IntelliJLockingUtil.getGlobalThreadingSupport().relaxPreventiveLockingActions(() -> SuvorovProgress.showPotemkinProgress$lambda$0(isBar, awaitedValue));
    }

    private final void processInvocationEventsWithoutDialog(Deferred<?> awaitedValue, int showingDelay) {
        EternalEventStealer eternalEventStealer = eternalStealer;
        if (eternalEventStealer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eternalStealer");
            eternalEventStealer = null;
        }
        eternalEventStealer.dispatchAllEventsForTimeout(showingDelay, awaitedValue);
    }

    private final void showSpinningProgress(Deferred<?> awaitedValue) {
        IntelliJLockingUtil.getGlobalThreadingSupport().relaxPreventiveLockingActions(() -> SuvorovProgress.showSpinningProgress$lambda$0(awaitedValue));
    }

    private final void sleep() {
        Thread.sleep(0L, 100000);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showNiceOverlay$lambda$0(NiceOverlayUi $niceOverlay, InputEvent event) {
        boolean dumpThreads2 = false;
        if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500) {
            ((MouseEvent)event).consume();
            Point point = ((MouseEvent)event).getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            NiceOverlayUi.ClickOutcome reaction = $niceOverlay.mouseClicked(point);
            switch (WhenMappings.$EnumSwitchMapping$0[reaction.ordinal()]) {
                case 1: {
                    dumpThreads2 = true;
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 503) {
            ((MouseEvent)event).consume();
            Point point = ((MouseEvent)event).getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            $niceOverlay.mouseMoved(point);
        }
        if (event instanceof KeyEvent) {
            KeyboardShortcut keyboardShortcut;
            KeyboardShortcut keyboardShortcut2 = $niceOverlay.getDumpThreadsButtonShortcut();
            KeyStroke keyStroke = KeyStrokeAdapter.getDefaultKeyStroke((KeyEvent)event);
            if (keyStroke != null) {
                void it;
                KeyStroke keyStroke2 = keyStroke;
                KeyboardShortcut keyboardShortcut3 = keyboardShortcut2;
                boolean bl = false;
                keyboardShortcut = new KeyboardShortcut((KeyStroke)it, null);
                keyboardShortcut2 = keyboardShortcut3;
            } else {
                keyboardShortcut = null;
            }
            if (Intrinsics.areEqual((Object)keyboardShortcut2, keyboardShortcut)) {
                ((KeyEvent)event).consume();
                dumpThreads2 = true;
            }
        }
        if (dumpThreads2) {
            ApplicationManager.getApplication().executeOnPooledThread(SuvorovProgress::showNiceOverlay$lambda$0$1);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void showNiceOverlay$lambda$0$1() {
        Path dumpFile = PerformanceWatcher.Companion.getInstance().dumpThreads("freeze-popup", true, false);
        if (dumpFile != null) {
            if (Files.exists(dumpFile, new LinkOption[0])) {
                RevealFileAction.openFile(dumpFile);
            } else {
                void $this$log$iv$iv;
                boolean $i$f$getLogger = false;
                Logger $this$error$iv = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(SuvorovProgress.class));
                boolean $i$f$error = false;
                Logger logger2 = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var7_8 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "Failed to dump threads to " + dumpFile;
                    var7_8.log(logLevel, (Object)string, null);
                }
            }
        }
    }

    private static final void showNiceOverlay$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit showPotemkinProgress$lambda$0(boolean $isBar, Deferred $awaitedValue) {
        Disposable disposable;
        Disposable disposable2;
        String title2 = title.get();
        if (title2 != null || $isBar) {
            String string = title2;
            if (string == null) {
                String string2 = CommonBundle.message((String)"title.long.non.interactive.progress", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            disposable2 = new PotemkinProgress(string, null, null, null);
        } else {
            JRootPane window = SwingUtilities.getRootPane(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
            disposable2 = new PotemkinOverlayProgress(window, false);
        }
        Disposable $this$showPotemkinProgress_u24lambda_u240_u240 = disposable = disposable2;
        boolean bl = false;
        ((ProgressIndicatorWithDelayedPresentation)$this$showPotemkinProgress_u24lambda_u240_u240).setDelayInMillis(0);
        SuvorovProgressKt.access$repostAllEvents();
        Disposable progress = disposable;
        ((ProgressIndicator)progress).start();
        try {
            do {
                if (progress instanceof PotemkinProgress) {
                    progress.dispatchAllInvocationEvents();
                } else if (progress instanceof PotemkinOverlayProgress) {
                    ((PotemkinOverlayProgress)progress).dispatchAllInvocationEvents();
                }
                ((PingProgress)progress).interact();
                INSTANCE.sleep();
            } while (!$awaitedValue.isCompleted());
        }
        finally {
            if (progress instanceof PotemkinProgress) {
                DialogWrapper dialogWrapper = ((PotemkinProgress)progress).getDialog().getPopup();
                if (dialogWrapper != null) {
                    dialogWrapper.setShouldUseWriteIntentReadAction(false);
                }
                ((PotemkinProgress)progress).progressFinished();
                ((PotemkinProgress)progress).processFinish();
                Disposer.dispose((Disposable)progress);
            }
            ((ProgressIndicator)progress).stop();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit showSpinningProgress$lambda$0(Deferred $awaitedValue) {
        AnimatedIcon animatedIcon = AsyncProcessIcon.createBig((String)"Suvorov progress");
        Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"createBig(...)");
        AnimatedIcon icon2 = animatedIcon;
        JRootPane window = SwingUtilities.getRootPane(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (window == null) {
            FutureKt.asCompletableFuture((Deferred)$awaitedValue).join();
            return Unit.INSTANCE;
        }
        icon2.setSize(icon2.getPreferredSize());
        icon2.setVisible(true);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposer = disposable;
        EventStealer eventStealer = PotemkinProgress.startStealingInputEvents(arg_0 -> SuvorovProgress.showSpinningProgress$lambda$0$1(SuvorovProgress::showSpinningProgress$lambda$0$0, arg_0), disposer);
        Intrinsics.checkNotNullExpressionValue((Object)eventStealer, (String)"startStealingInputEvents(...)");
        EventStealer stealer = eventStealer;
        SuvorovProgressKt.access$repostAllEvents();
        JLayeredPane host = window.getLayeredPane();
        host.add((Component)icon2);
        boolean oldHostVisibile = host.isVisible();
        boolean oldHostOpaque = host.isOpaque();
        host.setVisible(true);
        host.setOpaque(true);
        icon2.updateUI();
        icon2.setBounds((window.getWidth() - icon2.getWidth()) / 2, (window.getHeight() - icon2.getHeight()) / 2, icon2.getWidth(), icon2.getHeight());
        icon2.resume();
        try {
            do {
                icon2.validate();
                icon2.tickAnimation();
                stealer.dispatchEvents(0);
                INSTANCE.sleep();
            } while (!$awaitedValue.isCompleted());
        }
        finally {
            icon2.suspend();
            host.setVisible(oldHostVisibile);
            host.setOpaque(oldHostOpaque);
            icon2.setVisible(false);
            Disposer.dispose((Disposable)disposer);
            host.remove((Component)icon2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showSpinningProgress$lambda$0$0(InputEvent event) {
        Object source = event.getSource();
        if (source instanceof JFrame) {
            ((JFrame)source).dispatchEvent(event);
        }
        return Unit.INSTANCE;
    }

    private static final void showSpinningProgress$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        title = new AtomicReference();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NiceOverlayUi.ClickOutcome.values().length];
            try {
                nArray[NiceOverlayUi.ClickOutcome.DUMP_THREADS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NiceOverlayUi.ClickOutcome.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NiceOverlayUi.ClickOutcome.NOTHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

