/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.concurrency.ThreadContext;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010 \u001a\u00020\u0019H\u0002J\u0012\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\nH\u0002J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0019J\b\u0010%\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/project/SmartModeScheduler;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "sc", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "myRunWhenSmartQueue", "Ljava/util/Deque;", "Ljava/lang/Runnable;", "dumbService", "Lcom/intellij/openapi/project/DumbService;", "getDumbService", "()Lcom/intellij/openapi/project/DumbService;", "filesScannerExecutor", "Lcom/intellij/openapi/project/UnindexedFilesScannerExecutor;", "getFilesScannerExecutor", "()Lcom/intellij/openapi/project/UnindexedFilesScannerExecutor;", "projectDumbState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/openapi/project/DumbService$DumbState;", "projectScanningChanged", "Lkotlinx/coroutines/flow/Flow;", "addLast", "", "runnable", "onStateChanged", "canRunSmart", "", "canRunSmart$intellij_platform_ide_impl", "runWhenSmart", "runAllWhileSmart", "doRun", "getCurrentMode", "", "clear", "dispose", "RunnableDelegate", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSmartModeScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartModeScheduler.kt\ncom/intellij/openapi/project/SmartModeScheduler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n13#2:150\n*S KotlinDebug\n*F\n+ 1 SmartModeScheduler.kt\ncom/intellij/openapi/project/SmartModeScheduler\n*L\n145#1:150\n*E\n"})
public final class SmartModeScheduler
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Deque<Runnable> myRunWhenSmartQueue;
    @NotNull
    private final StateFlow<DumbService.DumbState> projectDumbState;
    @NotNull
    private final Flow<?> projectScanningChanged;
    @NotNull
    private static final Logger LOG;
    public static final int SCANNING = 1;
    public static final int DUMB = 2;

    public SmartModeScheduler(@NotNull Project project2, @NotNull CoroutineScope sc) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        this.project = project2;
        this.myRunWhenSmartQueue = new ConcurrentLinkedDeque();
        this.projectDumbState = this.getDumbService().getState();
        this.projectScanningChanged = this.getFilesScannerExecutor().getStartedOrStoppedEvent();
        this.project.getMessageBus().simpleConnect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                myRunWhenSmartQueue.removeIf(arg_0 -> 1.beforePluginUnload$lambda$1(arg_0 -> 1.beforePluginUnload$lambda$0(pluginDescriptor, arg_0), arg_0));
            }

            private static final boolean beforePluginUnload$lambda$0(IdeaPluginDescriptor $pluginDescriptor, Runnable runnable2) {
                Runnable unwrappedRunnable = runnable2 instanceof RunnableDelegate ? ((RunnableDelegate)runnable2).getTask() : runnable2;
                ClassLoader classLoader = unwrappedRunnable.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                ClassLoader classLoader2 = classLoader;
                return classLoader2 instanceof PluginAwareClassLoader && Intrinsics.areEqual((Object)((PluginAwareClassLoader)classLoader2).getPluginId(), (Object)$pluginDescriptor.getPluginId());
            }

            private static final boolean beforePluginUnload$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
        BuildersKt.launch$default((CoroutineScope)sc, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SmartModeScheduler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.projectScanningChanged.collect(new FlowCollector(){

                            public final Object emit(Object it, Continuation<? super Unit> $completion) {
                                this$0.onStateChanged();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)sc, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SmartModeScheduler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.projectDumbState.collect(new FlowCollector(){

                            public final Object emit(DumbService.DumbState it, Continuation<? super Unit> $completion) {
                                this$0.onStateChanged();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final DumbService getDumbService() {
        return DumbService.Companion.getInstance(this.project);
    }

    private final UnindexedFilesScannerExecutor getFilesScannerExecutor() {
        return UnindexedFilesScannerExecutor.Companion.getInstance(this.project);
    }

    private final void addLast(Runnable runnable2) {
        Runnable executor = ThreadContext.captureThreadContext((Runnable)runnable2);
        this.myRunWhenSmartQueue.addLast(executor == runnable2 ? runnable2 : (Runnable)new RunnableDelegate(runnable2, arg_0 -> SmartModeScheduler.addLast$lambda$1(arg_0 -> SmartModeScheduler.addLast$lambda$0(executor, arg_0), arg_0)));
    }

    private final void onStateChanged() {
        if (this.canRunSmart$intellij_platform_ide_impl()) {
            ApplicationManager.getApplication().invokeLater(this::runAllWhileSmart, ModalityState.defaultModalityState(), this.project.getDisposed());
        }
    }

    public final boolean canRunSmart$intellij_platform_ide_impl() {
        return this.getCurrentMode() == 0;
    }

    public final void runWhenSmart(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        if (this.canRunSmart$intellij_platform_ide_impl() && ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            this.addLast(runnable2);
            this.onStateChanged();
        }
    }

    private final void runAllWhileSmart() {
        ThreadingAssertions.assertEventDispatchThread();
        while (this.canRunSmart$intellij_platform_ide_impl() && this.myRunWhenSmartQueue.pollFirst() != null) {
            Runnable runnable2;
            ThreadContext.resetThreadContext(() -> SmartModeScheduler.runAllWhileSmart$lambda$0(this, runnable2));
        }
    }

    private final void doRun(@Async.Execute Runnable runnable2) {
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("pce", (Throwable)e)};
            LOG.error("Task canceled: " + runnable2, attachmentArray);
        }
        catch (Throwable e) {
            LOG.error("Error executing task " + runnable2, e);
        }
    }

    public final int getCurrentMode() {
        return ((Boolean)this.getFilesScannerExecutor().isRunning().getValue() != false ? 1 : 0) + (((DumbService.DumbState)this.projectDumbState.getValue()).isDumb() ? 2 : 0);
    }

    public final void clear() {
        this.myRunWhenSmartQueue.clear();
    }

    public void dispose() {
        this.clear();
    }

    private static final Unit addLast$lambda$0(Runnable $executor, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $executor.run();
        return Unit.INSTANCE;
    }

    private static final void addLast$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit runAllWhileSmart$lambda$0(SmartModeScheduler this$0, Runnable $runnable) {
        this$0.doRun($runnable);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SmartModeScheduler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/project/SmartModeScheduler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SCANNING", "", "DUMB", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/project/SmartModeScheduler$RunnableDelegate;", "Ljava/lang/Runnable;", "task", "executor", "Ljava/util/function/Consumer;", "<init>", "(Ljava/lang/Runnable;Ljava/util/function/Consumer;)V", "getTask", "()Ljava/lang/Runnable;", "run", "", "intellij.platform.ide.impl"})
    private static final class RunnableDelegate
    implements Runnable {
        @NotNull
        private final Runnable task;
        @NotNull
        private final Consumer<? super Runnable> executor;

        public RunnableDelegate(@NotNull Runnable task, @NotNull Consumer<? super Runnable> executor) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(executor, (String)"executor");
            this.task = task;
            this.executor = executor;
        }

        @NotNull
        public final Runnable getTask() {
            return this.task;
        }

        @Override
        public void run() {
            this.executor.accept(this.task);
        }
    }
}

